/*
 * Decompiled with CFR 0.152.
 */
package org.jscience.geography.coordinates;

import javax.measure.Measure;
import javax.measure.converter.UnitConverter;
import javax.measure.quantity.Length;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import javolution.context.ObjectFactory;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.jscience.geography.coordinates.Coordinates;
import org.jscience.geography.coordinates.crs.CoordinateReferenceSystem;
import org.jscience.geography.coordinates.crs.GeocentricCRS;
import org.jscience.geography.coordinates.crs.ReferenceEllipsoid;
import org.jscience.mathematics.vector.DimensionException;
import org.jscience.mathematics.vector.Float64Vector;
import org.opengis.referencing.cs.CoordinateSystem;

public final class XYZ
extends Coordinates<GeocentricCRS<XYZ>> {
    public static final GeocentricCRS<XYZ> CRS = new GeocentricCRS<XYZ>(){

        @Override
        protected XYZ coordinatesOf(CoordinateReferenceSystem.AbsolutePosition position) {
            double latitude = position.latitudeWGS84.doubleValue(SI.RADIAN);
            double longitude = position.longitudeWGS84.doubleValue(SI.RADIAN);
            double height = position.heightWGS84 != null ? position.heightWGS84.doubleValue(SI.METRE) : 0.0;
            double cosLat = Math.cos(latitude);
            double sinLat = Math.sin(latitude);
            double cosLon = Math.cos(longitude);
            double sinLon = Math.sin(longitude);
            double roc = ReferenceEllipsoid.WGS84.verticalRadiusOfCurvature(latitude);
            double x = (roc + height) * cosLat * cosLon;
            double y = (roc + height) * cosLat * sinLon;
            double z = ((1.0 - ReferenceEllipsoid.WGS84.getEccentricitySquared()) * roc + height) * sinLat;
            return XYZ.valueOf(x, y, z, SI.METRE);
        }

        @Override
        protected CoordinateReferenceSystem.AbsolutePosition positionOf(XYZ coordinates, CoordinateReferenceSystem.AbsolutePosition position) {
            double latitude;
            double x = coordinates._x;
            double y = coordinates._y;
            double z = coordinates._z;
            double longitude = Math.atan2(y, x);
            double xy = Math.hypot(x, y);
            if (xy == 0.0) {
                latitude = z >= 0.0 ? 1.5707963267948966 : -1.5707963267948966;
            } else {
                double a = ReferenceEllipsoid.WGS84.getSemimajorAxis().doubleValue(SI.METRE);
                double b = ReferenceEllipsoid.WGS84.getsSemiminorAxis().doubleValue(SI.METRE);
                double ea2 = ReferenceEllipsoid.WGS84.getEccentricitySquared();
                double eb2 = ReferenceEllipsoid.WGS84.getSecondEccentricitySquared();
                double beta = Math.atan2(a * z, b * xy);
                double numerator = z + b * eb2 * XYZ.cube(Math.sin(beta));
                double denominator = xy - a * ea2 * XYZ.cube(Math.cos(beta));
                latitude = Math.atan2(numerator, denominator);
            }
            double height = xy / Math.cos(latitude) - ReferenceEllipsoid.WGS84.verticalRadiusOfCurvature(latitude);
            position.latitudeWGS84 = Measure.valueOf(latitude, SI.RADIAN);
            position.longitudeWGS84 = Measure.valueOf(longitude, SI.RADIAN);
            position.heightWGS84 = Measure.valueOf(height, SI.METRE);
            return position;
        }

        @Override
        public CoordinateSystem getCoordinateSystem() {
            return GeocentricCRS.XYZ_CS;
        }
    };
    private double _x;
    private double _y;
    private double _z;
    private static final ObjectFactory<XYZ> FACTORY = new ObjectFactory<XYZ>(){

        @Override
        protected XYZ create() {
            return new XYZ();
        }
    };
    static final XMLFormat<XYZ> XML = new XMLFormat<XYZ>(XYZ.class){

        @Override
        public XYZ newInstance(Class<XYZ> cls, XMLFormat.InputElement xml) throws XMLStreamException {
            return (XYZ)FACTORY.object();
        }

        @Override
        public void write(XYZ xyz, XMLFormat.OutputElement xml) throws XMLStreamException {
            xml.setAttribute("x", xyz._x);
            xml.setAttribute("y", xyz._y);
            xml.setAttribute("z", xyz._z);
        }

        @Override
        public void read(XMLFormat.InputElement xml, XYZ xyz) throws XMLStreamException {
            xyz._x = xml.getAttribute("x", 0.0);
            xyz._y = xml.getAttribute("y", 0.0);
            xyz._z = xml.getAttribute("z", 0.0);
        }
    };
    private static final long serialVersionUID = 1L;

    private static double cube(double x) {
        return x * x * x;
    }

    public static XYZ valueOf(double x, double y, double z, Unit<Length> unit) {
        XYZ xyz = FACTORY.object();
        if (unit == SI.METRE) {
            xyz._x = x;
            xyz._y = y;
            xyz._z = z;
        } else {
            UnitConverter toMeter = unit.getConverterTo(SI.METRE);
            xyz._x = toMeter.convert(x);
            xyz._y = toMeter.convert(y);
            xyz._z = toMeter.convert(z);
        }
        return xyz;
    }

    private XYZ() {
    }

    public static XYZ valueOf(Float64Vector vector, Unit<Length> unit) {
        if (vector.getDimension() != 3) {
            throw new DimensionException("3-dimensional vector expected");
        }
        return XYZ.valueOf(vector.getValue(0), vector.getValue(1), vector.getValue(2), unit);
    }

    public double xValue(Unit<Length> unit) {
        return unit == SI.METRE ? this._x : SI.METRE.getConverterTo(unit).convert(this._x);
    }

    public double yValue(Unit<Length> unit) {
        return unit == SI.METRE ? this._y : SI.METRE.getConverterTo(unit).convert(this._y);
    }

    public double zValue(Unit<Length> unit) {
        return unit == SI.METRE ? this._z : SI.METRE.getConverterTo(unit).convert(this._z);
    }

    public Float64Vector toVector(Unit<Length> unit) {
        if (unit == SI.METRE) {
            return Float64Vector.valueOf(this._x, this._y, this._z);
        }
        UnitConverter cvtr = SI.METRE.getConverterTo(unit);
        return Float64Vector.valueOf(cvtr.convert(this._x), cvtr.convert(this._y), cvtr.convert(this._z));
    }

    @Override
    public GeocentricCRS<XYZ> getCoordinateReferenceSystem() {
        return CRS;
    }

    @Override
    public int getDimension() {
        return 3;
    }

    @Override
    public double getOrdinate(int dimension) throws IndexOutOfBoundsException {
        if (dimension == 0) {
            Unit u = GeocentricCRS.XYZ_CS.getAxis(0).getUnit();
            return SI.METRE.getConverterTo(u).convert(this._x);
        }
        if (dimension == 1) {
            Unit u = GeocentricCRS.XYZ_CS.getAxis(1).getUnit();
            return SI.METRE.getConverterTo(u).convert(this._y);
        }
        if (dimension == 2) {
            Unit u = GeocentricCRS.XYZ_CS.getAxis(2).getUnit();
            return SI.METRE.getConverterTo(u).convert(this._z);
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public XYZ copy() {
        return XYZ.valueOf(this._x, this._y, this._z, SI.METRE);
    }
}

