/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.views;

import info.monitorenter.gui.chart.Chart2D;
import info.monitorenter.gui.chart.ITrace2D;
import info.monitorenter.gui.chart.annotations.IAnnotationCreator;
import info.monitorenter.gui.chart.annotations.bubble.AnnotationCreatorBubble;
import info.monitorenter.gui.chart.controls.LayoutFactory;
import info.monitorenter.gui.chart.layouts.FlowLayoutCorrectMinimumSize;
import info.monitorenter.gui.chart.traces.Trace2DLtd;
import info.monitorenter.util.StringUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;

public class ChartPanel
extends JLayeredPane
implements PropertyChangeListener {
    private static final long serialVersionUID = 3905801963714197560L;
    private IAnnotationCreator m_annotationCreator = AnnotationCreatorBubble.getInstance();
    private final Chart2D m_chart;
    protected JPanel m_labelPanel;

    public static void main(String[] args) {
        double[] data = new double[100];
        for (int i = 0; i < 100; ++i) {
            data[i] = Math.random() * (double)i + 1.0;
        }
        JFrame frame = new JFrame("ChartPanel demo");
        Chart2D chart = new Chart2D();
        Trace2DLtd trace1 = new Trace2DLtd(100);
        trace1.setName("Trace 1");
        Trace2DLtd trace2 = new Trace2DLtd(100);
        trace2.setName("Trace 2");
        chart.addTrace(trace1);
        chart.addTrace(trace2);
        for (int i = 0; i < 100; ++i) {
            trace1.addPoint(i + 2, data[i]);
            trace2.addPoint(i + 2, 100.0 - data[i]);
        }
        ChartPanel cPanel = new ChartPanel(chart);
        frame.getContentPane().add(cPanel);
        frame.setSize(new Dimension(400, 600));
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent w) {
                System.exit(0);
            }
        });
        frame.setJMenuBar(LayoutFactory.getInstance().createChartMenuBar(cPanel, false));
        frame.setVisible(true);
    }

    public ChartPanel(Chart2D chart) {
        this(chart, true);
    }

    public ChartPanel(Chart2D chart, boolean adaptUI2Chart) {
        this.m_chart = chart;
        this.setBackground(chart.getBackground());
        chart.setPaintLabels(false);
        LayoutFactory factory = LayoutFactory.getInstance();
        factory.createChartPopupMenu(this, adaptUI2Chart);
        this.setLayout(new BorderLayout());
        this.add((Component)chart, "Center");
        this.m_labelPanel = new JPanel();
        this.m_labelPanel.setFont(chart.getFont());
        this.m_labelPanel.setLayout(new FlowLayoutCorrectMinimumSize(0));
        this.m_labelPanel.setBackground(chart.getBackground());
        for (ITrace2D trace : chart) {
            JLabel label = factory.createTraceContextMenuLabel(chart, trace, true);
            if (label != null) {
                this.m_labelPanel.add(label);
            }
            trace.addPropertyChangeListener("ITrace2D.PROPERTY_PHYSICALUNITS", this);
            trace.addPropertyChangeListener("ITrace2D.PROPERTY_NAME", this);
        }
        this.add((Component)this.m_labelPanel, "South");
        chart.addPropertyChangeListener("background", this);
        chart.addPropertyChangeListener("IAxis.PROPERTY_ADD_REMOVE_TRACE", this);
    }

    private boolean containsTraceLabel(ITrace2D tracetoAdd) {
        boolean result = false;
        Component[] traceLabels = this.m_labelPanel.getComponents();
        String labelName = tracetoAdd.getLabel();
        for (int i = traceLabels.length - 1; i >= 0; --i) {
            JLabel label = (JLabel)traceLabels[i];
            if (!labelName.equals(label.getText())) continue;
            result = true;
            break;
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ChartPanel other = (ChartPanel)obj;
        if (this.m_annotationCreator == null ? other.m_annotationCreator != null : !this.m_annotationCreator.equals(other.m_annotationCreator)) {
            return false;
        }
        if (this.m_chart == null ? other.m_chart != null : !this.m_chart.equals(other.m_chart)) {
            return false;
        }
        return !(this.m_labelPanel == null ? other.m_labelPanel != null : !this.m_labelPanel.equals(other.m_labelPanel));
    }

    public final IAnnotationCreator getAnnotationCreator() {
        return this.m_annotationCreator;
    }

    public final Chart2D getChart() {
        return this.m_chart;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_annotationCreator == null ? 0 : this.m_annotationCreator.hashCode());
        result = 31 * result + (this.m_chart == null ? 0 : this.m_chart.hashCode());
        result = 31 * result + (this.m_labelPanel == null ? 0 : this.m_labelPanel.hashCode());
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String prop = evt.getPropertyName();
        if (prop.equals("background")) {
            Color color = (Color)evt.getNewValue();
            this.setBackground(color);
            this.m_labelPanel.setBackground(color);
            return;
        } else if (prop.equals("IAxis.PROPERTY_ADD_REMOVE_TRACE")) {
            ITrace2D oldTrace = (ITrace2D)evt.getOldValue();
            ITrace2D newTrace = (ITrace2D)evt.getNewValue();
            if (oldTrace == null && newTrace != null) {
                JLabel label;
                if (this.containsTraceLabel(newTrace) || (label = LayoutFactory.getInstance().createTraceContextMenuLabel(this.m_chart, newTrace, true)) == null) return;
                this.m_labelPanel.add(label);
                this.invalidate();
                this.m_labelPanel.invalidate();
                this.validateTree();
                this.m_labelPanel.doLayout();
                return;
            } else {
                Component[] labels;
                if (oldTrace == null || newTrace != null) throw new IllegalArgumentException("Bad property change event for add / remove trace.");
                String labelName = oldTrace.getLabel();
                if (StringUtil.isEmpty(labelName)) return;
                for (Component label2 : labels = this.m_labelPanel.getComponents()) {
                    if (!((JLabel)label2).getText().equals(labelName)) continue;
                    this.disposeTraceLabel((JLabel)label2, oldTrace);
                }
            }
            return;
        } else {
            if (!prop.equals("ITrace2D.PROPERTY_LABEL")) return;
            ITrace2D trace = (ITrace2D)evt.getSource();
            String oldLabel = (String)evt.getOldValue();
            String newLabel = (String)evt.getNewValue();
            if (!StringUtil.isEmpty(oldLabel) && StringUtil.isEmpty(newLabel)) {
                Component[] labels;
                for (Component label2 : labels = this.m_labelPanel.getComponents()) {
                    if (!((JLabel)label2).getText().equals(oldLabel)) continue;
                    ((JLabel)label2).setText("<unnamed>");
                }
                return;
            } else {
                JLabel label;
                if (!StringUtil.isEmpty(oldLabel) || StringUtil.isEmpty(newLabel) || this.containsTraceLabel(trace) || (label = LayoutFactory.getInstance().createTraceContextMenuLabel(this.m_chart, trace, true)) == null) return;
                this.m_labelPanel.add(label);
                this.invalidate();
                this.m_labelPanel.invalidate();
                this.validateTree();
                this.m_labelPanel.doLayout();
            }
        }
    }

    private void disposeTraceLabel(JLabel label, ITrace2D owner) {
        MouseListener[] mouseListeners;
        PropertyChangeListener listenerLabel = (PropertyChangeListener)((Object)label);
        this.m_labelPanel.remove(label);
        for (MouseListener mouseListener2 : mouseListeners = label.getMouseListeners()) {
            this.removeMouseListener(mouseListener2);
        }
        owner.removePropertyChangeListener("ITrace2D.PROPERTY_COLOR", listenerLabel);
        owner.removePropertyChangeListener("ITrace2D.PROPERTY_NAME", listenerLabel);
        owner.removePropertyChangeListener("ITrace2D.PROPERTY_PHYSICALUNITS", listenerLabel);
        this.m_labelPanel.doLayout();
        this.doLayout();
    }

    public final void setAnnotationCreator(IAnnotationCreator annotationCreator) {
        this.m_annotationCreator = annotationCreator;
    }
}

