/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.events;

import info.monitorenter.gui.chart.Chart2D;
import info.monitorenter.gui.chart.events.AChart2DAction;
import info.monitorenter.gui.chart.io.FileFilterExtensions;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.apache.xmlgraphics.java2d.GraphicContext;
import org.apache.xmlgraphics.java2d.ps.EPSDocumentGraphics2D;

public final class Chart2DActionSaveEpsSingletonApacheFop {
    private static final long serialVersionUID = -7446202109342192546L;
    public static final boolean EPS_SUPPORTED;
    private static Map<String, Action> instances;

    public static Action getInstance(Chart2D chart, String actionName) {
        Action result = instances.get(Chart2DActionSaveEpsSingletonApacheFop.key(chart));
        if (result == null) {
            result = EPS_SUPPORTED ? new Chart2DActionSaveEps(chart, actionName) : new ActionDisabledDummy(actionName);
            instances.put(Chart2DActionSaveEpsSingletonApacheFop.key(chart), result);
        }
        return result;
    }

    private static String key(Chart2D chart) {
        return chart.getClass().getName() + chart.hashCode();
    }

    private Chart2DActionSaveEpsSingletonApacheFop() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        instances = new HashMap<String, Action>();
        Class<?> test = null;
        try {
            test = Class.forName("org.apache.xmlgraphics.java2d.ps.EPSDocumentGraphics2D");
        }
        catch (Throwable throwable) {
        }
        finally {
            EPS_SUPPORTED = test != null;
        }
    }

    private static final class Chart2DActionSaveEps
    extends AChart2DAction {
        private static final long serialVersionUID = 4165725826047395414L;
        private JFileChooser m_filechooser;

        public Chart2DActionSaveEps(Chart2D chart, String colorName) {
            super(chart, colorName);
            chart.addPropertyChangeListener("Chart2D.PROPERTY_GRID_COLOR", this);
            this.m_filechooser = new JFileChooser();
            this.m_filechooser.setAcceptAllFileFilterUsed(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FileFilter[] farr = this.m_filechooser.getChoosableFileFilters();
            for (int i = 0; i < farr.length; ++i) {
                this.m_filechooser.removeChoosableFileFilter(farr[i]);
            }
            String extension = "eps";
            this.m_filechooser.addChoosableFileFilter(new FileFilterExtensions(new String[]{extension}));
            int ret = this.m_filechooser.showSaveDialog(this.m_chart);
            if (ret == 0) {
                File file = new File(this.m_filechooser.getSelectedFile().getAbsolutePath() + "." + extension);
                try {
                    FileOutputStream outStream = new FileOutputStream(file);
                    EPSDocumentGraphics2D g2d = new EPSDocumentGraphics2D(true);
                    g2d.setGraphicContext(new GraphicContext());
                    g2d.setupDocument((OutputStream)outStream, this.m_chart.getWidth(), this.m_chart.getHeight());
                    this.m_chart.paint((Graphics)g2d);
                    outStream.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
        }
    }

    private static class ActionDisabledDummy
    extends AbstractAction {
        private static final long serialVersionUID = 5537391176736852739L;

        public ActionDisabledDummy(String name) {
            super(name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }

        @Override
        public boolean isEnabled() {
            return false;
        }
    }
}

