/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.demos;

import info.monitorenter.gui.chart.Chart2D;
import info.monitorenter.gui.chart.IAxis;
import info.monitorenter.gui.chart.IPointPainter;
import info.monitorenter.gui.chart.axis.AxisLinear;
import info.monitorenter.gui.chart.labelformatters.LabelFormatterDate;
import info.monitorenter.gui.chart.pointpainters.PointPainterDisc;
import info.monitorenter.gui.chart.rangepolicies.RangePolicyFixedViewport;
import info.monitorenter.gui.chart.traces.Trace2DSimple;
import info.monitorenter.gui.chart.traces.painters.TracePainterVerticalBar;
import info.monitorenter.gui.chart.views.ChartPanel;
import info.monitorenter.util.Range;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Set;
import javax.swing.JFrame;
import javax.swing.UIManager;

public final class AdvancedStaticChart {
    public static void main(String[] args) throws ParseException {
        Chart2D chart = new Chart2D();
        IAxis<?> axisX = chart.getAxisX();
        IAxis<?> axisY = chart.getAxisY();
        chart.setGridColor(Color.LIGHT_GRAY);
        axisX.setPaintGrid(true);
        axisY.setPaintGrid(true);
        Trace2DSimple trace = new Trace2DSimple();
        chart.addTrace(trace);
        trace.setTracePainter(new TracePainterVerticalBar(4, chart));
        trace.setColor(Color.ORANGE);
        Font titleFont = UIManager.getDefaults().getFont("Label.font").deriveFont(14.0f).deriveFont(1);
        IAxis.AxisTitle axisTitle = axisY.getAxisTitle();
        axisTitle.setTitleFont(titleFont);
        axisTitle.setTitle("hoppelhase");
        axisY.setFormatter(new LabelFormatterDate(new SimpleDateFormat()));
        axisTitle = axisX.getAxisTitle();
        axisTitle.setTitle("emil");
        axisTitle.setTitleFont(titleFont);
        axisX.setRangePolicy(new RangePolicyFixedViewport(new Range(0.0, 220.0)));
        chart.setToolTipType(Chart2D.ToolTipType.VALUE_SNAP_TO_TRACEPOINTS);
        Set<IPointPainter<?>> highlighters = trace.getPointHighlighters();
        highlighters.clear();
        trace.addPointHighlighter(new PointPainterDisc(20));
        chart.enablePointHighlighting(true);
        double high = System.currentTimeMillis();
        for (double i = 0.0; i < 20.0; i += 1.0) {
            trace.addPoint(i * 10.0, high);
            high += 50000.0;
        }
        AxisLinear axisXTop = new AxisLinear(new LabelFormatterDate(new SimpleDateFormat("")));
        axisXTop.setPaintScale(false);
        AxisLinear axisYRight = new AxisLinear(new LabelFormatterDate(new SimpleDateFormat("")));
        axisYRight.setPaintScale(false);
        chart.setAxisXTop(axisXTop, 0);
        chart.setAxisYRight(axisYRight, 0);
        JFrame frame = new JFrame("AdvancedStaticChart");
        frame.getContentPane().add(new ChartPanel(chart));
        frame.setSize(600, 600);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        frame.setVisible(true);
    }

    private AdvancedStaticChart() {
    }
}

