/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.annotations.bubble;

import info.monitorenter.gui.chart.annotations.AAnnotationContentComponent;
import info.monitorenter.gui.chart.views.ChartPanel;
import info.monitorenter.util.UIUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class AnnotationBubble
extends JPanel {
    public static final int PADDING = 8;
    private DragListener m_dragListener;
    private boolean m_outlineDragMode = true;
    private static final long serialVersionUID = -3668420139916533725L;
    protected ChartPanel m_chartPanel;
    protected AAnnotationContentComponent m_content;
    protected JComponent m_titleBar;

    public AnnotationBubble(ChartPanel chartPanel, AAnnotationContentComponent annotationContent, boolean useDragListenerOnAnnotationContent, boolean useTitleBar) {
        this.m_chartPanel = chartPanel;
        this.m_content = annotationContent;
        this.setBackground(new Color(255, 254, 233, 136));
        this.m_dragListener = new DragListener();
        this.setLayout(new BoxLayout(this, 1));
        if (useTitleBar) {
            this.m_titleBar = new AnnotationTitleBar();
            this.add(this.m_titleBar);
        }
        this.calculateSize();
        if (useDragListenerOnAnnotationContent) {
            annotationContent.addMouseMotionListener(this.m_dragListener);
            annotationContent.addMouseListener(this.m_dragListener);
            annotationContent.setBackground(this.getBackground());
        }
        this.add(annotationContent);
        this.add(Box.createVerticalStrut(8));
    }

    private void calculateSize() {
        Dimension d = this.m_content.getPreferredSize();
        double width = d.getWidth() + 4.0;
        double height = d.getHeight() + 4.0;
        if (this.m_titleBar != null) {
            height += this.m_titleBar.getPreferredSize().getHeight();
        }
        this.setSize(new Dimension((int)width, (int)height));
    }

    public boolean isDragged() {
        boolean result = null != this.m_dragListener.m_lastDragPosition;
        return result;
    }

    public final boolean isOutlineDragMode() {
        return this.m_outlineDragMode;
    }

    @Override
    public final void paint(Graphics g) {
        super.paint(g);
    }

    @Override
    protected void paintComponent(Graphics g) {
        Color backupColor = g.getColor();
        g.setColor(Color.BLACK);
        Dimension size = this.getSize();
        g.drawRoundRect(0, 0, size.width - 1, size.height - 1, 10, 10);
        if (!this.isDragged() || !this.isOutlineDragMode()) {
            g.setColor(this.getBackground());
            g.fillRoundRect(1, 1, size.width - 2, size.height - 2, 8, 8);
        }
        g.setColor(backupColor);
    }

    public final void setOutlineDragMode(boolean outlineDragMode) {
        this.m_outlineDragMode = outlineDragMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTransparency(double zeroToOneAlpha) {
        assert (zeroToOneAlpha >= 0.0 && zeroToOneAlpha < 1.0);
        Color bgColor = this.getBackground();
        AnnotationBubble annotationBubble = this;
        synchronized (annotationBubble) {
            if (zeroToOneAlpha != 0.0) {
                int alphaInt = (int)zeroToOneAlpha * 255;
                if (bgColor.getAlpha() != alphaInt) {
                    this.setBackground(new Color(bgColor.getRed(), bgColor.getGreen(), bgColor.getBlue(), alphaInt));
                }
            } else if (bgColor.getAlpha() > 0) {
                this.setBackground(new Color(bgColor.getRed(), bgColor.getGreen(), bgColor.getBlue()));
            }
        }
    }

    public class DragListener
    implements MouseMotionListener,
    MouseListener {
        protected Point m_lastDragPosition;

        protected DragListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (this.m_lastDragPosition != null) {
                Point pointNow = UIUtil.getLocationOnScreen(e);
                double deltaX = pointNow.getX() - this.m_lastDragPosition.getX();
                double deltaY = pointNow.getY() - this.m_lastDragPosition.getY();
                Point panelPos = AnnotationBubble.this.getLocation();
                panelPos.x = (int)((double)panelPos.x + deltaX);
                panelPos.y = (int)((double)panelPos.y + deltaY);
                AnnotationBubble.this.setLocation(panelPos);
                this.m_lastDragPosition = pointNow;
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.m_lastDragPosition = UIUtil.getLocationOnScreen(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.m_lastDragPosition = null;
            AnnotationBubble.this.repaint();
        }
    }

    public class AnnotationTitleBar
    extends JPanel {
        private static final long serialVersionUID = 4182197132940971837L;
        private JButton m_closeButton;

        public AnnotationTitleBar() {
            this.setOpaque(true);
            this.setBackground(AnnotationBubble.this.getBackground());
            DragListener dragListener = AnnotationBubble.this.m_dragListener;
            this.addMouseListener(dragListener);
            this.addMouseMotionListener(dragListener);
            AbstractAction closeAction = new AbstractAction(){
                private static final long serialVersionUID = 800535446184152788L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    AnnotationBubble.this.setVisible(false);
                    AnnotationBubble.this.m_chartPanel.remove(AnnotationBubble.this);
                }
            };
            Icon closeIcon = UIManager.getIcon("InternalFrame.closeIcon");
            closeAction.putValue("SmallIcon", closeIcon);
            this.m_closeButton = new JButton(closeAction);
            this.m_closeButton.setContentAreaFilled(false);
            this.m_closeButton.setBorderPainted(false);
            this.m_closeButton.setFocusable(false);
            this.setLayout(new BoxLayout(this, 0));
            this.add(Box.createHorizontalGlue());
            this.add(this.m_closeButton);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension result = null;
            if (this.isPreferredSizeSet()) {
                result = super.getPreferredSize();
            } else {
                Dimension closeButtonDim = this.m_closeButton.getPreferredSize();
                Font font = this.getFont();
                FontMetrics fontMetrics = this.getFontMetrics(font);
                int fontHeight = fontMetrics.getHeight();
                int closeButtonHeight = (int)closeButtonDim.getHeight();
                int height = Math.max(fontHeight, closeButtonHeight);
                result = new Dimension((int)closeButtonDim.getWidth(), height);
            }
            return result;
        }

        @Override
        public final void paint(Graphics g) {
            super.paint(g);
        }

        @Override
        protected final void paintBorder(Graphics g) {
            super.paintBorder(g);
        }

        @Override
        protected final void paintChildren(Graphics g) {
            super.paintChildren(g);
        }

        @Override
        protected void paintComponent(Graphics g) {
            Color backupColor = g.getColor();
            g.setColor(Color.BLACK);
            Dimension size = this.getSize();
            g.drawRoundRect(0, 0, size.width - 1, size.height + 10, 10, 10);
            if (!AnnotationBubble.this.isDragged() || !AnnotationBubble.this.isOutlineDragMode()) {
                g.setColor(this.getBackground());
                g.fillRoundRect(1, 1, size.width - 2, size.height + 10, 10, 10);
            }
            g.setColor(backupColor);
        }
    }
}

