/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart;

import info.monitorenter.gui.chart.IAxisLabelFormatter;
import info.monitorenter.gui.chart.IAxisScalePolicy;
import info.monitorenter.gui.chart.IAxisTitlePainter;
import info.monitorenter.gui.chart.IRangePolicy;
import info.monitorenter.gui.chart.ITrace2D;
import info.monitorenter.gui.chart.axis.AAxis;
import info.monitorenter.gui.chart.axistitlepainters.AxisTitlePainterDefault;
import info.monitorenter.util.Range;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.Set;

public interface IAxis<T extends IAxisScalePolicy>
extends Serializable {
    public static final String PROPERTY_ADD_REMOVE_TRACE = "IAxis.PROPERTY_ADD_REMOVE_TRACE";
    public static final String PROPERTY_AXIS_SCALE_POLICY_CHANGED = "IAxis.PROPERTY_AXIS_SCALE_POLICY_CHANGED";
    public static final String PROPERTY_LABELFORMATTER = "IAxis.PROPERTY_LABELFORMATTER";
    public static final String PROPERTY_PAINTGRID = "IAxis.PROPERTY_PAINTGRID";
    public static final String PROPERTY_PAINTSCALE = "IAxis.PROPERTY_PAINTSCALE";
    public static final String PROPERTY_RANGEPOLICY = "IAxis.PROPERTY_RANGEPOLICY";

    public void addPropertyChangeListener(String var1, PropertyChangeListener var2);

    public boolean addTrace(ITrace2D var1);

    public AAxis.AChart2DDataAccessor getAccessor();

    public int getAxisPosition();

    public AxisTitle getAxisTitle();

    public AxisTitle removeAxisTitle();

    public int getDimension();

    public String getDimensionString();

    public IAxisLabelFormatter getFormatter();

    public int getHeight(Graphics var1);

    public double getMajorTickSpacing();

    public double getMax();

    public double getMaxValue();

    public double getMin();

    public double getMinorTickSpacing();

    public double getMinValue();

    public int getPixelXLeft();

    public int getPixelXRight();

    public int getPixelYBottom();

    public int getPixelYTop();

    public PropertyChangeListener[] getPropertyChangeListeners(String var1);

    public Range getRange();

    public IRangePolicy getRangePolicy();

    public double getScaledValue(double var1);

    public IAxisScalePolicy getAxisScalePolicy();

    public IAxisScalePolicy setAxisScalePolicy(T var1);

    @Deprecated
    public String getTitle();

    @Deprecated
    public IAxisTitlePainter getTitlePainter();

    public Set<ITrace2D> getTraces();

    public int getWidth(Graphics var1);

    public boolean hasTrace(ITrace2D var1);

    public void initPaintIteration();

    public boolean isDirtyScaling();

    public boolean isPaintGrid();

    public boolean isPaintScale();

    public boolean isStartMajorTick();

    public boolean isVisible();

    public void paint(Graphics var1);

    public int paintTitle(Graphics var1);

    public Set<ITrace2D> removeAllTraces();

    public void removePropertyChangeListener(String var1, PropertyChangeListener var2);

    public boolean removeTrace(ITrace2D var1);

    public void scale();

    public void scaleTrace(ITrace2D var1);

    public void setAxisTitle(AxisTitle var1);

    public void setFormatter(IAxisLabelFormatter var1);

    public void setMajorTickSpacing(double var1);

    public void setMinorTickSpacing(double var1);

    public void setPaintGrid(boolean var1);

    public void setPaintScale(boolean var1);

    public void setPixelXLeft(int var1);

    public void setPixelXRight(int var1);

    public void setPixelYBottom(int var1);

    public void setPixelYTop(int var1);

    public void setRange(Range var1);

    public void setRangePolicy(IRangePolicy var1);

    public void setStartMajorTick(boolean var1);

    @Deprecated
    public String setTitle(String var1);

    @Deprecated
    public IAxisTitlePainter setTitlePainter(IAxisTitlePainter var1);

    public void setVisible(boolean var1);

    public double translatePxToValue(int var1);

    public int translateValueToPx(double var1);

    public static final class AxisTitle
    implements Cloneable,
    Serializable {
        public static final String PROPERTY_TITLE = "IAxis.AxisTitle.PROPERTY_TITLE";
        public static final String PROPERTY_TITLECOLOR = "IAxis.AxisTitle.PROPERTY_TITLECOLOR";
        public static final String PROPERTY_TITLEFONT = "IAxis.AxisTitle.PROPERTY_TITLEFONT";
        public static final String PROPERTY_TITLEPAINTER = "IAxis.AxisTitle.PROPERTY_TITLEPAINTER";
        private static final long serialVersionUID = -7734801964168791096L;
        private PropertyChangeSupport m_propertyChangeSupport = new PropertyChangeSupport(this);
        private String m_title;
        private Color m_titleColor = Color.BLACK;
        private Font m_titleFont;
        private IAxisTitlePainter m_titlePainter;

        public AxisTitle(String title) {
            this(title, new AxisTitlePainterDefault());
        }

        public AxisTitle(String title, IAxisTitlePainter painter) {
            this.m_title = title;
            this.m_titlePainter = painter;
        }

        public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
            this.m_propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
        }

        protected Object clone() throws CloneNotSupportedException {
            Object result = super.clone();
            return result;
        }

        public int getHeight(IAxis<?> axis, Graphics2D g2d) {
            return this.m_titlePainter.getHeight(axis, g2d);
        }

        public PropertyChangeListener[] getPropertyChangeListeners(String propertyName) {
            return this.m_propertyChangeSupport.getPropertyChangeListeners(propertyName);
        }

        public final String getTitle() {
            return this.m_title;
        }

        public Color getTitleColor() {
            return this.m_titleColor;
        }

        public Font getTitleFont() {
            return this.m_titleFont;
        }

        public final IAxisTitlePainter getTitlePainter() {
            return this.m_titlePainter;
        }

        public int getWidth(IAxis<?> axis, Graphics2D g2d) {
            return this.m_titlePainter.getWidth(axis, g2d);
        }

        public void removePropertyChangeListener(String property, PropertyChangeListener listener) {
            this.m_propertyChangeSupport.removePropertyChangeListener(property, listener);
        }

        public final String setTitle(String title) {
            String old = this.m_title;
            this.m_title = title;
            this.m_propertyChangeSupport.firePropertyChange(PROPERTY_TITLE, old, this.m_title);
            return old;
        }

        public void setTitleColor(Color color) {
            Color old = this.m_titleColor;
            this.m_titleColor = color;
            this.m_propertyChangeSupport.firePropertyChange(PROPERTY_TITLECOLOR, old, this.m_titleColor);
        }

        public void setTitleFont(Font font) {
            Font old = this.m_titleFont;
            this.m_titleFont = font;
            this.m_propertyChangeSupport.firePropertyChange(PROPERTY_TITLEFONT, old, this.m_titleFont);
        }

        public final IAxisTitlePainter setTitlePainter(IAxisTitlePainter titlePainter) {
            IAxisTitlePainter old = this.m_titlePainter;
            this.m_titlePainter = titlePainter;
            this.m_propertyChangeSupport.firePropertyChange(PROPERTY_TITLEPAINTER, old, this.m_titlePainter);
            return old;
        }
    }
}

