/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.util;

import java.util.List;
import org.jquantlib.lang.exceptions.LibraryException;

public class Std {
    public static <T> int lowerBound(List<T> valueList, int fromIdx, int toIdx, Comparable<T> value) {
        int len = toIdx - fromIdx + (toIdx > fromIdx ? 1 : 0);
        int from = fromIdx;
        while (len > 0) {
            int half = len >> 1;
            int middle = from;
            if (value.compareTo(valueList.get(middle += half)) == 1) {
                from = middle;
                ++from;
                len = len - half - 1;
                continue;
            }
            len = half;
        }
        return from;
    }

    public static <T> int lowerBound(List<T> valueList, Comparable<T> value) {
        return Std.lowerBound(valueList, 0, valueList != null && !valueList.isEmpty() ? valueList.size() - 1 : 0, value);
    }

    public static <T> int upperBound(List<T> valueList, int fromIdx, int toIdx, Comparable<T> value) {
        int len = toIdx - fromIdx + (toIdx > fromIdx ? 1 : 0);
        int from = fromIdx;
        while (len > 0) {
            int half = len >> 1;
            int middle = from;
            if (value.compareTo(valueList.get(middle += half)) == -1) {
                len = half;
                continue;
            }
            from = middle;
            ++from;
            len = len - half - 1;
        }
        return from;
    }

    public static <T> int upperBound(List<T> valueList, Comparable<T> value) {
        return Std.upperBound(valueList, 0, valueList != null && !valueList.isEmpty() ? valueList.size() - 1 : 0, value);
    }

    public static <T> int distance(List<T> values, int first, int last) {
        int size = last - first;
        return size;
    }

    public static <T> int copy(List<T> from, int first, int last, List<T> to) {
        int i;
        for (i = first; i < last; ++i) {
            to.add(from.get(i));
        }
        return i;
    }

    public static <T> int copy(List<T> from, int first, int last, List<T> to, int toFrom) {
        while (first < last) {
            to.set(toFrom++, from.get(first++));
        }
        return toFrom;
    }

    public static <T> void fill(List<T> array, int from, int last, T value) {
        for (int i = from; i < last; ++i) {
            array.set(i, value);
        }
    }

    public static <T> boolean equal(List<T> first, int from, int last, List<T> second, int secondFrom) {
        while (from < last) {
            if (!first.get(from).equals(second.get(secondFrom))) {
                return false;
            }
            ++from;
            ++secondFrom;
        }
        return true;
    }

    public static <T> boolean equal(List<T> first, List<T> second) {
        if (first.size() != second.size()) {
            return false;
        }
        return Std.equal(first, 0, first.size(), second, 0);
    }

    public static <T extends Number> int transform(List<T> list1, int first1, int last1, List<T> list2, int first2, List<T> result, BinaryOperator<T> binaryOp) {
        int idx = 0;
        while (first1 < last1) {
            Number v1 = (Number)list1.get(first1);
            Number v2 = (Number)list2.get(first2);
            Number r = binaryOp.op(v1, v2);
            result.set(idx, r);
            ++first1;
            ++first2;
            ++idx;
        }
        return idx;
    }

    public class Bind2nd<T extends Number> {
        public BinaryOperator<T> bind2nd(T x) {
            throw new LibraryException("Unsupported operation");
        }
    }

    public class Plus<T extends Number>
    extends BinaryOperator<T> {
        public Plus() {
            super(OpType.Plus);
        }
    }

    public class UninaryOperator<T extends Number>
    extends Operator<T> {
        public UninaryOperator(OpType op) {
            super(op);
        }
    }

    public class BinaryOperator<T extends Number>
    extends Operator<T> {
        public BinaryOperator(OpType op) {
            super(op);
        }

        @Override
        public T op(T t1, T t2) {
            return t1;
        }
    }

    public class Operator<T extends Number> {
        protected OpType op;

        public Operator(OpType o) {
            this.op = o;
        }

        public T op(T t1) {
            return t1;
        }

        public T op(T t1, T t2) {
            return t1;
        }

        public Double op(Double t1) {
            switch (this.op) {
                case Plus: {
                    t1 = t1 + 1.0;
                    return t1;
                }
                case Sub: {
                    t1 = t1 - 1.0;
                    return t1;
                }
            }
            throw new LibraryException("Unsupported operation");
        }

        public Double op(Double t1, Double t2) {
            switch (this.op) {
                case Plus: {
                    return t1 + t2;
                }
                case Sub: {
                    return t1 - t2;
                }
                case Div: {
                    return t1 / t2;
                }
                case Mult: {
                    return t1 * t2;
                }
            }
            throw new LibraryException("Unsupported operation");
        }

        public Integer op(Integer t1, Integer t2) {
            switch (this.op) {
                case Plus: {
                    return t1 + t2;
                }
                case Sub: {
                    return t1 - t2;
                }
                case Div: {
                    return t1 / t2;
                }
                case Mult: {
                    return t1 * t2;
                }
            }
            throw new LibraryException("Unsupported operation");
        }

        public Long op(Long t1, Long t2) {
            switch (this.op) {
                case Plus: {
                    return t1 + t2;
                }
                case Sub: {
                    return t1 - t2;
                }
                case Div: {
                    return t1 / t2;
                }
                case Mult: {
                    return t1 * t2;
                }
            }
            throw new LibraryException("Unsupported operation");
        }
    }

    public static enum OpType {
        Plus,
        Sub,
        Div,
        Mult;

    }
}

