/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.util;

import java.util.List;
import org.jquantlib.util.DefaultObservable;
import org.jquantlib.util.Observable;
import org.jquantlib.util.Observer;

public abstract class LazyObject
implements Observer,
Observable {
    protected boolean calculated = false;
    protected boolean frozen = false;
    private final Observable delegatedObservable = new DefaultObservable(this);

    protected abstract void performCalculations() throws ArithmeticException;

    public final void recalculate() {
        boolean wasFrozen = this.frozen;
        this.frozen = false;
        this.calculated = false;
        try {
            this.calculate();
        }
        finally {
            this.frozen = wasFrozen;
            this.notifyObservers();
        }
    }

    public final void freeze() {
        this.frozen = true;
    }

    public final void unfreeze() {
        this.frozen = false;
        this.notifyObservers();
    }

    protected void calculate() {
        if (!this.calculated && !this.frozen) {
            this.calculated = true;
            try {
                this.performCalculations();
            }
            catch (ArithmeticException e) {
                this.calculated = false;
                throw e;
            }
        }
    }

    @Override
    public void update() {
        if (!this.frozen && this.calculated) {
            this.notifyObservers();
        }
        this.calculated = false;
    }

    @Override
    public final void addObserver(Observer observer) {
        this.delegatedObservable.addObserver(observer);
    }

    @Override
    public final int countObservers() {
        return this.delegatedObservable.countObservers();
    }

    @Override
    public final void deleteObserver(Observer observer) {
        this.delegatedObservable.deleteObserver(observer);
    }

    @Override
    public final void notifyObservers() {
        this.delegatedObservable.notifyObservers();
    }

    @Override
    public final void notifyObservers(Object arg) {
        this.delegatedObservable.notifyObservers(arg);
    }

    @Override
    public final void deleteObservers() {
        this.delegatedObservable.deleteObservers();
    }

    @Override
    public final List<Observer> getObservers() {
        return this.delegatedObservable.getObservers();
    }
}

