/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.util;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jquantlib.QL;
import org.jquantlib.util.Observable;
import org.jquantlib.util.Observer;

public class DefaultObservable
implements Observable {
    private static final String OBSERVABLE_IS_NULL = "observable is null";
    private static final String CANNOT_NOTIFY_OBSERVERS = "could not notify one or more observers";
    private final List<Observer> observers;
    private final Observable observable;

    public DefaultObservable(Observable observable) {
        QL.require(observable != null, OBSERVABLE_IS_NULL);
        this.observers = new CopyOnWriteArrayList<Observer>();
        this.observable = observable;
    }

    @Override
    public void addObserver(Observer observer) {
        this.observers.add(observer);
    }

    @Override
    public int countObservers() {
        return this.observers.size();
    }

    @Override
    public List<Observer> getObservers() {
        return Collections.unmodifiableList(this.observers);
    }

    @Override
    public void deleteObserver(Observer observer) {
        this.observers.remove(observer);
    }

    @Override
    public void deleteObservers() {
        this.observers.clear();
    }

    @Override
    public void notifyObservers() {
        this.notifyObservers(null);
    }

    @Override
    public void notifyObservers(Object arg) {
        Exception exception = null;
        for (Observer observer : this.observers) {
            try {
                this.wrappedNotify(observer, this.observable, arg);
            }
            catch (Exception e) {
                exception = e;
            }
        }
        if (exception != null) {
            QL.error(CANNOT_NOTIFY_OBSERVERS, exception);
        }
    }

    protected void wrappedNotify(Observer observer, Observable observable, Object arg) {
        observer.update();
    }
}

