/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.time.calendars;

import org.jquantlib.lang.annotation.QualityAssurance;
import org.jquantlib.lang.exceptions.LibraryException;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.Date;
import org.jquantlib.time.Month;
import org.jquantlib.time.Weekday;

@QualityAssurance(quality=QualityAssurance.Quality.Q3_DOCUMENTATION, version=QualityAssurance.Version.V097, reviewers={"Zahid Hussain"})
public class UnitedStates
extends Calendar {
    public UnitedStates() {
        this(Market.SETTLEMENT);
    }

    public UnitedStates(Market market) {
        switch (market) {
            case SETTLEMENT: {
                this.impl = new SettlementImpl();
                break;
            }
            case NYSE: {
                this.impl = new NyseImpl();
                break;
            }
            case GOVERNMENTBOND: {
                this.impl = new GovernmentBondImpl();
                break;
            }
            case NERC: {
                this.impl = new NercImpl();
                break;
            }
            default: {
                throw new LibraryException("Unknown market");
            }
        }
    }

    private final class NercImpl
    extends Calendar.WesternImpl {
        private NercImpl() {
        }

        @Override
        public String name() {
            return "North American Energy Reliability Council";
        }

        @Override
        public boolean isBusinessDay(Date date) {
            Weekday w = date.weekday();
            int d = date.dayOfMonth();
            Month m = date.month();
            return !(this.isWeekend(w) || (d == 1 || d == 2 && w == Weekday.Monday) && m == Month.January || d >= 25 && w == Weekday.Monday && m == Month.May || (d == 4 || d == 5 && w == Weekday.Monday) && m == Month.July || d <= 7 && w == Weekday.Monday && m == Month.September || d >= 22 && d <= 28 && w == Weekday.Thursday && m == Month.November) && (d != 25 && (d != 26 || w != Weekday.Monday) || m != Month.December);
        }
    }

    private final class GovernmentBondImpl
    extends Calendar.WesternImpl {
        private GovernmentBondImpl() {
        }

        @Override
        public String name() {
            return "US government bond market";
        }

        @Override
        public boolean isBusinessDay(Date date) {
            Weekday w = date.weekday();
            int d = date.dayOfMonth();
            int dd = date.dayOfYear();
            Month m = date.month();
            int y = date.year();
            int em = this.easterMonday(y);
            return !(this.isWeekend(w) || (d == 1 || d == 2 && w == Weekday.Monday) && m == Month.January || d >= 15 && d <= 21 && w == Weekday.Monday && m == Month.January || d >= 15 && d <= 21 && w == Weekday.Monday && m == Month.February || dd == em - 3 || d >= 25 && w == Weekday.Monday && m == Month.May || (d == 4 || d == 5 && w == Weekday.Monday || d == 3 && w == Weekday.Friday) && m == Month.July || d <= 7 && w == Weekday.Monday && m == Month.September || d >= 8 && d <= 14 && w == Weekday.Monday && m == Month.October || (d == 11 || d == 12 && w == Weekday.Monday || d == 10 && w == Weekday.Friday) && m == Month.November || d >= 22 && d <= 28 && w == Weekday.Thursday && m == Month.November) && (d != 25 && (d != 26 || w != Weekday.Monday) && (d != 24 || w != Weekday.Friday) || m != Month.December);
        }
    }

    private final class NyseImpl
    extends Calendar.WesternImpl {
        private NyseImpl() {
        }

        @Override
        public String name() {
            return "New York stock exchange";
        }

        @Override
        public boolean isBusinessDay(Date date) {
            Weekday w = date.weekday();
            int d = date.dayOfMonth();
            int dd = date.dayOfYear();
            Month m = date.month();
            int y = date.year();
            int em = this.easterMonday(y);
            if (this.isWeekend(w) || (d == 1 || d == 2 && w == Weekday.Monday) && m == Month.January || d >= 15 && d <= 21 && w == Weekday.Monday && m == Month.February || dd == em - 3 || d >= 25 && w == Weekday.Monday && m == Month.May || (d == 4 || d == 5 && w == Weekday.Monday || d == 3 && w == Weekday.Friday) && m == Month.July || d <= 7 && w == Weekday.Monday && m == Month.September || d >= 22 && d <= 28 && w == Weekday.Thursday && m == Month.November || (d == 25 || d == 26 && w == Weekday.Monday || d == 24 && w == Weekday.Friday) && m == Month.December) {
                return false;
            }
            return !(y >= 1998 ? d >= 15 && d <= 21 && w == Weekday.Monday && m == Month.January || y == 2004 && m == Month.June && d == 11 || y == 2001 && m == Month.September && 11 <= d && d <= 14 || y == 2007 && m == Month.January && d == 2 : (y <= 1980 ? y % 4 == 0 && m == Month.November && d <= 7 && w == Weekday.Tuesday || y == 1977 && m == Month.July && d == 14 || y == 1973 && m == Month.January && d == 25 || y == 1972 && m == Month.December && d == 28 || y == 1969 && m == Month.July && d == 21 || y == 1969 && m == Month.March && d == 31 || y == 1969 && m == Month.February && d == 10 || y == 1968 && m == Month.July && d == 5 || y == 1968 && dd >= 163 && w == Weekday.Wednesday : y == 1994 && m == Month.April && d == 27));
        }
    }

    private final class SettlementImpl
    extends Calendar.WesternImpl {
        private SettlementImpl() {
        }

        @Override
        public String name() {
            return "US settlement";
        }

        @Override
        public boolean isBusinessDay(Date date) {
            Weekday w = date.weekday();
            int d = date.dayOfMonth();
            int dd = date.dayOfYear();
            Month m = date.month();
            int y = date.year();
            int em = this.easterMonday(y);
            return !(this.isWeekend(w) || (d == 1 || d == 2 && w == Weekday.Monday) && m == Month.January || d == 31 && w == Weekday.Friday && m == Month.December || d >= 15 && d <= 21 && w == Weekday.Monday && m == Month.January || d >= 15 && d <= 21 && w == Weekday.Monday && m == Month.February || d >= 25 && w == Weekday.Monday && m == Month.May || (d == 4 || d == 5 && w == Weekday.Monday || d == 3 && w == Weekday.Friday) && m == Month.July || d <= 7 && w == Weekday.Monday && m == Month.September || d >= 8 && d <= 14 && w == Weekday.Monday && m == Month.October || (d == 11 || d == 12 && w == Weekday.Monday || d == 10 && w == Weekday.Friday) && m == Month.November || d >= 22 && d <= 28 && w == Weekday.Thursday && m == Month.November) && (d != 25 && (d != 26 || w != Weekday.Monday) && (d != 24 || w != Weekday.Friday) || m != Month.December);
        }
    }

    public static enum Market {
        SETTLEMENT,
        NYSE,
        GOVERNMENTBOND,
        NERC;

    }
}

