/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.time.calendars;

import org.jquantlib.lang.annotation.QualityAssurance;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.Date;
import org.jquantlib.time.Month;
import org.jquantlib.time.Weekday;

@QualityAssurance(quality=QualityAssurance.Quality.Q3_DOCUMENTATION, version=QualityAssurance.Version.V097, reviewers={"Zahid Hussain"})
public class Ukraine
extends Calendar {
    public Ukraine() {
        this(Market.USE);
    }

    public Ukraine(Market m) {
        this.impl = new UseImpl();
    }

    private final class UseImpl
    extends Calendar.OrthodoxImpl {
        private UseImpl() {
        }

        @Override
        public String name() {
            return "Ukrainian stock exchange";
        }

        @Override
        public boolean isBusinessDay(Date date) {
            Weekday w = date.weekday();
            int d = date.dayOfMonth();
            int dd = date.dayOfYear();
            Month m = date.month();
            int y = date.year();
            int em = this.easterMonday(y);
            return !(this.isWeekend(w) || (d == 1 || (d == 2 || d == 3) && w == Weekday.Monday) && m == Month.January || (d == 7 || (d == 8 || d == 9) && w == Weekday.Monday) && m == Month.January || (d == 8 || (d == 9 || d == 10) && w == Weekday.Monday) && m == Month.March || dd == em || dd == em + 49 || (d == 1 || d == 2 || d == 3 && w == Weekday.Monday) && m == Month.May || (d == 9 || (d == 10 || d == 11) && w == Weekday.Monday) && m == Month.May || d == 28 && m == Month.June) && (d != 24 || m != Month.August);
        }
    }

    public static enum Market {
        USE;

    }
}

