/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.time.calendars;

import org.jquantlib.lang.annotation.QualityAssurance;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.Date;
import org.jquantlib.time.Month;
import org.jquantlib.time.Weekday;

@QualityAssurance(quality=QualityAssurance.Quality.Q3_DOCUMENTATION, version=QualityAssurance.Version.V097, reviewers={"Zahid Hussain"})
public class Slovakia
extends Calendar {
    public Slovakia() {
        this(Market.BSSE);
    }

    public Slovakia(Market m) {
        this.impl = new BsseImpl();
    }

    private final class BsseImpl
    extends Calendar.WesternImpl {
        private BsseImpl() {
        }

        @Override
        public String name() {
            return "Bratislava stock exchange";
        }

        @Override
        public boolean isBusinessDay(Date date) {
            Weekday w = date.weekday();
            int d = date.dayOfMonth();
            int dd = date.dayOfYear();
            Month m = date.month();
            int y = date.year();
            int em = this.easterMonday(y);
            return !(this.isWeekend(w) || d == 1 && m == Month.January || d == 6 && m == Month.January || dd == em - 3 || dd == em || d == 1 && m == Month.May || d == 8 && m == Month.May || d == 5 && m == Month.July || d == 29 && m == Month.August || d == 1 && m == Month.September || d == 15 && m == Month.September || d == 1 && m == Month.November || d == 17 && m == Month.November || d == 24 && m == Month.December || d == 25 && m == Month.December || d == 26 && m == Month.December || d >= 24 && d <= 31 && m == Month.December && y == 2004) && (d < 24 || d > 31 || m != Month.December || y != 2005);
        }
    }

    public static enum Market {
        BSSE;

    }
}

