/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.time.calendars;

import org.jquantlib.lang.annotation.QualityAssurance;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.Date;
import org.jquantlib.time.Month;
import org.jquantlib.time.Weekday;

@QualityAssurance(quality=QualityAssurance.Quality.Q3_DOCUMENTATION, version=QualityAssurance.Version.V097, reviewers={"Zahid Hussain"})
public class Singapore
extends Calendar {
    public Singapore() {
        this(Market.SGX);
    }

    public Singapore(Market m) {
        this.impl = new SgxImpl();
    }

    private final class SgxImpl
    extends Calendar.WesternImpl {
        private SgxImpl() {
        }

        @Override
        public String name() {
            return "Singapore exchange";
        }

        @Override
        public boolean isBusinessDay(Date date) {
            Weekday w = date.weekday();
            int d = date.dayOfMonth();
            int dd = date.dayOfYear();
            Month m = date.month();
            int y = date.year();
            int em = this.easterMonday(y);
            return !(this.isWeekend(w) || d == 1 && m == Month.January || dd == em - 3 || d == 1 && m == Month.May || d == 9 && m == Month.August || d == 25 && m == Month.December || (d == 22 || d == 23) && m == Month.January && y == 2004 || (d == 9 || d == 10) && m == Month.February && y == 2005 || (d == 30 || d == 31) && m == Month.January && y == 2006 || (d == 19 || d == 20) && m == Month.February && y == 2007 || (d == 7 || d == 8) && m == Month.February && y == 2008 || (d == 26 || d == 27) && m == Month.January && y == 2009 || (d == 1 || d == 2) && m == Month.February && y == 2004 || d == 21 && m == Month.January && y == 2005 || d == 10 && m == Month.January && y == 2006 || d == 2 && m == Month.January && y == 2007 || d == 20 && m == Month.December && y == 2007 || d == 8 && m == Month.December && y == 2008 || d == 2 && m == Month.June && y == 2004 || d == 22 && m == Month.May && y == 2005 || d == 12 && m == Month.May && y == 2006 || d == 31 && m == Month.May && y == 2007 || d == 18 && m == Month.May && y == 2008 || d == 11 && m == Month.November && y == 2004 || d == 8 && m == Month.November && y == 2007 || d == 28 && m == Month.October && y == 2008 || d == 27 && m == Month.November && y == 2009 || d == 1 && m == Month.November && y == 2005 || (d == 14 || d == 15) && m == Month.November && y == 2004 || d == 3 && m == Month.November && y == 2005 || d == 24 && m == Month.October && y == 2006 || d == 13 && m == Month.October && y == 2007) && (d != 1 || m != Month.October || y != 2008);
        }
    }

    public static enum Market {
        SGX;

    }
}

