/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.time.calendars;

import org.jquantlib.lang.annotation.QualityAssurance;
import org.jquantlib.lang.exceptions.LibraryException;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.Date;
import org.jquantlib.time.Month;
import org.jquantlib.time.Weekday;

@QualityAssurance(quality=QualityAssurance.Quality.Q3_DOCUMENTATION, version=QualityAssurance.Version.V097, reviewers={"Zahid Hussain"})
public class SaudiArabia
extends Calendar {
    public SaudiArabia() {
        this(Market.Tadawul);
    }

    public SaudiArabia(Market m) {
        switch (m) {
            case Tadawul: {
                this.impl = new TadawulImpl();
                break;
            }
            default: {
                throw new LibraryException("Unknown market");
            }
        }
    }

    private final class TadawulImpl
    extends Calendar.Impl {
        private TadawulImpl() {
        }

        @Override
        public String name() {
            return "Tadawul";
        }

        @Override
        public boolean isWeekend(Weekday w) {
            return w == Weekday.Thursday || w == Weekday.Friday;
        }

        @Override
        public boolean isBusinessDay(Date date) {
            Weekday w = date.weekday();
            int d = date.dayOfMonth();
            Month m = date.month();
            int y = date.year();
            return !(this.isWeekend(w) || d == 23 && m == Month.September || d >= 1 && d <= 6 && m == Month.February && y == 2004 || d >= 21 && d <= 25 && m == Month.January && y == 2005 || d >= 25 && d <= 29 && m == Month.November && y == 2004) && (d < 14 || d > 18 || m != Month.November || y != 2005);
        }
    }

    public static enum Market {
        Tadawul;

    }
}

