/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.time.calendars;

import org.jquantlib.lang.annotation.QualityAssurance;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.Date;
import org.jquantlib.time.Month;
import org.jquantlib.time.Weekday;

@QualityAssurance(quality=QualityAssurance.Quality.Q3_DOCUMENTATION, version=QualityAssurance.Version.V097, reviewers={"Zahid Hussain"})
public class Norway
extends Calendar {
    public Norway() {
        this.impl = new Impl();
    }

    private final class Impl
    extends Calendar.WesternImpl {
        private Impl() {
        }

        @Override
        public String name() {
            return "Norway";
        }

        @Override
        public boolean isBusinessDay(Date date) {
            Weekday w = date.weekday();
            int d = date.dayOfMonth();
            int dd = date.dayOfYear();
            Month m = date.month();
            int y = date.year();
            int em = this.easterMonday(y);
            return !(this.isWeekend(w) || dd == em - 4 || dd == em - 3 || dd == em || dd == em + 38 || dd == em + 49 || d == 1 && m == Month.January || d == 1 && m == Month.May || d == 17 && m == Month.May || d == 25 && m == Month.December) && (d != 26 || m != Month.December);
        }
    }
}

