/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.time.calendars;

import org.jquantlib.lang.annotation.QualityAssurance;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.Date;
import org.jquantlib.time.Month;
import org.jquantlib.time.Weekday;

@QualityAssurance(quality=QualityAssurance.Quality.Q3_DOCUMENTATION, version=QualityAssurance.Version.V097, reviewers={"Zahid Hussain"})
public class NewZealand
extends Calendar {
    public NewZealand() {
        this.impl = new Impl();
    }

    private final class Impl
    extends Calendar.WesternImpl {
        private Impl() {
        }

        @Override
        public String name() {
            return "New Zealand";
        }

        @Override
        public boolean isBusinessDay(Date date) {
            Weekday w = date.weekday();
            int d = date.dayOfMonth();
            int dd = date.dayOfYear();
            Month m = date.month();
            int y = date.year();
            int em = this.easterMonday(y);
            return !(this.isWeekend(w) || (d == 1 || d == 3 && (w == Weekday.Monday || w == Weekday.Tuesday)) && m == Month.January || (d == 2 || d == 4 && (w == Weekday.Monday || w == Weekday.Tuesday)) && m == Month.January || d >= 19 && d <= 25 && w == Weekday.Monday && m == Month.January || d == 6 && m == Month.February || dd == em - 3 || dd == em || d == 25 && m == Month.April || d <= 7 && w == Weekday.Monday && m == Month.June || d >= 22 && d <= 28 && w == Weekday.Monday && m == Month.October || (d == 25 || d == 27 && (w == Weekday.Monday || w == Weekday.Tuesday)) && m == Month.December) && (d != 26 && (d != 28 || w != Weekday.Monday && w != Weekday.Tuesday) || m != Month.December);
        }
    }
}

