/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.time.calendars;

import java.util.ArrayList;
import java.util.List;
import org.jquantlib.lang.annotation.QualityAssurance;
import org.jquantlib.lang.exceptions.LibraryException;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.Date;
import org.jquantlib.time.Weekday;

@QualityAssurance(quality=QualityAssurance.Quality.Q3_DOCUMENTATION, version=QualityAssurance.Version.V097, reviewers={"Richard Gomes"})
public class JointCalendar
extends Calendar {
    public JointCalendar(Calendar c1, Calendar c2, JointCalendarRule rule) {
        this(rule, c1, c2);
    }

    public JointCalendar(Calendar c1, Calendar c2) {
        this(JointCalendarRule.JoinHolidays, c1, c2);
    }

    public JointCalendar(Calendar c1, Calendar c2, Calendar c3, JointCalendarRule rule) {
        this(rule, c1, c2, c3);
    }

    public JointCalendar(Calendar c1, Calendar c2, Calendar c3) {
        this(JointCalendarRule.JoinHolidays, c1, c2, c3);
    }

    public JointCalendar(Calendar c1, Calendar c2, Calendar c3, Calendar c4, JointCalendarRule rule) {
        this(rule, c1, c2, c3, c4);
    }

    public JointCalendar(Calendar c1, Calendar c2, Calendar c3, Calendar c4) {
        this(JointCalendarRule.JoinHolidays, c1, c2, c3, c4);
    }

    private JointCalendar(JointCalendarRule rule, Calendar ... calendars) {
        this.impl = new Impl(rule, calendars);
    }

    private final class Impl
    extends Calendar.Impl {
        private JointCalendarRule rule_;
        private List<Calendar> calendars_;

        protected Impl(JointCalendarRule rule, Calendar ... calendars) {
            this.calendars_ = new ArrayList<Calendar>(calendars.length);
            for (int i = 0; i < calendars.length; ++i) {
                this.calendars_.add(calendars[i]);
            }
            this.rule_ = rule;
        }

        @Override
        public String name() {
            StringBuilder sb = new StringBuilder();
            switch (this.rule_) {
                case JoinHolidays: {
                    sb.append("JoinHolidays(");
                    break;
                }
                case JoinBusinessDays: {
                    sb.append("JoinBusinessDays(");
                    break;
                }
                default: {
                    throw new LibraryException("unknown joint calendar rule");
                }
            }
            int count = 0;
            for (Calendar calendar : this.calendars_) {
                if (count > 0) {
                    sb.append(", ");
                }
                sb.append(calendar.name());
                ++count;
            }
            sb.append(')');
            return sb.toString();
        }

        @Override
        public boolean isWeekend(Weekday w) {
            switch (this.rule_) {
                case JoinHolidays: {
                    for (Calendar calendar : this.calendars_) {
                        if (!calendar.isWeekend(w)) continue;
                        return true;
                    }
                    return false;
                }
                case JoinBusinessDays: {
                    for (Calendar calendar : this.calendars_) {
                        if (calendar.isWeekend(w)) continue;
                        return false;
                    }
                    return true;
                }
            }
            throw new LibraryException("Unknown market");
        }

        @Override
        public boolean isBusinessDay(Date date) {
            switch (this.rule_) {
                case JoinHolidays: {
                    for (Calendar calendar : this.calendars_) {
                        if (!calendar.isHoliday(date)) continue;
                        return false;
                    }
                    return true;
                }
                case JoinBusinessDays: {
                    for (Calendar calendar : this.calendars_) {
                        if (!calendar.isBusinessDay(date)) continue;
                        return true;
                    }
                    return false;
                }
            }
            throw new LibraryException("Unknown market");
        }
    }

    public static enum JointCalendarRule {
        JoinHolidays,
        JoinBusinessDays;

    }
}

