/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.time.calendars;

import org.jquantlib.lang.annotation.QualityAssurance;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.Date;
import org.jquantlib.time.Month;
import org.jquantlib.time.Weekday;

@QualityAssurance(quality=QualityAssurance.Quality.Q3_DOCUMENTATION, version=QualityAssurance.Version.V097, reviewers={"Zahid Hussain"})
public class Japan
extends Calendar {
    public Japan() {
        this.impl = new JapanImpl();
    }

    private final class JapanImpl
    extends Calendar.Impl {
        private JapanImpl() {
        }

        @Override
        public String name() {
            return "Japan";
        }

        @Override
        public boolean isWeekend(Weekday w) {
            return w == Weekday.Saturday || w == Weekday.Sunday;
        }

        @Override
        public boolean isBusinessDay(Date date) {
            Weekday w = date.weekday();
            int d = date.dayOfMonth();
            Month m = date.month();
            int y = date.year();
            double exact_vernal_equinox_time = 20.69115;
            double exact_autumnal_equinox_time = 23.09;
            double diff_per_year = 0.242194;
            double moving_amount = (double)(y - 2000) * 0.242194;
            Integer number_of_leap_years = (y - 2000) / 4 + (y - 2000) / 100 - (y - 2000) / 400;
            int ve = (int)(20.69115 + moving_amount - (double)number_of_leap_years.intValue());
            int ae = (int)(23.09 + moving_amount - (double)number_of_leap_years.intValue());
            return !(this.isWeekend(w) || d == 1 && m == Month.January || d == 2 && m == Month.January || d == 3 && m == Month.January || w == Weekday.Monday && d >= 8 && d <= 14 && m == Month.January && y >= 2000 || (d == 15 || d == 16 && w == Weekday.Monday) && m == Month.January && y < 2000 || (d == 11 || d == 12 && w == Weekday.Monday) && m == Month.February || (d == ve || d == ve + 1 && w == Weekday.Monday) && m == Month.March || (d == 29 || d == 30 && w == Weekday.Monday) && m == Month.April || d == 3 && m == Month.May || d == 4 && m == Month.May || (d == 5 || d == 6 && w == Weekday.Monday) && m == Month.May || w == Weekday.Monday && d >= 15 && d <= 21 && m == Month.July && y >= 2003 || (d == 20 || d == 21 && w == Weekday.Monday) && m == Month.July && y >= 1996 && y < 2003 || w == Weekday.Monday && d >= 15 && d <= 21 && m == Month.September && y >= 2003 || (d == 15 || d == 16 && w == Weekday.Monday) && m == Month.September && y < 2003 || w == Weekday.Tuesday && d + 1 == ae && d >= 16 && d <= 22 && m == Month.September && y >= 2003 || (d == ae || d == ae + 1 && w == Weekday.Monday) && m == Month.September || w == Weekday.Monday && d >= 8 && d <= 14 && m == Month.October && y >= 2000 || (d == 10 || d == 11 && w == Weekday.Monday) && m == Month.October && y < 2000 || (d == 3 || d == 4 && w == Weekday.Monday) && m == Month.November || (d == 23 || d == 24 && w == Weekday.Monday) && m == Month.November || (d == 23 || d == 24 && w == Weekday.Monday) && m == Month.December && y >= 1989 || d == 31 && m == Month.December || d == 10 && m == Month.April && y == 1959 || d == 24 && m == Month.February && y == 1989 || d == 12 && m == Month.November && y == 1990) && (d != 9 || m != Month.June || y != 1993);
        }
    }
}

