/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.time.calendars;

import org.jquantlib.lang.annotation.QualityAssurance;
import org.jquantlib.lang.exceptions.LibraryException;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.Date;
import org.jquantlib.time.Month;
import org.jquantlib.time.Weekday;

@QualityAssurance(quality=QualityAssurance.Quality.Q3_DOCUMENTATION, version=QualityAssurance.Version.V097, reviewers={"Zahid Hussain"})
public class Italy
extends Calendar {
    public Italy() {
        this(Market.Settlement);
    }

    public Italy(Market market) {
        switch (market) {
            case Settlement: {
                this.impl = new SettlementImpl();
                break;
            }
            case Exchange: {
                this.impl = new ExchangeImpl();
                break;
            }
            default: {
                throw new LibraryException("Unknown market");
            }
        }
    }

    private final class ExchangeImpl
    extends Calendar.WesternImpl {
        private ExchangeImpl() {
        }

        @Override
        public String name() {
            return "Milan stock exchange";
        }

        @Override
        public boolean isBusinessDay(Date date) {
            Weekday w = date.weekday();
            int d = date.dayOfMonth();
            int dd = date.dayOfYear();
            Month m = date.month();
            int y = date.year();
            int em = this.easterMonday(y);
            return !(this.isWeekend(w) || d == 1 && m == Month.January || dd == em - 3 || dd == em || d == 1 && m == Month.May || d == 15 && m == Month.August || d == 24 && m == Month.December || d == 25 && m == Month.December || d == 26 && m == Month.December) && (d != 31 || m != Month.December);
        }
    }

    private final class SettlementImpl
    extends Calendar.WesternImpl {
        private SettlementImpl() {
        }

        @Override
        public String name() {
            return "Italian settlement";
        }

        @Override
        public boolean isBusinessDay(Date date) {
            Weekday w = date.weekday();
            int d = date.dayOfMonth();
            int dd = date.dayOfYear();
            Month m = date.month();
            int y = date.year();
            int em = this.easterMonday(y);
            return !(this.isWeekend(w) || d == 1 && m == Month.January || d == 6 && m == Month.January || dd == em || d == 25 && m == Month.April || d == 1 && m == Month.May || d == 2 && m == Month.June && y >= 2000 || d == 15 && m == Month.August || d == 1 && m == Month.November || d == 8 && m == Month.December || d == 25 && m == Month.December || d == 26 && m == Month.December) && (d != 31 || m != Month.December || y != 1999);
        }
    }

    public static enum Market {
        Settlement,
        Exchange;

    }
}

