/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.time.calendars;

import org.jquantlib.lang.annotation.QualityAssurance;
import org.jquantlib.lang.exceptions.LibraryException;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.Date;
import org.jquantlib.time.Month;
import org.jquantlib.time.Weekday;

@QualityAssurance(quality=QualityAssurance.Quality.Q3_DOCUMENTATION, version=QualityAssurance.Version.V097, reviewers={"Zahid Hussain"})
public class Germany
extends Calendar {
    public Germany() {
        this(Market.FrankfurtStockExchange);
    }

    public Germany(Market market) {
        switch (market) {
            case Settlement: {
                this.impl = new SettlementImpl();
                break;
            }
            case FrankfurtStockExchange: {
                this.impl = new FrankfurtStockExchangeImpl();
                break;
            }
            case Xetra: {
                this.impl = new XetraImpl();
                break;
            }
            case Eurex: {
                this.impl = new EurexImpl();
                break;
            }
            default: {
                throw new LibraryException("Unknown market");
            }
        }
    }

    private final class EurexImpl
    extends Calendar.WesternImpl {
        private EurexImpl() {
        }

        @Override
        public String name() {
            return "Eurex";
        }

        @Override
        public boolean isBusinessDay(Date date) {
            Weekday w = date.weekday();
            int d = date.dayOfMonth();
            int dd = date.dayOfYear();
            Month m = date.month();
            int y = date.year();
            int em = this.easterMonday(y);
            return !(this.isWeekend(w) || d == 1 && m == Month.January || dd == em - 3 || dd == em || d == 1 && m == Month.May || d == 24 && m == Month.December || d == 25 && m == Month.December || d == 26 && m == Month.December) && (d != 31 || m != Month.December);
        }
    }

    private final class XetraImpl
    extends Calendar.WesternImpl {
        private XetraImpl() {
        }

        @Override
        public String name() {
            return "Xetra";
        }

        @Override
        public boolean isBusinessDay(Date date) {
            Weekday w = date.weekday();
            int d = date.dayOfMonth();
            int dd = date.dayOfYear();
            Month m = date.month();
            int y = date.year();
            int em = this.easterMonday(y);
            return !(this.isWeekend(w) || d == 1 && m == Month.January || dd == em - 3 || dd == em || d == 1 && m == Month.May || d == 24 && m == Month.December || d == 25 && m == Month.December || d == 26 && m == Month.December) && (d != 31 || m != Month.December);
        }
    }

    private final class FrankfurtStockExchangeImpl
    extends Calendar.WesternImpl {
        private FrankfurtStockExchangeImpl() {
        }

        @Override
        public String name() {
            return "Frankfurt stock exchange";
        }

        @Override
        public boolean isBusinessDay(Date date) {
            Weekday w = date.weekday();
            int d = date.dayOfMonth();
            int dd = date.dayOfYear();
            Month m = date.month();
            int y = date.year();
            int em = this.easterMonday(y);
            return !(this.isWeekend(w) || d == 1 && m == Month.January || dd == em - 3 || dd == em || d == 1 && m == Month.May || d == 24 && m == Month.December || d == 25 && m == Month.December || d == 26 && m == Month.December) && (d != 31 || m != Month.December);
        }
    }

    private final class SettlementImpl
    extends Calendar.WesternImpl {
        private SettlementImpl() {
        }

        @Override
        public String name() {
            return "German settlement";
        }

        @Override
        public boolean isBusinessDay(Date date) {
            Weekday w = date.weekday();
            int d = date.dayOfMonth();
            int dd = date.dayOfYear();
            Month m = date.month();
            int y = date.year();
            int em = this.easterMonday(y);
            return !(this.isWeekend(w) || d == 1 && m == Month.January || dd == em - 3 || dd == em || dd == em + 38 || dd == em + 49 || dd == em + 59 || d == 1 && m == Month.May || d == 3 && m == Month.October || d == 24 && m == Month.December || d == 25 && m == Month.December || d == 26 && m == Month.December) && (d != 31 || m != Month.December);
        }
    }

    public static enum Market {
        Settlement,
        FrankfurtStockExchange,
        Xetra,
        Eurex;

    }
}

