/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.time.calendars;

import org.jquantlib.lang.annotation.QualityAssurance;
import org.jquantlib.lang.exceptions.LibraryException;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.Date;
import org.jquantlib.time.Month;
import org.jquantlib.time.Weekday;

@QualityAssurance(quality=QualityAssurance.Quality.Q3_DOCUMENTATION, version=QualityAssurance.Version.V097, reviewers={"Zahid Hussain"})
public class China
extends Calendar {
    public China() {
        this(Market.SSE);
    }

    public China(Market m) {
        switch (m) {
            case SSE: {
                this.impl = new SseImpl();
                break;
            }
            default: {
                throw new LibraryException("Unknown market");
            }
        }
    }

    private final class SseImpl
    extends Calendar.Impl {
        private SseImpl() {
        }

        @Override
        public String name() {
            return "Shanghai stock exchange";
        }

        @Override
        public boolean isWeekend(Weekday w) {
            return w == Weekday.Saturday || w == Weekday.Sunday;
        }

        @Override
        public boolean isBusinessDay(Date date) {
            Weekday w = date.weekday();
            int d = date.dayOfMonth();
            Month m = date.month();
            int y = date.year();
            return !(this.isWeekend(w) || d == 1 && m == Month.January || d == 3 && m == Month.January && y == 2005 || (d == 2 || d == 3) && m == Month.January && y == 2006 || d <= 3 && m == Month.January && y == 2007 || d == 31 && m == Month.December && y == 2007 || d == 1 && m == Month.January && y == 2008 || d == 1 && m == Month.January && y == 200 || d == 2 && m == Month.January && y == 2009 || d >= 19 && d <= 28 && m == Month.January && y == 2004 || d >= 7 && d <= 15 && m == Month.February && y == 2005 || (d >= 26 && m == Month.January || d <= 3 && m == Month.February) && y == 2006 || d >= 17 && d <= 25 && m == Month.February && y == 2007 || d >= 6 && d <= 12 && m == Month.February && y == 2008 || d >= 26 && d <= 30 && m == Month.January && y == 2009 || d == 4 && m == Month.April && y == 2008 || d == 6 && m == Month.April && y == 2009 || d >= 1 && d <= 7 && m == Month.May && y <= 2007 || d >= 1 && d <= 2 && m == Month.May && y == 2008 || d == 1 && m == Month.May && y == 2009 || d == 9 && m == Month.June && y == 2008 || d >= 28 && d <= 29 && m == Month.May && y == 2009 || d == 15 && m == Month.September && y == 2008 || d >= 1 && d <= 7 && m == Month.October && y <= 2007 || d >= 29 && m == Month.September && y == 2008 || d <= 3 && m == Month.October && y == 2008) && (d < 1 || d > 8 || m != Month.October || y != 2009);
        }
    }

    public static enum Market {
        SSE;

    }
}

