/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.time;

import org.jquantlib.lang.annotation.QualityAssurance;
import org.jquantlib.time.BusinessDayConvention;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.Date;
import org.jquantlib.time.DateGeneration;
import org.jquantlib.time.Period;
import org.jquantlib.time.Schedule;

@QualityAssurance(quality=QualityAssurance.Quality.Q0_UNFINISHED, version=QualityAssurance.Version.V097, reviewers={"Richard Gomes"})
public class MakeSchedule
implements Cloneable {
    private Calendar calendar_;
    private Date effectiveDate_;
    private Date terminationDate_;
    private Period tenor_;
    private BusinessDayConvention convention_;
    private BusinessDayConvention terminationDateConvention_;
    private DateGeneration.Rule rule_;
    private boolean endOfMonth_;
    private Date firstDate_;
    private Date nextToLastDate_;

    public MakeSchedule(Date effectiveDate, Date terminationDate, Period tenor, Calendar calendar, BusinessDayConvention convention) {
        this.calendar_ = calendar;
        this.effectiveDate_ = effectiveDate;
        this.terminationDate_ = terminationDate;
        this.tenor_ = tenor;
        this.convention_ = convention;
        this.terminationDateConvention_ = convention;
        this.rule_ = DateGeneration.Rule.Backward;
        this.endOfMonth_ = false;
        this.firstDate_ = new Date();
        this.nextToLastDate_ = new Date();
    }

    public MakeSchedule withTerminationDateConvention(BusinessDayConvention conv) {
        this.terminationDateConvention_ = conv;
        return this.clone();
    }

    public MakeSchedule withRule(DateGeneration.Rule r) {
        this.rule_ = r;
        return this.clone();
    }

    public MakeSchedule forwards() {
        this.rule_ = DateGeneration.Rule.Forward;
        return this.clone();
    }

    public MakeSchedule backwards() {
        this.rule_ = DateGeneration.Rule.Backward;
        return this.clone();
    }

    public MakeSchedule endOfMonth() {
        return this.endOfMonth(true);
    }

    public MakeSchedule endOfMonth(boolean flag) {
        this.endOfMonth_ = flag;
        return this.clone();
    }

    public MakeSchedule withFirstDate(Date d) {
        this.firstDate_ = d;
        return this.clone();
    }

    public MakeSchedule withNextToLastDate(Date d) {
        this.nextToLastDate_ = d;
        return this.clone();
    }

    public Schedule schedule() {
        return new Schedule(this.effectiveDate_, this.terminationDate_, this.tenor_, this.calendar_, this.convention_, this.terminationDateConvention_, this.rule_, this.endOfMonth_, this.firstDate_, this.nextToLastDate_);
    }

    public MakeSchedule clone() {
        MakeSchedule clone = new MakeSchedule(this.effectiveDate_, this.terminationDate_, this.tenor_, this.calendar_, this.convention_);
        clone.calendar_ = this.calendar_;
        clone.effectiveDate_ = this.effectiveDate_.clone();
        clone.terminationDate_ = this.terminationDate_.clone();
        clone.tenor_ = this.tenor_;
        clone.convention_ = this.convention_;
        clone.terminationDateConvention_ = this.terminationDateConvention_;
        clone.rule_ = this.rule_;
        clone.endOfMonth_ = this.endOfMonth_;
        clone.firstDate_ = this.firstDate_.clone();
        clone.nextToLastDate_ = this.nextToLastDate_.clone();
        return clone;
    }
}

