/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.testsuite.time;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import org.jquantlib.QL;
import org.jquantlib.quotes.RelinkableHandle;
import org.jquantlib.testsuite.util.Flag;
import org.jquantlib.time.DateParser;
import org.jquantlib.time.IMM;
import org.jquantlib.time.Month;
import org.jquantlib.time.Period;
import org.jquantlib.time.TimeUnit;
import org.jquantlib.time.Weekday;
import org.junit.Assert;
import org.junit.Test;

public class DatesTest {
    private static final String[] IMMcodes = new String[]{"F0", "G0", "H0", "J0", "K0", "M0", "N0", "Q0", "U0", "V0", "X0", "Z0", "F1", "G1", "H1", "J1", "K1", "M1", "N1", "Q1", "U1", "V1", "X1", "Z1", "F2", "G2", "H2", "J2", "K2", "M2", "N2", "Q2", "U2", "V2", "X2", "Z2", "F3", "G3", "H3", "J3", "K3", "M3", "N3", "Q3", "U3", "V3", "X3", "Z3", "F4", "G4", "H4", "J4", "K4", "M4", "N4", "Q4", "U4", "V4", "X4", "Z4", "F5", "G5", "H5", "J5", "K5", "M5", "N5", "Q5", "U5", "V5", "X5", "Z5", "F6", "G6", "H6", "J6", "K6", "M6", "N6", "Q6", "U6", "V6", "X6", "Z6", "F7", "G7", "H7", "J7", "K7", "M7", "N7", "Q7", "U7", "V7", "X7", "Z7", "F8", "G8", "H8", "J8", "K8", "M8", "N8", "Q8", "U8", "V8", "X8", "Z8", "F9", "G9", "H9", "J9", "K9", "M9", "N9", "Q9", "U9", "V9", "X9", "Z9"};

    public DatesTest() {
        QL.info("::::: " + this.getClass().getSimpleName() + " :::::");
    }

    @Test
    public void immDates() {
        QL.info("Testing imm dates. It may take several minutes when Cobertura reports are generated!!!");
        org.jquantlib.time.Date minDate = org.jquantlib.time.Date.minDate();
        org.jquantlib.time.Date maxDate = org.jquantlib.time.Date.maxDate();
        org.jquantlib.time.Date counter = minDate.clone();
        Period period = new Period(-10, TimeUnit.Years);
        org.jquantlib.time.Date last = maxDate.clone().addAssign(period);
        while (counter.le(last)) {
            org.jquantlib.time.Date immDate = IMM.nextDate(counter, false);
            if (immDate.le(counter)) {
                Assert.fail((String)("\n  " + (Object)((Object)immDate.weekday()) + " " + immDate + " is not greater than " + (Object)((Object)counter.weekday()) + " " + counter));
            }
            if (!IMM.isIMMdate(immDate, false)) {
                Assert.fail((String)("\n  " + (Object)((Object)immDate.weekday()) + " " + immDate + " is not an IMM date (calculated from " + (Object)((Object)counter.weekday()) + " " + counter + ")"));
            }
            if (immDate.gt(IMM.nextDate(counter, true))) {
                Assert.fail((String)("\n  " + (Object)((Object)immDate.weekday()) + " " + immDate + " is not less than or equal to the next future in the main cycle " + IMM.nextDate(counter, true)));
            }
            if (!IMM.date(IMM.code(immDate), counter).equals(immDate)) {
                Assert.fail((String)("\n  " + IMM.code(immDate) + " at calendar day " + counter + " is not the IMM code matching " + immDate));
            }
            for (int i = 0; i < 40; ++i) {
                if (!IMM.date(IMMcodes[i], counter).lt(counter)) continue;
                Assert.fail((String)("\n  " + IMM.date(IMMcodes[i], counter) + " is wrong for " + IMMcodes[i] + " at reference date " + counter));
            }
            counter.inc();
        }
    }

    @Test
    public void consistencyCheck() {
        QL.info("Testing dates...");
        org.jquantlib.time.Date minD = org.jquantlib.time.Date.minDate();
        org.jquantlib.time.Date maxD = org.jquantlib.time.Date.maxDate();
        int dyold = minD.dayOfYear();
        int dold = minD.dayOfMonth();
        int mold = minD.month().value();
        int yold = minD.year();
        Weekday wdold = minD.weekday();
        org.jquantlib.time.Date minDate = minD.clone().inc();
        org.jquantlib.time.Date maxDate = maxD.clone().dec();
        org.jquantlib.time.Date t = minDate;
        while (t.le(maxDate)) {
            int dy = t.dayOfYear();
            int d = t.dayOfMonth();
            int m = t.month().value();
            int y = t.year();
            Weekday wd = t.weekday();
            if (!(dy == dyold + 1 || dy == 1 && dyold == 365 && !org.jquantlib.time.Date.isLeap(yold) || dy == 1 && dyold == 366 && org.jquantlib.time.Date.isLeap(yold))) {
                Assert.fail((String)("wrong day of year increment: \n    date: " + t + "\n" + "    day of year: " + dy + "\n" + "    previous:    " + dyold));
            }
            dyold = dy;
            if (!(d == dold + 1 && m == mold && y == yold || d == 1 && m == mold + 1 && y == yold || d == 1 && m == 1 && y == yold + 1)) {
                Assert.fail((String)("wrong day,month,year increment: \n    date: " + t + "\n" + "    day,month,year: " + d + "," + m + "," + y + "\n" + "    previous:       " + dold + "," + mold + "," + yold));
            }
            dold = d;
            mold = m;
            yold = y;
            if (m < 1 || m > 12) {
                Assert.fail((String)("invalid month: \n    date:  " + t + "\n" + "    month: " + m));
            }
            if (d < 1) {
                Assert.fail((String)("invalid day of month: \n    date:  " + t + "\n" + "    day: " + d));
            }
            if (!(m == 1 && d <= 31 || m == 2 && d <= 28 || m == 2 && d == 29 && org.jquantlib.time.Date.isLeap(y) || m == 3 && d <= 31 || m == 4 && d <= 30 || m == 5 && d <= 31 || m == 6 && d <= 30 || m == 7 && d <= 31 || m == 8 && d <= 31 || m == 9 && d <= 30 || m == 10 && d <= 31 || m == 11 && d <= 30 || m == 12 && d <= 31)) {
                Assert.fail((String)("invalid day of month: \n    date:  " + t + "\n" + "    day: " + d));
            }
            if (wd.value() != wdold.value() + 1 && (wd.value() != 1 || wdold.value() != 7)) {
                Assert.fail((String)("invalid weekday: \n    date:  " + t + "\n" + "    weekday:  " + (Object)((Object)wd) + "\n" + "    previous: " + (Object)((Object)wdold)));
            }
            wdold = wd;
            t.inc();
        }
    }

    @Test
    public void isoDates() {
        QL.info("Testing ISO dates...");
        String input_date = "2006-01-15";
        org.jquantlib.time.Date d = DateParser.parseISO("2006-01-15");
        if (d.dayOfMonth() != 15 || d.month() != Month.January || d.year() != 2006) {
            Assert.fail((String)("Iso date failed\n input date:    2006-01-15\n day of month:  " + d.dayOfMonth() + "\n" + " month:         " + (Object)((Object)d.month()) + "\n" + " year:          " + d.year()));
        }
    }

    @Test
    public void testConvertionToJavaDate() {
        QL.info("Testing convertion to Java Date...");
        boolean success = true;
        org.jquantlib.time.Date jqlDate = new org.jquantlib.time.Date(1, 1, 1901);
        while (true) {
            Date isoDate = jqlDate.isoDate();
            int day = jqlDate.dayOfMonth();
            int month = jqlDate.month().value();
            int year = jqlDate.year();
            Calendar c = Calendar.getInstance();
            c.setTime(isoDate);
            int jday = c.get(5);
            int jmonth = c.get(2);
            int jyear = c.get(1);
            boolean test = true;
            test &= year == jyear;
            test &= month == jmonth + 1;
            success &= (test &= day == jday);
            if (!test) {
                QL.info(String.format("JQL Date = %s   :::   ISODate = %s", jqlDate.toString(), isoDate.toString()));
            }
            if (year == 2199 && month == 12 && day == 31) break;
            jqlDate.inc();
        }
        Assert.assertTrue((String)"Conversion from JQuantLib date to JDK Date failed", (boolean)success);
    }

    @Test
    public void testConvertionFromJavaDate() {
        QL.info("Testing convertion from Java Date...");
        org.jquantlib.time.Date jqlDate = new org.jquantlib.time.Date(1, 1, 1901);
        Date javaDate = jqlDate.isoDate();
        boolean success = true;
        while (true) {
            Calendar c = Calendar.getInstance();
            c.setTime(javaDate);
            int jday = c.get(5);
            int jmonth = c.get(2);
            int jyear = c.get(1);
            jqlDate = new org.jquantlib.time.Date(javaDate);
            boolean test = true;
            test &= jqlDate.year() == jyear;
            test &= jqlDate.month().value() == jmonth + 1;
            success &= (test &= jqlDate.dayOfMonth() == jday);
            if (!test) {
                QL.info(String.format("JQL Date = %s   :::   ISODate = %s", jqlDate.toString(), javaDate.toString()));
            }
            if (jyear == 2199 && jmonth == 11 && jday == 31) break;
            javaDate = new Date(javaDate.getTime() + 86400000L);
        }
        Assert.assertTrue((String)"Conversion from Java Date to JQuantLib date failed", (boolean)success);
    }

    @Test
    public void testLowerUpperBound() {
        ArrayList<org.jquantlib.time.Date> dates = new ArrayList<org.jquantlib.time.Date>();
        dates.add(new org.jquantlib.time.Date(1, 1, 2009));
        dates.add(new org.jquantlib.time.Date(2, 1, 2009));
        dates.add(new org.jquantlib.time.Date(3, 1, 2009));
        dates.add(new org.jquantlib.time.Date(3, 1, 2009));
        dates.add(new org.jquantlib.time.Date(4, 1, 2009));
        dates.add(new org.jquantlib.time.Date(5, 1, 2009));
        dates.add(new org.jquantlib.time.Date(7, 1, 2009));
        dates.add(new org.jquantlib.time.Date(7, 1, 2009));
        dates.add(new org.jquantlib.time.Date(8, 1, 2009));
        org.jquantlib.time.Date lowerDate = new org.jquantlib.time.Date(3, 1, 2009);
        org.jquantlib.time.Date upperDate = new org.jquantlib.time.Date(7, 1, 2009);
        int expectedLowerBound = 2;
        int expectedUpperBound = 8;
        int lowerBound = org.jquantlib.time.Date.lowerBound(dates, lowerDate);
        int upperBound = org.jquantlib.time.Date.upperBound(dates, upperDate);
        Assert.assertEquals((long)lowerBound, (long)2L);
        Assert.assertEquals((long)upperBound, (long)8L);
    }

    @Test
    public void testNotificationSubAssign() {
        QL.info("Testing observability of dates using operation Date#subAssign()");
        org.jquantlib.time.Date me = org.jquantlib.time.Date.todaysDate();
        Flag f = new Flag();
        me.addObserver(f);
        me.subAssign(1);
        if (!f.isUp()) {
            Assert.fail((String)"Observer was not notified of date change");
        }
    }

    @Test
    public void testNotificationSub() {
        QL.info("Testing observability of dates using operation Date#sub()");
        org.jquantlib.time.Date me = org.jquantlib.time.Date.todaysDate();
        Flag f = new Flag();
        me.addObserver(f);
        me.sub(1);
        if (f.isUp()) {
            Assert.fail((String)"Observer was notified of date change whilst it was not expected");
        }
    }

    @Test
    public void testNotificationHandle() {
        org.jquantlib.time.Date weekAgo;
        QL.info("Testing notification of date handles...");
        org.jquantlib.time.Date me1 = org.jquantlib.time.Date.todaysDate();
        RelinkableHandle<org.jquantlib.time.Date> h = new RelinkableHandle<org.jquantlib.time.Date>(me1);
        Flag f = new Flag();
        h.addObserver(f);
        org.jquantlib.time.Date me2 = weekAgo = org.jquantlib.time.Date.todaysDate().sub(7);
        h.linkTo(me2);
        if (!f.isUp()) {
            Assert.fail((String)"Observer was not notified of date change");
        }
        if (h.currentLink() != weekAgo) {
            Assert.fail((String)"Failed to hard link to another object");
        }
    }

    @Test
    public void testNotificationHandleSubAssign() {
        QL.info("Testing notification of date handles using operation Date#subAssign().");
        org.jquantlib.time.Date me1 = org.jquantlib.time.Date.todaysDate();
        RelinkableHandle<org.jquantlib.time.Date> h = new RelinkableHandle<org.jquantlib.time.Date>(me1);
        Flag f = new Flag();
        h.addObserver(f);
        me1.subAssign(1);
        if (!f.isUp()) {
            Assert.fail((String)"Observer was not notified of date change");
        }
    }

    @Test
    public void testNotificationHandleSub() {
        QL.info("Testing ntification of date handles using operation Date#sub().");
        org.jquantlib.time.Date me1 = org.jquantlib.time.Date.todaysDate();
        RelinkableHandle<org.jquantlib.time.Date> h = new RelinkableHandle<org.jquantlib.time.Date>(me1);
        Flag f = new Flag();
        h.addObserver(f);
        me1.sub(1);
        if (f.isUp()) {
            Assert.fail((String)"Observer was notified of date change whilst it was not expected");
        }
    }

    @Test
    public void testEqualsandHashCode() {
        QL.info("Testing equals and hashcode");
        org.jquantlib.time.Date today = org.jquantlib.time.Date.todaysDate();
        org.jquantlib.time.Date tomorrow1 = org.jquantlib.time.Date.todaysDate().add(1);
        org.jquantlib.time.Date tomorrow2 = org.jquantlib.time.Date.todaysDate().add(1);
        org.jquantlib.time.Date manyana = org.jquantlib.time.Date.todaysDate().add(123);
        Assert.assertFalse((boolean)today.equals(null));
        Assert.assertEquals((Object)today, (Object)today);
        Assert.assertFalse((boolean)today.equals(tomorrow1));
        Assert.assertEquals((Object)tomorrow1, (Object)tomorrow2);
        HashSet<org.jquantlib.time.Date> testSet = new HashSet<org.jquantlib.time.Date>();
        testSet.add(today);
        testSet.add(tomorrow1);
        Assert.assertTrue((boolean)testSet.contains(today));
        Assert.assertFalse((boolean)testSet.contains(manyana));
    }
}

