/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.testsuite.termstructures;

import org.jquantlib.QL;
import org.jquantlib.Settings;
import org.jquantlib.daycounters.Actual360;
import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.math.Closeness;
import org.jquantlib.quotes.Handle;
import org.jquantlib.quotes.RelinkableHandle;
import org.jquantlib.quotes.SimpleQuote;
import org.jquantlib.termstructures.AbstractYieldTermStructure;
import org.jquantlib.termstructures.YieldTermStructure;
import org.jquantlib.termstructures.yieldcurves.FlatForward;
import org.jquantlib.termstructures.yieldcurves.ImpliedTermStructure;
import org.jquantlib.testsuite.util.Flag;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.Date;
import org.jquantlib.time.Period;
import org.jquantlib.time.TimeUnit;
import org.jquantlib.time.calendars.NullCalendar;
import org.jquantlib.time.calendars.Target;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class TermStructuresTest {
    private final Calendar calendar;
    private final int settlementDays;
    private final YieldTermStructure termStructure;
    private final YieldTermStructure dummyTermStructure;

    public TermStructuresTest() {
        QL.info("::::: " + this.getClass().getSimpleName() + " :::::");
        this.calendar = new Target();
        this.settlementDays = 2;
        this.termStructure = null;
        this.dummyTermStructure = null;
    }

    @Test
    public void testReferenceChange() {
        int i;
        QL.info("Testing term structure against evaluation date change...");
        FlatForward localTermStructure = new FlatForward(this.settlementDays, (Calendar)new NullCalendar(), 0.03, (DayCounter)new Actual360());
        int[] days = new int[]{10, 30, 60, 120, 360, 720};
        double[] expected = new double[days.length];
        Date today = new Settings().evaluationDate();
        for (int i2 = 0; i2 < days.length; ++i2) {
            Date anotherDay = today.add(days[i2]);
            expected[i2] = localTermStructure.discount(anotherDay);
        }
        Date nextMonth = today.add(30);
        new Settings().setEvaluationDate(nextMonth);
        double[] calculated = new double[days.length];
        for (i = 0; i < days.length; ++i) {
            Date anotherDay = nextMonth.add(days[i]);
            calculated[i] = localTermStructure.discount(anotherDay);
        }
        for (i = 0; i < days.length; ++i) {
            if (Closeness.isClose(expected[i], calculated[i])) continue;
            Assert.fail((String)("\n  Discount at " + days[i] + " days:\n" + "    before date change: " + expected[i] + "\n" + "    after date change:  " + calculated[i]));
        }
    }

    @Ignore
    @Test
    public void testImplied() {
        QL.info("Testing consistency of implied term structure...");
        Assert.fail((String)"***** TEST FAILED :: waiting for implementation of PiecewiseYieldTermStructure *****");
    }

    @Test
    public void testImpliedObs() {
        QL.info("Testing observability of implied term structure...");
        Date today = new Settings().evaluationDate();
        Date newToday = today.add(Period.ONE_YEAR_FORWARD.mul(3));
        Date newSettlement = new Target().advance(newToday, this.settlementDays, TimeUnit.Days);
        RelinkableHandle<1> h = new RelinkableHandle<1>(new AbstractYieldTermStructure(){

            @Override
            protected double discountImpl(double t) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Date maxDate() {
                throw new UnsupportedOperationException();
            }
        });
        ImpliedTermStructure<1> implied = new ImpliedTermStructure<1>(h, newSettlement);
        Flag flag = new Flag();
        implied.addObserver(flag);
        SimpleQuote quote = new SimpleQuote(100.0);
        Flag anotherFlag = new Flag();
        quote.addObserver(anotherFlag);
        h.linkTo((Object)new FlatForward(today, new Handle<SimpleQuote>(quote), (DayCounter)new Actual360()));
        if (!anotherFlag.isUp()) {
            Assert.fail((String)"Observer was not notified of term structure change");
        }
        if (!flag.isUp()) {
            Assert.fail((String)"Observer was not notified of term structure change");
        }
    }

    @Ignore
    @Test
    public void testFSpreaded() {
        QL.info("Testing consistency of forward-spreaded term structure...");
        Assert.fail((String)"***** TEST FAILED :: waiting for translation of ForwardSpreadedTermStructure *****");
    }

    @Ignore
    @Test
    public void testFSpreadedObs() {
        QL.info("Testing observability of forward-spreaded term structure...");
        Assert.fail((String)"***** TEST FAILED :: waiting for translation of ForwardSpreadedTermStructure *****");
    }

    @Ignore
    @Test
    public void testZSpreaded() {
        QL.info("Testing consistency of zero-spreaded term structure...");
        Assert.fail((String)"***** TEST FAILED :: waiting for translation of ZeroSpreadedTermStructure *****");
    }

    @Ignore
    @Test
    public void testZSpreadedObs() {
        QL.info("Testing observability of zero-spreaded term structure...");
        Assert.fail((String)"***** TEST FAILED :: waiting for translation of ZeroSpreadedTermStructure *****");
    }

    private static class Datum {
        public int n;
        public TimeUnit units;
        public double rate;

        public Datum(int n, TimeUnit units, double rate) {
            this.n = n;
            this.units = units;
            this.rate = rate;
        }
    }
}

