/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.testsuite.pricers;

import org.jquantlib.QL;
import org.jquantlib.daycounters.Actual360;
import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.instruments.Option;
import org.jquantlib.termstructures.YieldTermStructure;
import org.jquantlib.testsuite.util.Utilities;
import org.jquantlib.time.Date;

public class OldPricer {
    public OldPricer() {
        QL.info("::::: " + this.getClass().getSimpleName() + " :::::");
    }

    void testMcSingleFactorPricers() {
        BatchData[] cases5;
        QL.info("Testing old-style Monte Carlo single-factor pricers...");
        Actual360 dc = new Actual360();
        long seed = 3456789L;
        long fixedSamples = 1023L;
        double minimumTol = 0.01;
        for (BatchData element : cases5 = new BatchData[]{new BatchData(Option.Type.Call, 90.0, 87.0, 0.06, 0.025, 0.0, 0.9166666666666666, 2, 0.13, true, 1.51917595129), new BatchData(Option.Type.Call, 90.0, 87.0, 0.06, 0.025, 0.0, 0.9166666666666666, 4, 0.13, true, 1.67940165674), new BatchData(Option.Type.Call, 90.0, 87.0, 0.06, 0.025, 0.0, 0.9166666666666666, 8, 0.13, true, 1.75371215251), new BatchData(Option.Type.Call, 90.0, 87.0, 0.06, 0.025, 0.0, 0.9166666666666666, 12, 0.13, true, 1.77595318693), new BatchData(Option.Type.Call, 90.0, 87.0, 0.06, 0.025, 0.0, 0.9166666666666666, 26, 0.13, true, 1.8143053663), new BatchData(Option.Type.Call, 90.0, 87.0, 0.06, 0.025, 0.0, 0.9166666666666666, 52, 0.13, true, 1.82269246898), new BatchData(Option.Type.Call, 90.0, 87.0, 0.06, 0.025, 0.0, 0.9166666666666666, 100, 0.13, true, 1.83822402464), new BatchData(Option.Type.Call, 90.0, 87.0, 0.06, 0.025, 0.0, 0.9166666666666666, 250, 0.13, true, 1.83875059026), new BatchData(Option.Type.Call, 90.0, 87.0, 0.06, 0.025, 0.0, 0.9166666666666666, 500, 0.13, true, 1.83750703638), new BatchData(Option.Type.Call, 90.0, 87.0, 0.06, 0.025, 0.0, 0.9166666666666666, 1000, 0.13, true, 1.83887181884), new BatchData(Option.Type.Call, 90.0, 87.0, 0.06, 0.025, 0.08333333333333333, 0.9166666666666666, 2, 0.13, true, 1.51154400089), new BatchData(Option.Type.Call, 90.0, 87.0, 0.06, 0.025, 0.08333333333333333, 0.9166666666666666, 4, 0.13, true, 1.67103508506), new BatchData(Option.Type.Call, 90.0, 87.0, 0.06, 0.025, 0.08333333333333333, 0.9166666666666666, 8, 0.13, true, 1.7452968407), new BatchData(Option.Type.Call, 90.0, 87.0, 0.06, 0.025, 0.08333333333333333, 0.9166666666666666, 12, 0.13, true, 1.76667074564), new BatchData(Option.Type.Call, 90.0, 87.0, 0.06, 0.025, 0.08333333333333333, 0.9166666666666666, 26, 0.13, true, 1.80528400613), new BatchData(Option.Type.Call, 90.0, 87.0, 0.06, 0.025, 0.08333333333333333, 0.9166666666666666, 52, 0.13, true, 1.81400883891), new BatchData(Option.Type.Call, 90.0, 87.0, 0.06, 0.025, 0.08333333333333333, 0.9166666666666666, 100, 0.13, true, 1.82922901451), new BatchData(Option.Type.Call, 90.0, 87.0, 0.06, 0.025, 0.08333333333333333, 0.9166666666666666, 250, 0.13, true, 1.82937111773), new BatchData(Option.Type.Call, 90.0, 87.0, 0.06, 0.025, 0.08333333333333333, 0.9166666666666666, 500, 0.13, true, 1.82826193186), new BatchData(Option.Type.Call, 90.0, 87.0, 0.06, 0.025, 0.08333333333333333, 0.9166666666666666, 1000, 0.13, true, 1.82967846654), new BatchData(Option.Type.Call, 90.0, 87.0, 0.06, 0.025, 0.25, 0.9166666666666666, 2, 0.13, true, 1.49648170891), new BatchData(Option.Type.Call, 90.0, 87.0, 0.06, 0.025, 0.25, 0.9166666666666666, 4, 0.13, true, 1.65443100462), new BatchData(Option.Type.Call, 90.0, 87.0, 0.06, 0.025, 0.25, 0.9166666666666666, 8, 0.13, true, 1.72817806731), new BatchData(Option.Type.Call, 90.0, 87.0, 0.06, 0.025, 0.25, 0.9166666666666666, 12, 0.13, true, 1.74877367895), new BatchData(Option.Type.Call, 90.0, 87.0, 0.06, 0.025, 0.25, 0.9166666666666666, 26, 0.13, true, 1.78733801988), new BatchData(Option.Type.Call, 90.0, 87.0, 0.06, 0.025, 0.25, 0.9166666666666666, 52, 0.13, true, 1.79624826757), new BatchData(Option.Type.Call, 90.0, 87.0, 0.06, 0.025, 0.25, 0.9166666666666666, 100, 0.13, true, 1.81114186876), new BatchData(Option.Type.Call, 90.0, 87.0, 0.06, 0.025, 0.25, 0.9166666666666666, 250, 0.13, true, 1.81101152587), new BatchData(Option.Type.Call, 90.0, 87.0, 0.06, 0.025, 0.25, 0.9166666666666666, 500, 0.13, true, 1.81002311939), new BatchData(Option.Type.Call, 90.0, 87.0, 0.06, 0.025, 0.25, 0.9166666666666666, 1000, 0.13, true, 1.81145760308)}) {
            int dt = (int)element.length / (element.fixings - 1);
            double[] timeIncrements = new double[element.fixings];
            for (int i = 0; i < element.fixings; ++i) {
                timeIncrements[i] = (double)(i * dt) + element.first;
            }
            Date today = Date.todaysDate();
            YieldTermStructure yeildStructureRiskFree = Utilities.flatRate(today, element.riskFreeRate, (DayCounter)dc);
            YieldTermStructure yeildStructureDividentYield = Utilities.flatRate(today, element.dividendYield, (DayCounter)dc);
            YieldTermStructure yieldTermStructure = Utilities.flatRate(today, element.volatility, (DayCounter)dc);
        }
    }

    private static class BatchData {
        Option.Type type;
        double underlying;
        double strike;
        double dividendYield;
        double riskFreeRate;
        double first;
        double length;
        int fixings;
        double volatility;
        boolean controlVariate;
        double result;

        public BatchData(Option.Type type, double underlying, double strike, double dividendYield, double riskFreeRate, double first, double length, int fixings, double volatility, boolean controlVariate, double result) {
            this.type = type;
            this.underlying = underlying;
            this.strike = strike;
            this.dividendYield = dividendYield;
            this.riskFreeRate = riskFreeRate;
            this.first = first;
            this.length = length;
            this.fixings = fixings;
            this.volatility = volatility;
            this.controlVariate = controlVariate;
            this.result = result;
        }
    }
}

