/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.testsuite.operators;

import org.jquantlib.QL;
import org.jquantlib.daycounters.Actual360;
import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.math.distributions.CumulativeNormalDistribution;
import org.jquantlib.math.distributions.NormalDistribution;
import org.jquantlib.math.matrixutilities.Array;
import org.jquantlib.methods.finitedifferences.BSMOperator;
import org.jquantlib.methods.finitedifferences.BSMTermOperator;
import org.jquantlib.methods.finitedifferences.DPlusMinus;
import org.jquantlib.methods.finitedifferences.DZero;
import org.jquantlib.methods.finitedifferences.TridiagonalOperator;
import org.jquantlib.processes.GeneralizedBlackScholesProcess;
import org.jquantlib.quotes.Handle;
import org.jquantlib.quotes.SimpleQuote;
import org.jquantlib.termstructures.BlackVolTermStructure;
import org.jquantlib.termstructures.YieldTermStructure;
import org.jquantlib.testsuite.util.Utilities;
import org.jquantlib.time.Date;
import org.jquantlib.time.Period;
import org.jquantlib.time.TimeUnit;
import org.junit.Assert;
import org.junit.Test;

public class OperatorTest {
    public OperatorTest() {
        QL.info("::::: " + this.getClass().getSimpleName() + " :::::");
    }

    @Test
    public void testConsistency() {
        int i;
        QL.info("Testing differential operators...");
        double average = 0.0;
        double sigma = 1.0;
        NormalDistribution normal = new NormalDistribution(0.0, 1.0);
        CumulativeNormalDistribution cum = new CumulativeNormalDistribution(0.0, 1.0);
        double xMin = -4.0;
        double xMax = 4.0;
        int N = 10001;
        double h = 8.0E-4;
        Array x = new Array(10001);
        Array y = new Array(10001);
        Array yi = new Array(10001);
        Array yd = new Array(10001);
        Array temp = new Array(10001);
        Array diff = new Array(10001);
        for (i = 0; i < x.size(); ++i) {
            x.set(i, -4.0 + 8.0E-4 * (double)i);
        }
        for (i = 0; i < x.size(); ++i) {
            y.set(i, normal.op(x.get(i)));
        }
        for (i = 0; i < x.size(); ++i) {
            yi.set(i, cum.op(x.get(i)));
        }
        for (i = 0; i < x.size(); ++i) {
            yd.set(i, normal.derivative(x.get(i)));
        }
        DZero D = new DZero(10001, 8.0E-4);
        DPlusMinus D2 = new DPlusMinus(10001, 8.0E-4);
        temp = D.applyTo(yi);
        for (i = 0; i < y.size(); ++i) {
            diff.set(i, y.get(i) - temp.get(i));
        }
        double e = Utilities.norm(diff, 8.0E-4);
        if (e > 1.0E-6) {
            Assert.fail((String)("norm of 1st derivative of cum minus Gaussian: " + e + "\ntolerance exceeded"));
        }
        temp = D2.applyTo(yi);
        for (i = 0; i < yd.size(); ++i) {
            diff.set(i, yd.get(i) - temp.get(i));
        }
        e = Utilities.norm(diff, 8.0E-4);
        if (e > 1.0E-4) {
            Assert.fail((String)("norm of 2nd derivative of cum minus Gaussian derivative: " + e + "\ntolerance exceeded"));
        }
    }

    public void dumpArray(Array arr) {
        for (int i = 0; i < arr.size(); ++i) {
            QL.info("**** arr[" + i + "] = " + arr.get(i));
        }
    }

    public void outputDiagonals(TridiagonalOperator op) {
        int i;
        QL.info("\n");
        StringBuilder sb = new StringBuilder();
        sb.append("[ ");
        Array data = op.lowerDiagonal();
        for (i = 0; i < data.size(); ++i) {
            sb.append(String.format(" %.4f ", data.get(i)));
        }
        sb.append(" ]");
        QL.info(sb.toString());
        sb = new StringBuilder();
        sb.append("[ ");
        data = op.diagonal();
        for (i = 0; i < data.size(); ++i) {
            sb.append(String.format(" %.4f ", data.get(i)));
        }
        sb.append(" ]");
        QL.info(sb.toString());
        sb = new StringBuilder();
        sb.append("[ ");
        data = op.upperDiagonal();
        for (i = 0; i < data.size(); ++i) {
            sb.append(String.format(" %.4f ", data.get(i)));
        }
        sb.append(" ]");
        QL.info(sb.toString());
    }

    @Test
    public void testBSMOperatorConsistency() throws Exception {
        int i;
        QL.info("Testing consistency of BSM operators...");
        Array grid = new Array(10);
        double price = 20.0;
        double factor = 1.1;
        for (i = 0; i < grid.size(); ++i) {
            grid.set(i, price);
            price *= 1.1;
        }
        double dx = Math.log(1.1);
        double r = 0.05;
        double q = 0.01;
        double sigma = 0.5;
        BSMOperator ref = new BSMOperator(grid.size(), dx, 0.05, 0.01, 0.5);
        QL.info("BSMOperator reference diagonals: \n");
        this.outputDiagonals(ref);
        Actual360 dc = new Actual360();
        Date today = Date.todaysDate();
        Date exercise = today.clone();
        exercise = exercise.add(new Period(2, TimeUnit.Years));
        double residualTime = dc.yearFraction(today, exercise);
        SimpleQuote spot = new SimpleQuote(0.0);
        YieldTermStructure qTS = Utilities.flatRate(today, 0.01, (DayCounter)dc);
        YieldTermStructure rTS = Utilities.flatRate(today, 0.05, (DayCounter)dc);
        BlackVolTermStructure volTS = Utilities.flatVol(today, 0.5, (DayCounter)dc);
        GeneralizedBlackScholesProcess stochProcess = new GeneralizedBlackScholesProcess(new Handle<SimpleQuote>(spot), new Handle<YieldTermStructure>(qTS), new Handle<YieldTermStructure>(rTS), new Handle<BlackVolTermStructure>(volTS));
        BSMOperator op1 = new BSMOperator(grid, stochProcess, residualTime);
        QL.info("BSMOperator diagonals: \n");
        this.outputDiagonals(op1);
        BSMTermOperator op2 = new BSMTermOperator(grid, stochProcess, residualTime);
        QL.info("PdeOperator diagonals: \n");
        this.outputDiagonals(op2);
        double tolerance = 1.0E-6;
        Array lderror = ref.lowerDiagonal().clone();
        lderror.subAssign(op1.lowerDiagonal());
        Array derror = ref.diagonal().clone();
        derror.subAssign(op1.diagonal());
        Array uderror = ref.upperDiagonal().clone();
        uderror.subAssign(op1.upperDiagonal());
        for (i = 2; i < grid.size() - 2; ++i) {
            QL.info("lderror(" + i + ") = " + Math.abs(lderror.get(i)) + " tolerance " + 1.0E-6 + " \n");
            QL.info("derror(" + i + ") = " + Math.abs(derror.get(i)) + " tolerance " + 1.0E-6 + " \n");
            QL.info("uderror(" + i + ") = " + Math.abs(uderror.get(i)) + " tolerance " + 1.0E-6 + " \n");
            if (!(Math.abs(lderror.get(i)) > 1.0E-6) && !(Math.abs(derror.get(i)) > 1.0E-6) && !(Math.abs(uderror.get(i)) > 1.0E-6)) continue;
            Assert.fail((String)("inconsistency between BSM operators:\n" + Integer.toString(i) + " row:\n" + "expected:   " + ref.lowerDiagonal().get(i) + ", " + ref.diagonal().get(i) + ", " + ref.upperDiagonal().get(i) + "\n" + "calculated: " + op1.lowerDiagonal().get(i) + ", " + op1.diagonal().get(i) + ", " + op1.upperDiagonal().get(i)));
        }
        lderror = ref.lowerDiagonal();
        lderror.subAssign(op2.lowerDiagonal());
        derror = ref.diagonal();
        derror.subAssign(op2.diagonal());
        uderror = ref.upperDiagonal();
        uderror.subAssign(op2.upperDiagonal());
        for (i = 2; i < grid.size() - 2; ++i) {
            if (!(Math.abs(lderror.get(i)) > 1.0E-6) && !(Math.abs(derror.get(i)) > 1.0E-6) && !(Math.abs(uderror.get(i)) > 1.0E-6)) continue;
            Assert.fail((String)("inconsistency between BSM operators:\n" + Integer.toString(i) + " row:\n" + "expected:   " + ref.lowerDiagonal().get(i) + ", " + ref.diagonal().get(i) + ", " + ref.upperDiagonal().get(i) + "\n" + "calculated: " + op2.lowerDiagonal().get(i) + ", " + op2.diagonal().get(i) + ", " + op2.upperDiagonal().get(i)));
        }
    }
}

