/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.testsuite.math.statistics;

import java.util.List;
import org.jquantlib.QL;
import org.jquantlib.math.matrixutilities.Array;
import org.jquantlib.math.statistics.ConvergenceStatistics;
import org.jquantlib.math.statistics.GenericRiskStatistics;
import org.jquantlib.math.statistics.GenericSequenceStatistics;
import org.jquantlib.math.statistics.IncrementalStatistics;
import org.jquantlib.math.statistics.RiskStatistics;
import org.jquantlib.util.Pair;
import org.junit.Assert;
import org.junit.Test;

public class StatisticsTest {
    private final Array data;
    private final Array weights;

    public StatisticsTest() {
        QL.info("Testing volatility model construction...");
        this.data = new Array(new double[]{3.0, 4.0, 5.0, 2.0, 3.0, 4.0, 5.0, 6.0, 4.0, 7.0});
        this.weights = new Array(new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0});
    }

    @Test
    public void testStatistics() {
        QL.info("Testing statistics ...");
        this.check(new RiskStatistics(), "Statistics");
    }

    @Test
    public void testIncrementalStatistics() {
        QL.info("Testing incremental statistics ...");
        this.check(new IncrementalStatistics(), "IncrementalStatistics");
    }

    @Test
    public void testSequenceStatistics() {
        QL.info("Testing sequence statistics ...");
        this.checkSequence(new RiskStatistics(), "Statistics", 5);
        this.checkSequence(new IncrementalStatistics(), "IncrementalStatistics", 5);
    }

    @Test
    public void testConvergenceStatistics() {
        QL.info("Testing convergence statistics ...");
        this.checkConvergence(new RiskStatistics(), "Statistics");
        this.checkConvergence(new IncrementalStatistics(), "IncrementalStatistics");
    }

    private void check(GenericRiskStatistics s, String name) {
        for (int i = 0; i < this.data.size(); ++i) {
            s.add(this.data.get(i), this.weights.get(i));
        }
        if (s.samples() != this.data.size()) {
            Assert.fail((String)("wrong number of samples \ncalculated: " + s.samples() + "\n" + "expected: " + this.data.size()));
        }
        double expected = this.weights.accumulate();
        double calculated = s.weightSum();
        if (calculated != expected) {
            Assert.fail((String)(name + ": wrong sum of weights\n" + "    calculated: " + calculated + "\n" + "    expected:   " + expected));
        }
        expected = this.data.min();
        calculated = s.min();
        if (calculated != expected) {
            Assert.fail((String)(name + ": wrong minimum value \n" + "calculated: " + calculated + "\n" + "expected: " + expected));
        }
        expected = this.data.max();
        calculated = s.max();
        if (calculated != expected) {
            Assert.fail((String)(name + ": wrong maxmimum value \n" + "calculated: " + expected + "\n" + "expected: " + expected));
        }
        expected = 4.3;
        double tolerance = 1.0E-9;
        calculated = s.mean();
        if (Math.abs(calculated - expected) > tolerance) {
            Assert.fail((String)(name + "wrong mean value" + "\n" + "calculated: " + calculated + "\n" + "expected: " + expected));
        }
        expected = 2.23333333333;
        calculated = s.variance();
        if (Math.abs(calculated - expected) > tolerance) {
            Assert.fail((String)(name + "wrong variance" + "\n" + "calculated: " + calculated + "\n" + "expected: " + expected));
        }
        expected = 1.4944341181;
        calculated = s.standardDeviation();
        if (Math.abs(calculated - expected) > tolerance) {
            Assert.fail((String)(name + "wrong standard deviation" + "\n" + "calculated: " + calculated + "\n" + "expected: " + expected));
        }
        expected = 0.359543071407;
        calculated = s.skewness();
        if (Math.abs(calculated - expected) > tolerance) {
            Assert.fail((String)(name + "wrong skewness" + "\n" + "calculated: " + calculated + "\n" + "expected: " + expected));
        }
        expected = -0.151799637209;
        calculated = s.kurtosis();
        if (Math.abs(calculated - expected) > tolerance) {
            Assert.fail((String)(name + "wrong skewness" + "\n" + "calculated: " + calculated + "\n" + "expected: " + expected));
        }
    }

    private void checkSequence(GenericRiskStatistics stat, String name, int dimension) {
        int i;
        GenericSequenceStatistics ss = new GenericSequenceStatistics(dimension);
        for (i = 0; i < this.data.size(); ++i) {
            Array temp = new Array(dimension);
            temp.fill(this.data.get(i));
            ss.add(temp, this.weights.get(i));
        }
        if (ss.samples() != this.data.size()) {
            Assert.fail((String)("SequenceStatistics<" + name + ">: " + "wrong number of samples\n" + "    calculated: " + ss.samples() + "\n" + "    expected:   " + this.data.size()));
        }
        double expected = this.weights.accumulate(0.0);
        if (ss.weightSum() != expected) {
            Assert.fail((String)("SequenceStatistics<" + name + ">: " + "wrong sum of weights\n" + "    calculated: " + ss.weightSum() + "\n" + "    expected:   " + expected));
        }
        expected = this.data.min();
        Array calculated = ss.min();
        for (i = 0; i < dimension; ++i) {
            if (calculated.get(i) == expected) continue;
            Assert.fail((String)("SequenceStatistics<" + name + ">: " + (i + 1) + " dimension: " + "wrong minimum value\n" + "    calculated: " + calculated.get(i) + "\n" + "    expected:   " + expected));
        }
        expected = this.data.max();
        calculated = ss.max();
        for (i = 0; i < dimension; ++i) {
            if (calculated.get(i) == expected) continue;
            Assert.fail((String)("SequenceStatistics<" + name + ">: " + (i + 1) + " dimension: " + "wrong maximun value\n" + "    calculated: " + calculated.get(i) + "\n" + "    expected:   " + expected));
        }
        expected = 4.3;
        double tolerance = 1.0E-9;
        calculated = ss.mean();
        for (i = 0; i < dimension; ++i) {
            if (!(Math.abs(calculated.get(i) - expected) > tolerance)) continue;
            Assert.fail((String)("SequenceStatistics<" + name + ">: " + (i + 1) + " dimension: " + "wrong mean value\n" + "    calculated: " + calculated.get(i) + "\n" + "    expected:   " + expected));
        }
        expected = 2.23333333333;
        calculated = ss.variance();
        for (i = 0; i < dimension; ++i) {
            if (!(Math.abs(calculated.get(i) - expected) > tolerance)) continue;
            Assert.fail((String)("SequenceStatistics<" + name + ">: " + (i + 1) + " dimension: " + "wrong variance\n" + "    calculated: " + calculated.get(i) + "\n" + "    expected:   " + expected));
        }
        expected = 1.4944341181;
        calculated = ss.standardDeviation();
        for (i = 0; i < dimension; ++i) {
            if (!(Math.abs(calculated.get(i) - expected) > tolerance)) continue;
            Assert.fail((String)("SequenceStatistics<" + name + ">: " + (i + 1) + " dimension: " + "wrong standard deviation\n" + "    calculated: " + calculated.get(i) + "\n" + "    expected:   " + expected));
        }
        expected = 0.359543071407;
        calculated = ss.skewness();
        for (i = 0; i < dimension; ++i) {
            if (!(Math.abs(calculated.get(i) - expected) > tolerance)) continue;
            Assert.fail((String)("SequenceStatistics<" + name + ">: " + (i + 1) + " dimension: " + "wrong skewness\n" + "    calculated: " + calculated.get(i) + "\n" + "    expected:   " + expected));
        }
        expected = -0.151799637209;
        calculated = ss.kurtosis();
        for (i = 0; i < dimension; ++i) {
            if (!(Math.abs(calculated.get(i) - expected) > tolerance)) continue;
            Assert.fail((String)("SequenceStatistics<" + name + ">: " + (i + 1) + " dimension: " + "wrong kurtosis\n" + "    calculated: " + calculated.get(i) + "\n" + "    expected:   " + expected));
        }
    }

    private void checkConvergence(GenericRiskStatistics stat, String name) {
        ConvergenceStatistics stats = new ConvergenceStatistics();
        stats.add(1.0);
        stats.add(2.0);
        stats.add(3.0);
        stats.add(4.0);
        stats.add(5.0);
        stats.add(6.0);
        stats.add(7.0);
        stats.add(8.0);
        int expectedSize1 = 3;
        int calculatedSize = stats.convergenceTable().size();
        if (calculatedSize != 3) {
            Assert.fail((String)("ConvergenceStatistics<" + name + ">: " + "\nwrong convergence-table size" + "\n    calculated: " + calculatedSize + "\n    expected:   " + 3));
        }
        double tolerance = 1.0E-9;
        double expectedValue1 = 4.0;
        List<Pair<Integer, Double>> table = stats.convergenceTable();
        double calculatedValue = table.get(table.size() - 1).second();
        if (Math.abs(calculatedValue - 4.0) > 1.0E-9) {
            Assert.fail((String)("wrong last value in convergence table\n    calculated: " + calculatedValue + "\n    expected:   " + 4.0));
        }
        int expectedSampleSize1 = 7;
        List<Pair<Integer, Double>> table2 = stats.convergenceTable();
        int calculatedSamples = table2.get(table2.size() - 1).first();
        if (calculatedSamples != 7) {
            Assert.fail((String)("wrong number of samples in convergence table\n    calculated: " + calculatedSamples + "\n    expected:   " + 7));
        }
        stats.reset();
        stats.add(1.0);
        stats.add(2.0);
        stats.add(3.0);
        stats.add(4.0);
        int expectedSize2 = 2;
        calculatedSize = stats.convergenceTable().size();
        if (calculatedSize != 2) {
            Assert.fail((String)("wrong convergence-table size\n    calculated: " + calculatedSize + "\n    expected:   " + 2));
        }
        double expectedValue2 = 2.0;
        List<Pair<Integer, Double>> table3 = stats.convergenceTable();
        double calculatedValue2 = table3.get(table3.size() - 1).second();
        if (Math.abs(calculatedValue2 - 2.0) > 1.0E-9) {
            Assert.fail((String)("wrong last value in convergence table\n    calculated: " + calculatedValue2 + "\n    expected:   " + 2.0));
        }
        int expectedSampleSize2 = 3;
        table = stats.convergenceTable();
        int calculatedSamples2 = table.get(table.size() - 1).first();
        if (calculatedSamples2 != 3) {
            Assert.fail((String)("wrong number of samples in convergence table\n    calculated: " + calculatedSamples2 + "\n    expected:   " + 3));
        }
    }
}

