/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.testsuite.math.solvers1D;

import org.jquantlib.QL;
import org.jquantlib.math.distributions.Derivative;
import org.jquantlib.math.solvers1D.Secant;
import org.junit.Assert;
import org.junit.Test;

public class SecantTest {
    public SecantTest() {
        QL.info("::::: " + this.getClass().getSimpleName() + " :::::");
    }

    @Test
    public void secantTest() {
        double accuracy = 1.0E-15;
        double guess = 1.5;
        double xMin = 0.0;
        double xMax = 3.0;
        Secant secant = new Secant();
        Derivative f = new Derivative(){

            @Override
            public double op(double x) {
                return x * x - 1.0;
            }

            @Override
            public double derivative(double x) {
                return 2.0 * x;
            }
        };
        double root = secant.solve(f, 1.0E-15, 1.5, 0.0, 3.0);
        if (Math.abs(1.0 - root) > 1.0E-15) {
            Assert.fail((String)("expected: 1.0 but root is: " + root));
        }
        if (secant.getMaxEvaluations() != 100) {
            Assert.fail((String)("expected: 100 but was: " + secant.getMaxEvaluations()));
        }
        if (Math.abs(1.0 - (root = secant.solve(f, 1.0E-15, 0.01, 0.1))) > 1.0E-15) {
            Assert.fail((String)("expected: 1.0 but root is: " + root));
        }
    }
}

