/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.testsuite.math.interpolations;

import org.jquantlib.QL;
import org.jquantlib.math.interpolations.Interpolation2D;
import org.jquantlib.math.interpolations.factories.Bilinear;
import org.jquantlib.math.matrixutilities.Array;
import org.jquantlib.math.matrixutilities.Matrix;
import org.junit.Assert;
import org.junit.Test;

public class BilinearInterpolationTest {
    private final Array x = new Array(new double[]{0.0, 1.0, 2.0, 3.0, 4.0});
    private final Array y = new Array(new double[]{0.0, 1.0, 2.0, 3.0, 4.0});
    private final Array x_test = new Array(new double[]{-0.5, 0.0, 0.5, 1.5, 2.5, 3.5, 4.5});
    private final Array y_test = new Array(new double[]{-0.5, 0.0, 0.5, 1.5, 2.5, 3.5, 4.5});
    private final Matrix zz;
    private final Interpolation2D interpolation2d;
    private final double tolerance;

    public BilinearInterpolationTest() {
        QL.info("::::: " + this.getClass().getSimpleName() + " :::::");
        QL.info("::::: Testing use of interpolations as functors... :::::");
        this.zz = new Matrix(this.x.size(), this.y.size());
        for (int i = 0; i < this.x.size(); ++i) {
            for (int ii = 0; ii < this.y.size(); ++ii) {
                double value = this.x.get(i) + this.y.get(ii);
                this.zz.set(i, ii, value);
            }
        }
        this.interpolation2d = new Bilinear().interpolate(this.x, this.y, this.zz);
        this.interpolation2d.update();
        this.tolerance = 1.0E-12;
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowIllegalArgumentExceptionWithoutEnableExtrapolation() {
        for (int i_x = 0; i_x < this.x_test.size(); ++i_x) {
            for (int i_y = 0; i_y < this.y_test.size(); ++i_y) {
                this.interpolation2d.op(this.x_test.get(i_x), this.y_test.get(i_y));
            }
        }
    }

    @Test
    public void testEnableExtrapolation() {
        this.interpolation2d.enableExtrapolation();
        for (int i_x = 0; i_x < this.x_test.size(); ++i_x) {
            for (int i_y = 0; i_y < this.y_test.size(); ++i_y) {
                double expected;
                double interpolated = this.interpolation2d.op(this.x_test.get(i_x), this.y_test.get(i_y));
                if (!(Math.abs(interpolated - (expected = this.x_test.get(i_x) + this.y_test.get(i_y))) > this.tolerance)) continue;
                Assert.fail((String)("failed to interpolate value at x = " + this.x_test.get(i_x) + ", y = " + this.y_test.get(i_y)));
            }
        }
    }
}

