/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.testsuite.math.interpolations;

import org.jquantlib.QL;
import org.jquantlib.math.interpolations.Interpolation;
import org.jquantlib.math.interpolations.factories.BackwardFlat;
import org.jquantlib.math.matrixutilities.Array;
import org.junit.Assert;
import org.junit.Test;

public class BackwardInterpolationTest {
    private static final Array x = new Array(new double[]{0.0, 1.0, 2.0, 3.0, 4.0});
    private static final Array y = new Array(new double[]{5.0, 4.0, 3.0, 2.0, 1.0});
    private final Interpolation interpolation;
    private final int length;
    private final double tolerance;

    public BackwardInterpolationTest() {
        QL.info("::::: " + this.getClass().getSimpleName() + " :::::");
        this.interpolation = new BackwardFlat().interpolate(x, y);
        this.length = x.size();
        this.tolerance = 1.0E-12;
    }

    @Test
    public void checkAtOriginalPoints() {
        for (int i = 0; i < this.length; ++i) {
            double d = x.get(i);
            double calculated = this.interpolation.op(d);
            double expected = y.get(i);
            Assert.assertFalse((String)("failed to reproduce " + i + " datum" + "\n expected:     " + expected + "\n calculated:   " + calculated + "\n error:        " + Math.abs(expected - calculated)), (Math.abs(expected - calculated) > this.tolerance ? 1 : 0) != 0);
        }
    }

    @Test
    public void checkAtMiddlePoints() {
        for (int i = 0; i < this.length - 1; ++i) {
            double d = (x.get(i) + x.get(i + 1)) / 2.0;
            double calculated = this.interpolation.op(d);
            double expected = y.get(i + 1);
            Assert.assertFalse((String)("failed to interpolate correctly at " + d + "\n expected:     " + expected + "\n calculated:   " + calculated + "\n error:        " + Math.abs(expected - calculated)), (Math.abs(expected - calculated) > this.tolerance ? 1 : 0) != 0);
        }
    }

    @Test
    public void checkOutsideOriginalRange() {
        this.interpolation.enableExtrapolation();
        double d = x.first() - 0.5;
        double calculated = this.interpolation.op(d);
        double expected = y.first();
        Assert.assertFalse((String)("failed to extrapolate correctly at " + d + "\n expected:     " + expected + "\n calculated:   " + calculated + "\n error:        " + Math.abs(expected - calculated)), (Math.abs(expected - calculated) > this.tolerance ? 1 : 0) != 0);
        d = x.last() + 0.5;
        calculated = this.interpolation.op(d);
        expected = y.last();
        Assert.assertFalse((String)("failed to extrapolate correctly at " + d + "\n expected:     " + expected + "\n calculated:   " + calculated + "\n error:        " + Math.abs(expected - calculated)), (Math.abs(expected - calculated) > this.tolerance ? 1 : 0) != 0);
    }

    @Test
    public void checkPrimitiveAtOriginalPoints() {
        double calculated = this.interpolation.primitive(x.first());
        double expected = 0.0;
        Assert.assertFalse((String)("failed to calculate primitive at " + x.first() + "\n expected:     " + expected + "\n calculated:   " + calculated + "\n error:        " + Math.abs(expected - calculated)), (Math.abs(expected - calculated) > this.tolerance ? 1 : 0) != 0);
        double sum = 0.0;
        for (int i = 1; i < this.length - 1; ++i) {
            calculated = this.interpolation.primitive(x.get(i));
            expected = sum += (x.get(i) - x.get(i - 1)) * y.get(i);
            Assert.assertFalse((String)("failed to calculate primitive at " + x.get(i) + "\n expected:     " + expected + "\n calculated:   " + calculated + "\n error:        " + Math.abs(expected - calculated)), (Math.abs(expected - calculated) > this.tolerance ? 1 : 0) != 0);
        }
    }

    @Test
    public void checkPrimitiveAtMiddlePoints() {
        double sum = 0.0;
        for (int i = 0; i < this.length - 1; ++i) {
            double d = (x.get(i) + x.get(i + 1)) / 2.0;
            double calculated = this.interpolation.primitive(d);
            double expected = sum += (x.get(i + 1) - x.get(i)) * y.get(i + 1) / 2.0;
            sum += (x.get(i + 1) - x.get(i)) * y.get(i + 1) / 2.0;
            Assert.assertFalse((String)("failed to calculate primitive at " + x.get(i) + "\n expected:     " + expected + "\n calculated:   " + calculated + "\n error:        " + Math.abs(expected - calculated)), (Math.abs(expected - calculated) > this.tolerance ? 1 : 0) != 0);
        }
    }
}

