/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.testsuite.math.distributions;

import org.jquantlib.QL;
import org.jquantlib.Settings;
import org.jquantlib.math.distributions.InverseCumulativeNormal;
import org.junit.Assert;
import org.junit.Test;

public class InverseCumulativeNormalTest {
    public InverseCumulativeNormalTest() {
        QL.info("::::: " + this.getClass().getSimpleName() + " :::::");
    }

    @Test
    public void testInverseCumulativeNormal() {
        double tolerance;
        double x_position;
        QL.info("Running new test");
        double[][] normal_testvalues = new double[][]{{0.01, -2.326347874388028}, {0.1, -1.2815515641401563}, {0.2, -0.8416212327266185}, {0.3, -0.5244005132792953}, {0.4, -0.2533471028599986}, {0.5, 0.0}, {0.6, 0.2533471028599986}, {0.7, 0.5244005132792952}, {0.8, 0.8416212327266186}, {0.9, 1.2815515641401563}, {0.99, 2.326347874388028}};
        double[][] precision_testvalues = new double[][]{{0.01, -2.3263478740408416}, {0.1, -1.2815515655446004}, {0.2, -0.8416212335729143}, {0.3, -0.5244005127080408}, {0.4, -0.2533471031357998}, {0.5, 0.0}, {0.6, 0.2533471031357996}, {0.7, 0.5244005127080406}, {0.8, 0.8416212335729144}, {0.9, 1.2815515655446004}, {0.99, 2.326347874040841}};
        Settings settings = new Settings();
        boolean oldHighPrecision = settings.isRefineHighPrecisionUsingHalleysMethod();
        settings.setRefineHighPrecisionUsingHalleysMethod(false);
        InverseCumulativeNormal icn = new InverseCumulativeNormal();
        for (double[] normalTestvalue : normal_testvalues) {
            x_position = normalTestvalue[0];
            tolerance = 1.0E-15;
            double normal_expected = normalTestvalue[1];
            double computed_normal = icn.op(x_position);
            if (!(Math.abs(normal_expected - computed_normal) > 1.0E-15)) continue;
            Assert.fail((String)("x_position " + x_position + " normal_expected: " + normal_expected + " normal_computed: " + normal_expected));
        }
        settings.setRefineHighPrecisionUsingHalleysMethod(true);
        icn = new InverseCumulativeNormal();
        for (double[] precisionTestvalue : precision_testvalues) {
            x_position = precisionTestvalue[0];
            tolerance = 1.0E-15;
            double precision_expected = precisionTestvalue[1];
            double computed_precision = icn.op(x_position);
            if (!(Math.abs(precision_expected - computed_precision) > 1.0E-15)) continue;
            Assert.fail((String)("x_position " + x_position + " precision_expected: " + precision_expected + " precision_computed: " + computed_precision));
        }
        settings.setRefineHighPrecisionUsingHalleysMethod(oldHighPrecision);
    }
}

