/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.testsuite.math.distributions;

import org.jquantlib.QL;
import org.jquantlib.math.distributions.BivariateNormalDistribution;
import org.junit.Assert;
import org.junit.Test;

public class BivariateNormalDistributionTest {
    public BivariateNormalDistributionTest() {
        QL.info("::::: " + this.getClass().getSimpleName() + " :::::");
    }

    @Test
    public void testBivariateAtZero() {
        double[] rho = new double[]{0.0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 0.99999};
        double x = 0.0;
        double y = 0.0;
        double tolerance = 1.0E-15;
        for (double element : rho) {
            Integer sgn = -1;
            while (sgn < 2) {
                BivariateNormalDistribution bvn = new BivariateNormalDistribution((double)sgn.intValue() * element);
                double expected = 0.25 + Math.asin((double)sgn.intValue() * element) / (Math.PI * 2);
                double realised = bvn.op(0.0, 0.0);
                if (Math.abs(realised - expected) >= 1.0E-15) {
                    Assert.fail((String)(" bivariate cumulative distribution\n    rho: " + (double)sgn.intValue() * element + "\n" + "    expected:  " + expected + "\n" + "    realised:  " + realised + "\n" + "    tolerance: " + 1.0E-15));
                }
                sgn = sgn + 2;
            }
        }
    }

    @Test
    public void testHaugValues() {
        double[][] values = new double[][]{{0.0, 0.0, 0.0, 0.25}, {0.0, 0.0, -0.5, 0.166667}, {0.0, 0.0, 0.5, 0.3333333333333333}, {0.0, -0.5, 0.0, 0.154269}, {0.0, -0.5, -0.5, 0.08166}, {0.0, -0.5, 0.5, 0.226878}, {0.0, 0.5, 0.0, 0.345731}, {0.0, 0.5, -0.5, 0.273122}, {0.0, 0.5, 0.5, 0.41834}, {-0.5, 0.0, 0.0, 0.154269}, {-0.5, 0.0, -0.5, 0.08166}, {-0.5, 0.0, 0.5, 0.226878}, {-0.5, -0.5, 0.0, 0.095195}, {-0.5, -0.5, -0.5, 0.036298}, {-0.5, -0.5, 0.5, 0.163319}, {-0.5, 0.5, 0.0, 0.213342}, {-0.5, 0.5, -0.5, 0.145218}, {-0.5, 0.5, 0.5, 0.272239}, {0.5, 0.0, 0.0, 0.345731}, {0.5, 0.0, -0.5, 0.273122}, {0.5, 0.0, 0.5, 0.41834}, {0.5, -0.5, 0.0, 0.213342}, {0.5, -0.5, -0.5, 0.145218}, {0.5, -0.5, 0.5, 0.272239}, {0.5, 0.5, 0.0, 0.47812}, {0.5, 0.5, -0.5, 0.419223}, {0.5, 0.5, 0.5, 0.546244}, {0.0, 0.0, Math.sqrt(0.5), 0.375}, {0.0, 30.0, -1.0, 0.5}, {0.0, 30.0, 0.0, 0.5}, {0.0, 30.0, 1.0, 0.5}, {30.0, 30.0, -1.0, 1.0}, {30.0, 30.0, 0.0, 1.0}, {30.0, 30.0, 1.0, 1.0}, {-30.0, -1.0, -1.0, 0.0}, {-30.0, 0.0, -1.0, 0.0}, {-30.0, 1.0, -1.0, 0.0}, {-30.0, -1.0, 0.0, 0.0}, {-30.0, 0.0, 0.0, 0.0}, {-30.0, 1.0, 0.0, 0.0}, {-30.0, -1.0, 1.0, 0.0}, {-30.0, 0.0, 1.0, 0.0}, {-30.0, 1.0, 1.0, 0.0}};
        for (int i = 0; i < values.length; ++i) {
            double a = values[i][0];
            double b = values[i][1];
            double rho = values[i][2];
            double result = values[i][3];
            BivariateNormalDistribution bcd = new BivariateNormalDistribution(rho);
            double value = bcd.op(a, b);
            double tolerance = 1.0E-6;
            if (!(Math.abs(value - result) >= 1.0E-6)) continue;
            Assert.fail((String)(" bivariate cumulative distribution\n    case: " + i + 1 + "\n" + "    a:    " + a + "\n" + "    b:    " + b + "\n" + "    rho:  " + rho + "\n" + "    tabulated value:  " + result + "\n" + "    result:           " + value));
        }
    }
}

