/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.testsuite.math;

import java.util.EnumSet;
import java.util.Set;
import org.jquantlib.QL;
import org.jquantlib.lang.annotation.QualityAssurance;
import org.jquantlib.math.Closeness;
import org.jquantlib.math.matrixutilities.Array;
import org.jquantlib.math.matrixutilities.Identity;
import org.jquantlib.math.matrixutilities.Matrix;
import org.jquantlib.math.matrixutilities.QRDecomposition;
import org.jquantlib.math.matrixutilities.SymmetricSchurDecomposition;
import org.jquantlib.math.matrixutilities.internal.Address;
import org.jquantlib.testsuite.math.ArrayTest;
import org.junit.Assert;
import org.junit.Test;

@QualityAssurance(quality=QualityAssurance.Quality.Q0_UNFINISHED, version=QualityAssurance.Version.V097, reviewers={""})
public class MatrixTest {
    private final Set<Address.Flags> jFlags;
    private final Set<Address.Flags> fFlags;
    private static final String RangeRow_FAILED = "RangeRow failed";
    private static final String RangeCol_FAILED = "RangeCol failed";
    private static final String WRONG_EXCEPTION = "wrong exception was thrown";
    private static final String MISSING_EXCEPTION = "failed to throw an exception";
    private static final String TEST_SUCCEEDED = "**** Exception caught: TEST SUCCEEDED *****";

    public MatrixTest() {
        QL.info("::::: " + this.getClass().getSimpleName() + " :::::");
        this.jFlags = EnumSet.noneOf(Address.Flags.class);
        this.fFlags = EnumSet.of(Address.Flags.FORTRAN);
    }

    @Test
    public void testToString() {
        this.testToString(this.jFlags);
        this.testToString(this.fFlags);
    }

    private void testToString(Set<Address.Flags> flags) {
        Matrix M1 = new Matrix(new double[][]{{1.0, 0.9, 0.7}, {0.9, 1.0, 0.4}, {0.7, 0.4, 1.0}}, flags);
        Matrix M2 = new Matrix(new double[][]{{1.0, 0.9, 0.7}, {0.9, 1.0, 0.3}, {0.7, 0.3, 1.0}}, flags);
        Identity I = new Identity(3, flags);
        Matrix M3 = new Matrix(new double[][]{{1.0, 2.0, 3.0, 4.0}, {2.0, 0.0, 2.0, 1.0}, {0.0, 1.0, 0.0, 0.0}}, flags);
        Matrix M4 = new Matrix(new double[][]{{1.0, 2.0, 400.0}, {2.0, 0.0, 1.0}, {30.0, 2.0, 0.0}, {2.0, 0.0, 1.05}}, flags);
        Matrix M5 = new Matrix(new double[][]{{2.0, -1.0, 0.0, 0.0}, {-1.0, 2.0, -1.0, 0.0}, {0.0, -1.0, 2.0, -1.0}, {0.0, 0.0, -1.0, 2.0}}, flags);
        Matrix[] matrices = new Matrix[]{M1, M2, M3, M4, M5};
    }

    @Test
    public void toFortran() {
        this.toFortran(this.jFlags);
        this.toFortran(this.fFlags);
    }

    private void toFortran(Set<Address.Flags> flags) {
        Matrix M1 = new Matrix(new double[][]{{1.0, 0.9, 0.7}, {0.9, 1.0, 0.4}, {0.7, 0.4, 1.0}}, flags);
        Matrix M2 = new Matrix(new double[][]{{1.0, 0.9, 0.7}, {0.9, 1.0, 0.3}, {0.7, 0.3, 1.0}}, flags);
        Identity I = new Identity(3, flags);
        Matrix M3 = new Matrix(new double[][]{{1.0, 2.0, 3.0, 4.0}, {2.0, 0.0, 2.0, 1.0}, {0.0, 1.0, 0.0, 0.0}}, flags);
        Matrix M4 = new Matrix(new double[][]{{1.0, 2.0, 400.0}, {2.0, 0.0, 1.0}, {30.0, 2.0, 0.0}, {2.0, 0.0, 1.05}}, flags);
        Matrix M5 = new Matrix(new double[][]{{2.0, -1.0, 0.0, 0.0}, {-1.0, 2.0, -1.0, 0.0}, {0.0, -1.0, 2.0, -1.0}, {0.0, 0.0, -1.0, 2.0}}, flags);
        Matrix[] matrices = new Matrix[]{M1, M2, M3, M4, M5};
    }

    @Test
    public void toJava() {
        this.toJava(this.jFlags);
        this.toJava(this.fFlags);
    }

    private void toJava(Set<Address.Flags> flags) {
        Matrix M1 = new Matrix(new double[][]{{1.0, 0.9, 0.7}, {0.9, 1.0, 0.4}, {0.7, 0.4, 1.0}}, flags);
        Matrix M2 = new Matrix(new double[][]{{1.0, 0.9, 0.7}, {0.9, 1.0, 0.3}, {0.7, 0.3, 1.0}}, flags);
        Identity I = new Identity(3, flags);
        Matrix M3 = new Matrix(new double[][]{{1.0, 2.0, 3.0, 4.0}, {2.0, 0.0, 2.0, 1.0}, {0.0, 1.0, 0.0, 0.0}}, flags);
        Matrix M4 = new Matrix(new double[][]{{1.0, 2.0, 400.0}, {2.0, 0.0, 1.0}, {30.0, 2.0, 0.0}, {2.0, 0.0, 1.05}}, flags);
        Matrix M5 = new Matrix(new double[][]{{2.0, -1.0, 0.0, 0.0}, {-1.0, 2.0, -1.0, 0.0}, {0.0, -1.0, 2.0, -1.0}, {0.0, 0.0, -1.0, 2.0}}, flags);
        Matrix[] matrices = new Matrix[]{M1, M2, M3, M4, M5};
    }

    public static boolean equals(Matrix a, Matrix b) {
        if (a.size() != b.size()) {
            return false;
        }
        int offsetA = a.offset();
        int offsetB = b.offset();
        for (int i = 0; i < a.rows(); ++i) {
            for (int j = 0; j < a.cols(); ++j) {
                if (a.get(i + offsetA, j + offsetA) == b.get(i + offsetB, j + offsetB)) continue;
                return false;
            }
        }
        return true;
    }

    @Test
    public void testClone() {
        this.testClone(this.jFlags, this.jFlags);
        this.testClone(this.jFlags, this.fFlags);
        this.testClone(this.fFlags, this.jFlags);
        this.testClone(this.fFlags, this.fFlags);
    }

    private void testClone(Set<Address.Flags> flagsA, Set<Address.Flags> flagsB) {
        Matrix mA = new Matrix(new double[][]{{1.0, 2.0, 3.0, 4.0}, {1.0, 2.0, 3.0, 4.0}, {1.0, 2.0, 3.0, 4.0}}, flagsA);
        Matrix mB = new Matrix(new double[][]{{1.0, 2.0, 3.0, 4.0}, {1.0, 2.0, 3.0, 4.0}, {1.0, 2.0, 3.0, 4.0}}, flagsB);
        Matrix m = mA.clone();
        if (m == mA) {
            Assert.fail((String)"'clone' must return a new instance");
        }
        if (m == mB) {
            Assert.fail((String)"'clone' must return a new instance");
        }
        if (!MatrixTest.equals(m, mB)) {
            Assert.fail((String)"'clone' failed");
        }
    }

    @Test
    public void empty() {
        this.empty(this.jFlags);
        this.empty(this.fFlags);
    }

    private void empty(Set<Address.Flags> flags) {
        Matrix mA = new Matrix(new double[][]{{1.0, 2.0, 3.0, 4.0}, {1.0, 2.0, 3.0, 4.0}, {1.0, 2.0, 3.0, 4.0}}, flags);
        if (mA.empty()) {
            Assert.fail((String)"'empty' failed");
        }
    }

    @Test
    public void fill() {
        this.fill(this.jFlags);
        this.fill(this.fFlags);
    }

    private void fill(Set<Address.Flags> flags) {
        Matrix mA = new Matrix(new double[][]{{2.0, 2.0, 2.0, 2.0}, {2.0, 2.0, 2.0, 2.0}, {2.0, 2.0, 2.0, 2.0}}, flags);
        Matrix m = new Matrix(3, 4).fill(2.0);
        if (!MatrixTest.equals(m, mA)) {
            Assert.fail((String)"'fill' failed");
        }
    }

    @Test
    public void addAssign() {
        this.addAssign(this.jFlags, this.jFlags);
        this.addAssign(this.jFlags, this.fFlags);
        this.addAssign(this.fFlags, this.jFlags);
        this.addAssign(this.fFlags, this.fFlags);
    }

    private void addAssign(Set<Address.Flags> flagsA, Set<Address.Flags> flagsB) {
        int offset;
        Matrix mA = new Matrix(new double[][]{{1.0, 2.0, 3.0, 4.0}, {1.0, 2.0, 3.0, 4.0}, {1.0, 2.0, 3.0, 4.0}, {1.0, 2.0, 3.0, 4.0}}, flagsA);
        Matrix mB = new Matrix(new double[][]{{4.0, 3.0, 2.0, 1.0}, {5.0, 4.0, 3.0, 2.0}, {6.0, 5.0, 4.0, 3.0}, {7.0, 6.0, 5.0, 4.0}}, flagsB);
        Matrix m = mA.addAssign(mB);
        if (m != mA) {
            Assert.fail((String)"addAssign must return <this>");
        }
        for (int row = offset = m.offset(); row < m.rows() + offset; ++row) {
            for (int col = offset; col < m.cols() + offset; ++col) {
                if (m.get(row, col) == (double)(row - offset + 5)) continue;
                Assert.fail((String)"addAssign failed");
            }
        }
    }

    @Test
    public void subAssign() {
        this.subAssign(this.jFlags, this.jFlags);
        this.subAssign(this.jFlags, this.fFlags);
        this.subAssign(this.fFlags, this.jFlags);
        this.subAssign(this.fFlags, this.fFlags);
    }

    private void subAssign(Set<Address.Flags> flagsA, Set<Address.Flags> flagsB) {
        int offset;
        Matrix mA = new Matrix(new double[][]{{1.0, 2.0, 3.0, 4.0}, {1.0, 2.0, 3.0, 4.0}, {1.0, 2.0, 3.0, 4.0}, {1.0, 2.0, 3.0, 4.0}}, flagsA);
        Matrix mB = new Matrix(new double[][]{{4.0, 5.0, 6.0, 7.0}, {5.0, 6.0, 7.0, 8.0}, {6.0, 7.0, 8.0, 9.0}, {7.0, 8.0, 9.0, 10.0}}, flagsB);
        Matrix m = mB.subAssign(mA);
        if (m != mB) {
            Assert.fail((String)"subAssign must return <this>");
        }
        for (int row = offset = m.offset(); row < m.rows() + offset; ++row) {
            for (int col = offset; col < m.cols() + offset; ++col) {
                if (m.get(row, col) == (double)(row - offset + 3)) continue;
                Assert.fail((String)"subAssign failed");
            }
        }
    }

    @Test
    public void mulAssign() {
        this.mulAssign(this.jFlags);
        this.mulAssign(this.fFlags);
    }

    private void mulAssign(Set<Address.Flags> flags) {
        int offset;
        Matrix mA = new Matrix(new double[][]{{1.0, 2.0, 3.0, 4.0}, {1.0, 2.0, 3.0, 4.0}, {1.0, 2.0, 3.0, 4.0}, {1.0, 2.0, 3.0, 4.0}}, flags);
        Matrix m = mA.mulAssign(2.5);
        if (m != mA) {
            Assert.fail((String)"mulAssign must return <this>");
        }
        for (int row = offset = m.offset(); row < m.rows() + offset; ++row) {
            for (int col = offset; col < m.cols() + offset; ++col) {
                if (Closeness.isClose(m.get(row, col), (double)(col - offset + 1) * 2.5)) continue;
                Assert.fail((String)"mulAssign failed");
            }
        }
    }

    @Test
    public void divAssign() {
        this.divAssign(this.jFlags);
        this.divAssign(this.fFlags);
    }

    private void divAssign(Set<Address.Flags> flags) {
        int offset;
        Matrix mA = new Matrix(new double[][]{{1.0, 2.0, 3.0, 4.0}, {1.0, 2.0, 3.0, 4.0}, {1.0, 2.0, 3.0, 4.0}, {1.0, 2.0, 3.0, 4.0}}, flags);
        Matrix m = mA.divAssign(2.5);
        if (m != mA) {
            Assert.fail((String)"divAssign must return <this>");
        }
        for (int row = offset = m.offset(); row < m.rows() + offset; ++row) {
            for (int col = offset; col < m.cols() + offset; ++col) {
                if (Closeness.isClose(m.get(row, col), (double)(col - offset + 1) / 2.5)) continue;
                Assert.fail((String)"divAssign failed");
            }
        }
    }

    @Test
    public void add() {
        this.add(this.jFlags, this.jFlags);
        this.add(this.jFlags, this.fFlags);
        this.add(this.fFlags, this.jFlags);
        this.add(this.fFlags, this.fFlags);
    }

    private void add(Set<Address.Flags> flagsA, Set<Address.Flags> flagsB) {
        Matrix mA = new Matrix(new double[][]{{1.0, 2.0, 3.0, 4.0}, {1.0, 2.0, 3.0, 4.0}, {1.0, 2.0, 3.0, 4.0}, {1.0, 2.0, 3.0, 4.0}}, flagsA);
        Matrix mB = new Matrix(new double[][]{{4.0, 3.0, 2.0, 1.0}, {5.0, 4.0, 3.0, 2.0}, {6.0, 5.0, 4.0, 3.0}, {7.0, 6.0, 5.0, 4.0}}, flagsB);
        Matrix m = mA.add(mB);
        if (m == mA) {
            Assert.fail((String)"'add' must return a new instance");
        }
        if (m.rows() != mA.rows() || m.cols() != mA.cols()) {
            Assert.fail((String)"'add' failed");
        }
        for (int row = 0; row < m.rows(); ++row) {
            for (int col = 0; col < m.cols(); ++col) {
                if (m.get(row, col) == (double)(row + 5)) continue;
                Assert.fail((String)"'add' failed");
            }
        }
    }

    @Test
    public void sub() {
        this.sub(this.jFlags, this.jFlags);
        this.sub(this.jFlags, this.fFlags);
        this.sub(this.fFlags, this.jFlags);
        this.sub(this.fFlags, this.fFlags);
    }

    private void sub(Set<Address.Flags> flagsA, Set<Address.Flags> flagsB) {
        Matrix mB = new Matrix(new double[][]{{4.0, 5.0, 6.0, 7.0}, {5.0, 6.0, 7.0, 8.0}, {6.0, 7.0, 8.0, 9.0}, {7.0, 8.0, 9.0, 10.0}}, flagsB);
        Matrix mA = new Matrix(new double[][]{{1.0, 2.0, 3.0, 4.0}, {1.0, 2.0, 3.0, 4.0}, {1.0, 2.0, 3.0, 4.0}, {1.0, 2.0, 3.0, 4.0}}, flagsA);
        Matrix m = mB.sub(mA);
        if (m == mB) {
            Assert.fail((String)"'sub' must return a new instance");
        }
        if (m.rows() != mB.rows() || m.cols() != mB.cols()) {
            Assert.fail((String)"'sub' failed");
        }
        for (int row = 0; row < m.rows(); ++row) {
            for (int col = 0; col < m.cols(); ++col) {
                if (m.get(row, col) == (double)(row + 3)) continue;
                Assert.fail((String)"'sub' failed");
            }
        }
    }

    @Test
    public void mulScalar() {
        this.mulScalar(this.jFlags);
        this.mulScalar(this.fFlags);
    }

    private void mulScalar(Set<Address.Flags> flags) {
        Matrix mA = new Matrix(new double[][]{{1.0, 2.0, 3.0, 4.0}, {1.0, 2.0, 3.0, 4.0}, {1.0, 2.0, 3.0, 4.0}, {1.0, 2.0, 3.0, 4.0}}, flags);
        Matrix m = mA.mul(2.5);
        if (m == mA) {
            Assert.fail((String)"'sub' must return a new instance");
        }
        if (m.rows() != mA.rows() || m.cols() != mA.cols()) {
            Assert.fail((String)"'sub' failed");
        }
        for (int row = 0; row < m.rows(); ++row) {
            for (int col = 0; col < m.cols(); ++col) {
                if (Closeness.isClose(m.get(row, col), (double)(col + 1) * 2.5)) continue;
                Assert.fail((String)"'mul' failed");
            }
        }
    }

    @Test
    public void mulArray() {
        this.mulArray(this.jFlags, this.jFlags);
        this.mulArray(this.jFlags, this.fFlags);
        this.mulArray(this.fFlags, this.jFlags);
        this.mulArray(this.fFlags, this.fFlags);
    }

    private void mulArray(Set<Address.Flags> flagsA, Set<Address.Flags> flagsB) {
        int offset;
        Matrix mA = new Matrix(new double[][]{{1.0, 2.0, 3.0, 4.0}, {1.0, 2.0, 3.0, 4.0}, {1.0, 2.0, 3.0, 4.0}, {1.0, 2.0, 3.0, 4.0}, {1.0, 2.0, 3.0, 4.0}}, flagsA);
        Array aD = new Array(new double[]{1.0, 1.0, 1.0, 1.0}, flagsB);
        Array a = mA.mul(aD);
        if (a.size() != mA.rows()) {
            Assert.fail((String)"'mul' failed");
        }
        for (int col = offset = a.flags().contains((Object)Address.Flags.FORTRAN) ? 1 : 0; col < a.cols() + offset; ++col) {
            if (a.get(col) == 10.0) continue;
            Assert.fail((String)"'mul' failed");
        }
    }

    @Test
    public void mulMatrix() {
        this.mulMatrix(this.jFlags, this.jFlags);
        this.mulMatrix(this.jFlags, this.fFlags);
        this.mulMatrix(this.fFlags, this.jFlags);
        this.mulMatrix(this.fFlags, this.fFlags);
    }

    private void mulMatrix(Set<Address.Flags> flagsA, Set<Address.Flags> flagsB) {
        Matrix mI = new Matrix(new double[][]{{1.0, 0.0, 0.0, 0.0}, {0.0, 1.0, 0.0, 0.0}, {0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 1.0}}, flagsA);
        Matrix mA = new Matrix(new double[][]{{4.0, 3.0, 2.0, 1.0}, {5.0, 4.0, 3.0, 2.0}, {6.0, 5.0, 4.0, 3.0}, {7.0, 6.0, 5.0, 4.0}}, flagsB);
        Matrix m = mI.mul(mA);
        if (m == mI) {
            Assert.fail((String)"'mul' must return a new instance");
        }
        if (m == mA) {
            Assert.fail((String)"'mul' must return a new instance");
        }
        if (!MatrixTest.equals(m, mA)) {
            Assert.fail((String)"'mul' failed");
        }
    }

    @Test
    public void divScalar() {
        this.divScalar(this.jFlags);
        this.divScalar(this.fFlags);
    }

    private void divScalar(Set<Address.Flags> flags) {
        Matrix mA = new Matrix(new double[][]{{1.0, 2.0, 3.0, 4.0}, {1.0, 2.0, 3.0, 4.0}, {1.0, 2.0, 3.0, 4.0}, {1.0, 2.0, 3.0, 4.0}});
        Matrix m = mA.div(2.5);
        if (m == mA) {
            Assert.fail((String)"'div' must return a new instance");
        }
        if (m.rows() != mA.rows() || m.cols() != mA.cols()) {
            Assert.fail((String)"'add' failed");
        }
        for (int row = 0; row < m.rows(); ++row) {
            for (int col = 0; col < m.cols(); ++col) {
                if (Closeness.isClose(m.get(row, col), (double)(col + 1) / 2.5)) continue;
                Assert.fail((String)"'div' failed");
            }
        }
    }

    @Test
    public void swap() {
        this.swap(this.jFlags, this.jFlags);
        this.swap(this.jFlags, this.fFlags);
        this.swap(this.fFlags, this.jFlags);
        this.swap(this.fFlags, this.fFlags);
    }

    private void swap(Set<Address.Flags> flagsA, Set<Address.Flags> flagsB) {
        Matrix mA = new Matrix(new double[][]{{1.0, 2.0, 3.0, 4.0}, {1.0, 2.0, 3.0, 4.0}, {1.0, 2.0, 3.0, 4.0}, {1.0, 2.0, 3.0, 4.0}}, flagsA);
        Matrix mB = new Matrix(new double[][]{{4.0, 3.0, 2.0, 1.0}, {5.0, 4.0, 3.0, 2.0}, {6.0, 5.0, 4.0, 3.0}, {7.0, 6.0, 5.0, 4.0}}, flagsB);
        Matrix mAclone = mA.clone();
        Matrix mBclone = mB.clone();
        mA.swap(mB);
        if (!MatrixTest.equals(mA, mBclone)) {
            Assert.fail((String)"'swap' failed");
        }
        if (!MatrixTest.equals(mB, mAclone)) {
            Assert.fail((String)"'swap' failed");
        }
    }

    @Test
    public void transpose() {
        this.transpose(this.jFlags, this.jFlags);
        this.transpose(this.jFlags, this.fFlags);
        this.transpose(this.fFlags, this.jFlags);
        this.transpose(this.fFlags, this.fFlags);
    }

    private void transpose(Set<Address.Flags> flagsA, Set<Address.Flags> flagsB) {
        Matrix mA = new Matrix(new double[][]{{1.0, 2.0, 3.0, 4.0}, {1.0, 2.0, 3.0, 4.0}, {1.0, 2.0, 3.0, 4.0}}, flagsA);
        Matrix mB = new Matrix(new double[][]{{1.0, 1.0, 1.0}, {2.0, 2.0, 2.0}, {3.0, 3.0, 3.0}, {4.0, 4.0, 4.0}}, flagsB);
        Matrix m = mA.transpose();
        if (m == mA) {
            Assert.fail((String)"'transpose' must return a new instance");
        }
        if (m == mB) {
            Assert.fail((String)"'transpose' must return a new instance");
        }
        if (!MatrixTest.equals(m, mB)) {
            Assert.fail((String)"'transpose' failed");
        }
    }

    @Test
    public void diagonal() {
        this.diagonal(this.jFlags, this.jFlags);
        this.diagonal(this.jFlags, this.fFlags);
        this.diagonal(this.fFlags, this.jFlags);
        this.diagonal(this.fFlags, this.fFlags);
    }

    private void diagonal(Set<Address.Flags> flagsA, Set<Address.Flags> flagsB) {
        Matrix mA = new Matrix(new double[][]{{1.0, 9.0, 9.0, 9.0}, {9.0, 2.0, 9.0, 9.0}, {9.0, 9.0, 3.0, 9.0}, {9.0, 9.0, 9.0, 4.0}}, flagsA);
        Array aA = new Array(new double[]{1.0, 2.0, 3.0, 4.0}, flagsB);
        if (!ArrayTest.equals(mA.diagonal(), aA)) {
            Assert.fail((String)"'diagonal' failed");
        }
    }

    @Test
    public void inverse() {
        this.inverse(this.jFlags);
        this.inverse(this.fFlags);
    }

    private void inverse(Set<Address.Flags> flags) {
        Matrix[] matrices;
        Matrix M1 = new Matrix(new double[][]{{1.0, 0.9, 0.7}, {0.9, 1.0, 0.4}, {0.7, 0.4, 1.0}}, flags);
        Matrix M2 = new Matrix(new double[][]{{1.0, 0.9, 0.7}, {0.9, 1.0, 0.3}, {0.7, 0.3, 1.0}}, flags);
        Identity I = new Identity(3, flags);
        Matrix M5 = new Matrix(new double[][]{{2.0, -1.0, 0.0, 0.0}, {-1.0, 2.0, -1.0, 0.0}, {0.0, -1.0, 2.0, -1.0}, {0.0, 0.0, -1.0, 2.0}}, flags);
        QL.info("Testing LU inverse calculation...");
        for (Matrix m : matrices = new Matrix[]{M1, M2, I, M5}) {
            this.inverse(m);
        }
    }

    private void inverse(Matrix m) {
        QL.info("Testing LU inverse calculation...");
        double tol = 1.0E-12;
        Matrix A = new Matrix(m);
        Matrix invA = A.inverse();
        Matrix I1 = invA.mul(A);
        Matrix I2 = A.mul(invA);
        Identity eins = new Identity(A.rows());
        double d = this.norm(I1.sub(eins));
        if (d > 1.0E-12) {
            Assert.fail((String)"inverse(A)*A does not recover unit matrix");
        }
        if (this.norm(I2.sub(eins)) > 1.0E-12) {
            Assert.fail((String)"A*inverse(A) does not recover unit matrix");
        }
    }

    @Test
    public void testRangeRow() {
        Matrix mA = new Matrix(new double[][]{{1.0, 0.9, 0.7}, {0.8, 2.0, 3.2}, {0.6, 3.1, 5.0}});
        this.testRangeRow(mA);
    }

    private void testRangeRow(Matrix mA) {
        Array array = mA.rangeRow(0, 0, 1);
        Assert.assertTrue((String)RangeRow_FAILED, (array.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)RangeRow_FAILED, (boolean)Closeness.isClose(array.accumulate(), 1.0));
        array = mA.rangeRow(0, 0, 2);
        Assert.assertTrue((String)RangeRow_FAILED, (array.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((String)RangeRow_FAILED, (boolean)Closeness.isClose(array.accumulate(), 1.9));
        array = mA.rangeRow(0, 0, 3);
        Assert.assertTrue((String)RangeRow_FAILED, (array.size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((String)RangeRow_FAILED, (boolean)Closeness.isClose(array.accumulate(), 2.6));
        array = mA.rangeRow(0, 1, 3);
        Assert.assertTrue((String)RangeRow_FAILED, (array.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((String)RangeRow_FAILED, (boolean)Closeness.isClose(array.accumulate(), 1.6));
        array = mA.rangeRow(0, 2, 3);
        Assert.assertTrue((String)RangeRow_FAILED, (array.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)RangeRow_FAILED, (boolean)Closeness.isClose(array.accumulate(), 0.7));
        array = mA.rangeRow(1, 0, 1);
        Assert.assertTrue((String)RangeRow_FAILED, (array.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)RangeRow_FAILED, (boolean)Closeness.isClose(array.accumulate(), 0.8));
        array = mA.rangeRow(1, 0, 2);
        Assert.assertTrue((String)RangeRow_FAILED, (array.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((String)RangeRow_FAILED, (boolean)Closeness.isClose(array.accumulate(), 2.8));
        array = mA.rangeRow(1, 0, 3);
        Assert.assertTrue((String)RangeRow_FAILED, (array.size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((String)RangeRow_FAILED, (boolean)Closeness.isClose(array.accumulate(), 6.0));
        array = mA.rangeRow(1, 1, 3);
        Assert.assertTrue((String)RangeRow_FAILED, (array.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((String)RangeRow_FAILED, (boolean)Closeness.isClose(array.accumulate(), 5.2));
        array = mA.rangeRow(1, 2, 3);
        Assert.assertTrue((String)RangeRow_FAILED, (array.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)RangeRow_FAILED, (boolean)Closeness.isClose(array.accumulate(), 3.2));
        array = mA.rangeRow(2, 0, 1);
        Assert.assertTrue((String)RangeRow_FAILED, (array.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)RangeRow_FAILED, (boolean)Closeness.isClose(array.accumulate(), 0.6));
        array = mA.rangeRow(2, 0, 2);
        Assert.assertTrue((String)RangeRow_FAILED, (array.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((String)RangeRow_FAILED, (boolean)Closeness.isClose(array.accumulate(), 3.7));
        array = mA.rangeRow(2, 0, 3);
        Assert.assertTrue((String)RangeRow_FAILED, (array.size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((String)RangeRow_FAILED, (boolean)Closeness.isClose(array.accumulate(), 8.7));
        array = mA.rangeRow(2, 1, 3);
        Assert.assertTrue((String)RangeRow_FAILED, (array.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((String)RangeRow_FAILED, (boolean)Closeness.isClose(array.accumulate(), 8.1));
        array = mA.rangeRow(2, 2, 3);
        Assert.assertTrue((String)RangeRow_FAILED, (array.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)RangeRow_FAILED, (boolean)Closeness.isClose(array.accumulate(), 5.0));
        try {
            array = mA.rangeRow(-1);
            Assert.fail((String)MISSING_EXCEPTION);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
        }
        catch (Exception e) {
            Assert.fail((String)WRONG_EXCEPTION);
        }
        try {
            array = mA.rangeRow(0, -1);
            Assert.fail((String)MISSING_EXCEPTION);
        }
        catch (ArrayIndexOutOfBoundsException e) {
        }
        catch (Exception e) {
            Assert.fail((String)WRONG_EXCEPTION);
        }
        try {
            array = mA.rangeRow(0, 0, -1);
            Assert.fail((String)MISSING_EXCEPTION);
        }
        catch (ArrayIndexOutOfBoundsException e) {
        }
        catch (Exception e) {
            Assert.fail((String)WRONG_EXCEPTION);
        }
        try {
            array = mA.rangeRow(0, -1, 0);
            Assert.fail((String)MISSING_EXCEPTION);
        }
        catch (ArrayIndexOutOfBoundsException e) {
        }
        catch (Exception e) {
            Assert.fail((String)WRONG_EXCEPTION);
        }
        try {
            array = mA.rangeRow(0, -1, -1);
            Assert.fail((String)MISSING_EXCEPTION);
        }
        catch (ArrayIndexOutOfBoundsException e) {
        }
        catch (Exception e) {
            Assert.fail((String)WRONG_EXCEPTION);
        }
        try {
            array = mA.rangeRow(0, 0, 4);
            Assert.fail((String)MISSING_EXCEPTION);
        }
        catch (ArrayIndexOutOfBoundsException e) {
        }
        catch (Exception e) {
            Assert.fail((String)WRONG_EXCEPTION);
        }
        try {
            array = mA.rangeRow(0, 4, 0);
            Assert.fail((String)MISSING_EXCEPTION);
        }
        catch (ArrayIndexOutOfBoundsException e) {
        }
        catch (Exception e) {
            Assert.fail((String)WRONG_EXCEPTION);
        }
        try {
            array = mA.rangeRow(0, 4, 4);
            Assert.fail((String)MISSING_EXCEPTION);
        }
        catch (ArrayIndexOutOfBoundsException e) {
        }
        catch (Exception e) {
            Assert.fail((String)WRONG_EXCEPTION);
        }
    }

    @Test
    public void testRangeCol() {
        Matrix mA = new Matrix(new double[][]{{1.0, 0.9, 0.7}, {0.8, 2.0, 3.2}, {0.6, 3.1, 5.0}});
        this.testRangeCol(mA);
    }

    private void testRangeCol(Matrix mA) {
        Array array = mA.rangeCol(0, 0, 1);
        Assert.assertTrue((String)RangeCol_FAILED, (array.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)RangeCol_FAILED, (boolean)Closeness.isClose(array.accumulate(), 1.0));
        array = mA.rangeCol(0, 0, 2);
        Assert.assertTrue((String)RangeCol_FAILED, (array.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((String)RangeCol_FAILED, (boolean)Closeness.isClose(array.accumulate(), 1.8));
        array = mA.rangeCol(0, 0, 3);
        Assert.assertTrue((String)RangeCol_FAILED, (array.size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((String)RangeCol_FAILED, (boolean)Closeness.isClose(array.accumulate(), 2.4));
        array = mA.rangeCol(0, 1, 3);
        Assert.assertTrue((String)RangeCol_FAILED, (array.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((String)RangeCol_FAILED, (boolean)Closeness.isClose(array.accumulate(), 1.4));
        array = mA.rangeCol(0, 2, 3);
        Assert.assertTrue((String)RangeCol_FAILED, (array.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)RangeCol_FAILED, (boolean)Closeness.isClose(array.accumulate(), 0.6));
        array = mA.rangeCol(1, 0, 1);
        Assert.assertTrue((String)RangeCol_FAILED, (array.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)RangeCol_FAILED, (boolean)Closeness.isClose(array.accumulate(), 0.9));
        array = mA.rangeCol(1, 0, 2);
        Assert.assertTrue((String)RangeCol_FAILED, (array.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((String)RangeCol_FAILED, (boolean)Closeness.isClose(array.accumulate(), 2.9));
        array = mA.rangeCol(1, 0, 3);
        Assert.assertTrue((String)RangeCol_FAILED, (array.size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((String)RangeCol_FAILED, (boolean)Closeness.isClose(array.accumulate(), 6.0));
        array = mA.rangeCol(1, 1, 3);
        Assert.assertTrue((String)RangeCol_FAILED, (array.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((String)RangeCol_FAILED, (boolean)Closeness.isClose(array.accumulate(), 5.1));
        array = mA.rangeCol(1, 2, 3);
        Assert.assertTrue((String)RangeCol_FAILED, (array.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)RangeCol_FAILED, (boolean)Closeness.isClose(array.accumulate(), 3.1));
        array = mA.rangeCol(2, 0, 1);
        Assert.assertTrue((String)RangeCol_FAILED, (array.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)RangeCol_FAILED, (boolean)Closeness.isClose(array.accumulate(), 0.7));
        array = mA.rangeCol(2, 0, 2);
        Assert.assertTrue((String)RangeCol_FAILED, (array.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((String)RangeCol_FAILED, (boolean)Closeness.isClose(array.accumulate(), 3.9));
        array = mA.rangeCol(2, 0, 3);
        Assert.assertTrue((String)RangeCol_FAILED, (array.size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((String)RangeCol_FAILED, (boolean)Closeness.isClose(array.accumulate(), 8.9));
        array = mA.rangeCol(2, 1, 3);
        Assert.assertTrue((String)RangeCol_FAILED, (array.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((String)RangeCol_FAILED, (boolean)Closeness.isClose(array.accumulate(), 8.2));
        array = mA.rangeCol(2, 2, 3);
        Assert.assertTrue((String)RangeCol_FAILED, (array.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)RangeCol_FAILED, (boolean)Closeness.isClose(array.accumulate(), 5.0));
        try {
            array = mA.rangeCol(-1);
            Assert.fail((String)MISSING_EXCEPTION);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
        }
        catch (Exception e) {
            Assert.fail((String)WRONG_EXCEPTION);
        }
        try {
            array = mA.rangeCol(0, -1);
            Assert.fail((String)MISSING_EXCEPTION);
        }
        catch (ArrayIndexOutOfBoundsException e) {
        }
        catch (Exception e) {
            Assert.fail((String)WRONG_EXCEPTION);
        }
        try {
            array = mA.rangeCol(0, 0, -1);
            Assert.fail((String)MISSING_EXCEPTION);
        }
        catch (ArrayIndexOutOfBoundsException e) {
        }
        catch (Exception e) {
            Assert.fail((String)WRONG_EXCEPTION);
        }
        try {
            array = mA.rangeCol(0, -1, 0);
            Assert.fail((String)MISSING_EXCEPTION);
        }
        catch (ArrayIndexOutOfBoundsException e) {
        }
        catch (Exception e) {
            Assert.fail((String)WRONG_EXCEPTION);
        }
        try {
            array = mA.rangeCol(0, -1, -1);
            Assert.fail((String)MISSING_EXCEPTION);
        }
        catch (ArrayIndexOutOfBoundsException e) {
        }
        catch (Exception e) {
            Assert.fail((String)WRONG_EXCEPTION);
        }
        try {
            array = mA.rangeCol(0, 0, 4);
            Assert.fail((String)MISSING_EXCEPTION);
        }
        catch (ArrayIndexOutOfBoundsException e) {
        }
        catch (Exception e) {
            Assert.fail((String)WRONG_EXCEPTION);
        }
        try {
            array = mA.rangeCol(0, 4, 0);
            Assert.fail((String)MISSING_EXCEPTION);
        }
        catch (ArrayIndexOutOfBoundsException e) {
        }
        catch (Exception e) {
            Assert.fail((String)WRONG_EXCEPTION);
        }
        try {
            array = mA.rangeCol(0, 4, 4);
            Assert.fail((String)MISSING_EXCEPTION);
        }
        catch (ArrayIndexOutOfBoundsException e) {
        }
        catch (Exception e) {
            Assert.fail((String)WRONG_EXCEPTION);
        }
    }

    @Test
    public void testRange() {
        Matrix mA = new Matrix(new double[][]{{-1.0, 1.1, 1.1, 1.1, -9.0}, {-1.0, 1.0, 0.9, 0.7, -9.0}, {-2.5, 0.8, 2.0, 3.2, -6.5}, {-4.0, 0.6, 3.1, 5.0, -4.0}, {-4.0, 9.9, 9.9, 9.9, -4.0}});
        Matrix mB = new Matrix(new double[][]{{-1.0, 1.1, 1.1, 1.1, -9.0}, {-1.0, 5.0, 3.1, 0.6, -9.0}, {-2.5, 3.2, 2.0, 0.8, -6.5}, {-4.0, 0.7, 0.9, 1.0, -4.0}, {-4.0, 9.9, 9.9, 9.9, -4.0}});
        Matrix matrix = mA.range(1, 4, 1, 4);
        this.testRangeRow(matrix);
        try {
            matrix = mA.range(-1, 3, 1, 3);
            Assert.fail((String)MISSING_EXCEPTION);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
        }
        catch (Exception e) {
            Assert.fail((String)WRONG_EXCEPTION);
        }
        try {
            matrix = mA.range(1, -1, 1, 3);
            Assert.fail((String)MISSING_EXCEPTION);
        }
        catch (ArrayIndexOutOfBoundsException e) {
        }
        catch (Exception e) {
            Assert.fail((String)WRONG_EXCEPTION);
        }
        try {
            matrix = mA.range(1, 3, -1, 3);
            Assert.fail((String)MISSING_EXCEPTION);
        }
        catch (ArrayIndexOutOfBoundsException e) {
        }
        catch (Exception e) {
            Assert.fail((String)WRONG_EXCEPTION);
        }
        try {
            matrix = mA.range(1, 3, 1, -1);
            Assert.fail((String)MISSING_EXCEPTION);
        }
        catch (ArrayIndexOutOfBoundsException e) {
        }
        catch (Exception e) {
            Assert.fail((String)WRONG_EXCEPTION);
        }
        try {
            matrix = mA.range(1, 6, 1, 4);
            Assert.fail((String)MISSING_EXCEPTION);
        }
        catch (ArrayIndexOutOfBoundsException e) {
        }
        catch (Exception e) {
            Assert.fail((String)WRONG_EXCEPTION);
        }
        try {
            matrix = mA.range(1, 4, 4, 1);
            Assert.fail((String)MISSING_EXCEPTION);
        }
        catch (ArrayIndexOutOfBoundsException e) {
        }
        catch (Exception e) {
            Assert.fail((String)WRONG_EXCEPTION);
        }
        try {
            matrix = mA.range(4, 1, 1, 4);
            Assert.fail((String)MISSING_EXCEPTION);
        }
        catch (ArrayIndexOutOfBoundsException e) {
        }
        catch (Exception e) {
            Assert.fail((String)WRONG_EXCEPTION);
        }
    }

    @Test
    public void testEigenvectors() {
        this.testEigenvectors(this.jFlags);
        this.testEigenvectors(this.fFlags);
    }

    private void testEigenvectors(Set<Address.Flags> flags) {
        Matrix[] testMatrices;
        QL.info("Testing eigenvalues and eigenvectors calculation...");
        Matrix M1 = new Matrix(new double[][]{{1.0, 0.9, 0.7}, {0.9, 1.0, 0.4}, {0.7, 0.4, 1.0}}, flags);
        Matrix M2 = new Matrix(new double[][]{{1.0, 0.9, 0.7}, {0.9, 1.0, 0.3}, {0.7, 0.3, 1.0}}, flags);
        for (Matrix M : testMatrices = new Matrix[]{M1, M2}) {
            Identity ID;
            int offset;
            SymmetricSchurDecomposition schur = M.schur();
            Array eigenValues = schur.eigenvalues();
            Matrix eigenVectors = schur.eigenvectors();
            double minHolder = Double.MAX_VALUE;
            int N = M.cols();
            for (int i = offset = M.offset(); i < N + offset; ++i) {
                Array b;
                Array v = new Array(N, M.flags());
                for (int j = offset; j < N + offset; ++j) {
                    v.set(j, eigenVectors.get(j, i));
                }
                Array a = M.mul(v);
                double tol = this.norm(a.sub(b = v.mul(eigenValues.get(i))));
                if (!(tol > 1.0E-15)) continue;
                Assert.fail((String)"Eigenvector definition not satisfied");
            }
            Matrix m = eigenVectors.mul(eigenVectors.transpose());
            double tol = this.norm(m.sub(ID = new Identity(N)));
            if (!(tol > 1.0E-15)) continue;
            Assert.fail((String)"Eigenvector not normalized");
        }
    }

    @Test
    public void testQRDecomposition() {
        this.testQRDecomposition(this.jFlags);
        this.testQRDecomposition(this.fFlags);
    }

    private void testQRDecomposition(Set<Address.Flags> flags) {
        Matrix[] testMatrices;
        Matrix M1 = new Matrix(new double[][]{{1.0, 0.9, 0.7}, {0.9, 1.0, 0.4}, {0.7, 0.4, 1.0}}, flags);
        Matrix M2 = new Matrix(new double[][]{{1.0, 0.9, 0.7}, {0.9, 1.0, 0.3}, {0.7, 0.3, 1.0}}, flags);
        Identity I = new Identity(3, flags);
        Matrix M3 = new Matrix(new double[][]{{1.0, 2.0, 3.0, 4.0}, {2.0, 0.0, 2.0, 1.0}, {0.0, 1.0, 0.0, 0.0}}, flags);
        Matrix M4 = new Matrix(new double[][]{{1.0, 2.0, 400.0}, {2.0, 0.0, 1.0}, {30.0, 2.0, 0.0}, {2.0, 0.0, 1.05}}, flags);
        Matrix M5 = new Matrix(new double[][]{{2.0, -1.0, 0.0, 0.0}, {-1.0, 2.0, -1.0, 0.0}, {0.0, -1.0, 2.0, -1.0}, {0.0, 0.0, -1.0, 2.0}}, flags);
        QL.info("Testing QR decomposition...");
        double tolerance = 1.0E-12;
        for (Matrix A : testMatrices = new Matrix[]{M1, M2, I, M3, M3.transpose(), M4, M4.transpose(), M5}) {
            Matrix mul2;
            QRDecomposition qr = new Matrix(A).qr(true);
            Matrix R = qr.R();
            Matrix Q = qr.Q();
            Matrix P = qr.P();
            Matrix mul1 = Q.mul(R);
            double norm = this.norm(mul1.sub(mul2 = A.mul(P)));
            if (norm > 1.0E-12) {
                Assert.fail((String)("Q*R (pivot=true) does not match matrix A*P :: norm = " + String.valueOf(norm)));
            }
            qr = new Matrix(A).qr();
            R = qr.R();
            Q = qr.Q();
            mul1 = Q.mul(R);
            norm = this.norm(mul1.sub(A));
            if (!(norm > 1.0E-12)) continue;
            Assert.fail((String)("Q*R (pivot=false) does not match matrix A :: norm = " + String.valueOf(norm)));
        }
    }

    private double norm(Array v) {
        double result = Math.sqrt(v.dotProduct(v));
        return result;
    }

    private double norm(Matrix m) {
        double sum = 0.0;
        for (int i = 0; i < m.rows(); ++i) {
            for (int j = 0; j < m.cols(); ++j) {
                sum += m.get(i, j) * m.get(i, j);
            }
        }
        double result = Math.sqrt(sum);
        return result;
    }
}

