/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.testsuite.instruments;

import org.jquantlib.QL;
import org.jquantlib.instruments.Stock;
import org.jquantlib.quotes.Quote;
import org.jquantlib.quotes.RelinkableHandle;
import org.jquantlib.quotes.SimpleQuote;
import org.jquantlib.testsuite.util.Flag;
import org.junit.Assert;
import org.junit.Test;

public class StocksTest {
    public StocksTest() {
        QL.info("::::: " + this.getClass().getSimpleName() + " :::::");
    }

    @Test
    public void testStocks() {
        QL.info("Testing price valuation of Stocks...");
        double iniPrice = 3.56;
        double newPrice = 3.6361840000000005;
        RelinkableHandle<Quote> h = new RelinkableHandle<Quote>(new SimpleQuote(3.56));
        Stock s = new Stock(h);
        Flag priceChange = new Flag();
        s.addObserver(priceChange);
        if (3.56 != s.NPV()) {
            Assert.fail((String)"stock quote valuation failed");
        }
        h.linkTo(new SimpleQuote(3.6361840000000005));
        if (!priceChange.isUp()) {
            Assert.fail((String)"Observer was not notified of instrument change");
        }
        if (3.6361840000000005 != s.NPV()) {
            Assert.fail((String)"stock quote havent changed value");
        }
    }
}

