/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.testsuite.instruments;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jquantlib.QL;
import org.jquantlib.Settings;
import org.jquantlib.daycounters.Actual360;
import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.exercise.EuropeanExercise;
import org.jquantlib.exercise.Exercise;
import org.jquantlib.instruments.AverageType;
import org.jquantlib.instruments.ContinuousAveragingAsianOption;
import org.jquantlib.instruments.DiscreteAveragingAsianOption;
import org.jquantlib.instruments.Option;
import org.jquantlib.instruments.PlainVanillaPayoff;
import org.jquantlib.instruments.StrikedTypePayoff;
import org.jquantlib.pricingengines.asian.AnalyticContinuousGeometricAveragePriceAsianEngine;
import org.jquantlib.pricingengines.asian.AnalyticDiscreteGeometricAveragePriceAsianEngine;
import org.jquantlib.processes.BlackScholesMertonProcess;
import org.jquantlib.quotes.Handle;
import org.jquantlib.quotes.SimpleQuote;
import org.jquantlib.termstructures.BlackVolTermStructure;
import org.jquantlib.termstructures.YieldTermStructure;
import org.jquantlib.testsuite.util.Utilities;
import org.jquantlib.time.Date;
import org.jquantlib.time.Period;
import org.jquantlib.time.TimeUnit;
import org.junit.Assert;
import org.junit.Test;

public class AsianOptionTest {
    public AsianOptionTest() {
        QL.info("::::: " + this.getClass().getSimpleName() + " :::::");
    }

    @Test
    public void testAnalyticDiscreteGeometricAverage() {
        QL.info("Testing analytic discrete geometric average-price Asians...");
        Date today = new Settings().evaluationDate();
        Actual360 dc = new Actual360();
        QL.info("Today: " + today);
        SimpleQuote spot = new SimpleQuote(100.0);
        SimpleQuote qRate = new SimpleQuote(0.03);
        YieldTermStructure qTS = Utilities.flatRate(today, qRate.value(), (DayCounter)dc);
        SimpleQuote rRate = new SimpleQuote(0.06);
        YieldTermStructure rTS = Utilities.flatRate(today, rRate.value(), (DayCounter)dc);
        SimpleQuote vol = new SimpleQuote(0.2);
        BlackVolTermStructure volTS = Utilities.flatVol(today, vol.value(), (DayCounter)dc);
        BlackScholesMertonProcess stochProcess = new BlackScholesMertonProcess(new Handle<SimpleQuote>(spot), new Handle<YieldTermStructure>(qTS), new Handle<YieldTermStructure>(rTS), new Handle<BlackVolTermStructure>(volTS));
        AnalyticDiscreteGeometricAveragePriceAsianEngine engine = new AnalyticDiscreteGeometricAveragePriceAsianEngine(stochProcess);
        AverageType averageType = AverageType.Geometric;
        double runningAccumulator = 1.0;
        boolean pastFixings = false;
        int futureFixings = 10;
        Option.Type type = Option.Type.Call;
        double strike = 100.0;
        PlainVanillaPayoff payoff = new PlainVanillaPayoff(type, 100.0);
        Date exerciseDate = today.clone().addAssign(360);
        EuropeanExercise exercise = new EuropeanExercise(exerciseDate);
        QL.info("Exercise: " + exerciseDate);
        QL.info("Df: " + rTS.discount(exerciseDate));
        QL.info("DivDf: " + qTS.discount(exerciseDate));
        ArrayList<Date> fixingDates = new ArrayList<Date>(10);
        int dt = 36;
        fixingDates.add(today.clone().addAssign(36));
        for (int j = 1; j < 10; ++j) {
            Date prevDate = (Date)fixingDates.get(j - 1);
            fixingDates.add(prevDate.clone().addAssign(36));
        }
        QL.info("Average Dates:\n");
        for (Date d : fixingDates) {
            QL.info(d.toString());
        }
        DiscreteAveragingAsianOption option = new DiscreteAveragingAsianOption(averageType, 1.0, 0, fixingDates, payoff, exercise);
        option.setPricingEngine(engine);
        double calculated = option.NPV();
        double expected = 5.3425606635;
        double tolerance = 1.0E-10;
        if (Math.abs(calculated - 5.3425606635) > 1.0E-10) {
            this.reportFailure("value", averageType, 1.0, 0, fixingDates, payoff, exercise, spot.value(), qRate.value(), rRate.value(), today, vol.value(), 5.3425606635, calculated, 1.0E-10);
        }
    }

    @Test
    public void testAnalyticDiscreteGeometricAveragePriceGreeks() {
        QL.info("Testing discrete-averaging geometric Asian greeks...");
        HashMap<String, Double> tolerance = new HashMap<String, Double>();
        tolerance.put("delta", 1.0E-5);
        tolerance.put("gamma", 1.0E-5);
        tolerance.put("theta", 1.0E-5);
        tolerance.put("rho", 1.0E-5);
        tolerance.put("divRho", 1.0E-5);
        tolerance.put("vega", 1.0E-5);
        Option.Type[] types = new Option.Type[]{Option.Type.Call, Option.Type.Put};
        double[] underlyings = new double[]{100.0};
        double[] strikes = new double[]{90.0, 100.0, 110.0};
        double[] qRates = new double[]{0.04, 0.05, 0.06};
        double[] rRates = new double[]{0.01, 0.05, 0.15};
        int[] lengths = new int[]{1, 2};
        double[] vols = new double[]{0.11, 0.5, 1.2};
        Actual360 dc = new Actual360();
        SimpleQuote spot = new SimpleQuote(0.0);
        SimpleQuote qRate = new SimpleQuote(0.0);
        YieldTermStructure qTS = Utilities.flatRate(qRate, (DayCounter)dc);
        SimpleQuote rRate = new SimpleQuote(0.0);
        YieldTermStructure rTS = Utilities.flatRate(rRate, (DayCounter)dc);
        SimpleQuote vol = new SimpleQuote(0.0);
        BlackVolTermStructure volTS = Utilities.flatVol(vol, (DayCounter)dc);
        BlackScholesMertonProcess process = new BlackScholesMertonProcess(new Handle<SimpleQuote>(spot), new Handle<YieldTermStructure>(qTS), new Handle<YieldTermStructure>(rTS), new Handle<BlackVolTermStructure>(volTS));
        Date today = new Settings().evaluationDate();
        for (Option.Type type : types) {
            for (double strike : strikes) {
                for (int length : lengths) {
                    Date exerciseDate = new Date(today.dayOfMonth(), today.month(), today.year() + length);
                    EuropeanExercise maturity = new EuropeanExercise(exerciseDate);
                    PlainVanillaPayoff payoff = new PlainVanillaPayoff(type, strike);
                    double runningAverage = 120.0;
                    boolean pastFixings = true;
                    ArrayList<Date> fixingDates = new ArrayList<Date>();
                    Date d = today.clone();
                    Period THREEMONTH = new Period(3, TimeUnit.Months);
                    d.addAssign(new Period(3, TimeUnit.Months));
                    d.addAssign(THREEMONTH);
                    while (d.le(maturity.lastDate())) {
                        fixingDates.add(d.clone());
                        d.addAssign(THREEMONTH);
                    }
                    AnalyticDiscreteGeometricAveragePriceAsianEngine engine = new AnalyticDiscreteGeometricAveragePriceAsianEngine(process);
                    DiscreteAveragingAsianOption option = new DiscreteAveragingAsianOption(AverageType.Geometric, 120.0, 1, fixingDates, payoff, maturity);
                    option.setPricingEngine(engine);
                    for (double u : underlyings) {
                        for (double q : qRates) {
                            for (double r : rRates) {
                                for (double v : vols) {
                                    spot.setValue(u);
                                    qRate.setValue(q);
                                    rRate.setValue(r);
                                    vol.setValue(v);
                                    double value = option.NPV();
                                    HashMap<String, Double> calculated = new HashMap<String, Double>();
                                    calculated.put("delta", option.delta());
                                    calculated.put("gamma", option.gamma());
                                    calculated.put("theta", option.theta());
                                    calculated.put("rho", option.rho());
                                    calculated.put("divRho", option.dividendRho());
                                    calculated.put("vega", option.vega());
                                    HashMap<String, Double> expected = new HashMap<String, Double>();
                                    if (!(value > spot.value() * 1.0E-5)) continue;
                                    double du = u * 1.0E-4;
                                    spot.setValue(u + du);
                                    double value_p = option.NPV();
                                    double delta_p = option.delta();
                                    spot.setValue(u - du);
                                    double value_m = option.NPV();
                                    double delta_m = option.delta();
                                    spot.setValue(u);
                                    expected.put("delta", (value_p - value_m) / (2.0 * du));
                                    expected.put("gamma", (delta_p - delta_m) / (2.0 * du));
                                    double dr = r * 1.0E-4;
                                    rRate.setValue(r + dr);
                                    value_p = option.NPV();
                                    rRate.setValue(r - dr);
                                    value_m = option.NPV();
                                    rRate.setValue(r);
                                    expected.put("rho", (value_p - value_m) / (2.0 * dr));
                                    double dq = q * 1.0E-4;
                                    qRate.setValue(q + dq);
                                    value_p = option.NPV();
                                    qRate.setValue(q - dq);
                                    value_m = option.NPV();
                                    qRate.setValue(q);
                                    expected.put("divRho", (value_p - value_m) / (2.0 * dq));
                                    double dv = v * 1.0E-4;
                                    vol.setValue(v + dv);
                                    value_p = option.NPV();
                                    vol.setValue(v - dv);
                                    value_m = option.NPV();
                                    vol.setValue(v);
                                    expected.put("vega", (value_p - value_m) / (2.0 * dv));
                                    Date yesterday = today.sub(1);
                                    Date tomorrow = today.add(1);
                                    double dT = dc.yearFraction(yesterday, tomorrow);
                                    new Settings().setEvaluationDate(yesterday);
                                    value_m = option.NPV();
                                    new Settings().setEvaluationDate(tomorrow);
                                    value_p = option.NPV();
                                    expected.put("theta", (value_p - value_m) / dT);
                                    new Settings().setEvaluationDate(today);
                                    for (Map.Entry greek : calculated.entrySet()) {
                                        double expct = (Double)expected.get(greek.getKey());
                                        double calcl = (Double)calculated.get(greek.getKey());
                                        double tol = (Double)tolerance.get(greek.getKey());
                                        double error = Utilities.relativeError(expct, calcl, u);
                                        if (!(error > tol)) continue;
                                        this.reportFailure((String)greek.getKey(), AverageType.Geometric, 120.0, 1, new ArrayList<Date>(), payoff, maturity, u, q, r, today, v, expct, calcl, tol);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Test
    public void testAnalyticContinuousGeometricAveragePrice() {
        QL.info("Testing analytic continuous geometric average-price Asians...");
        Actual360 dc = new Actual360();
        Date today = new Settings().evaluationDate();
        QL.info("Today: " + today);
        SimpleQuote spot = new SimpleQuote(80.0);
        SimpleQuote qRate = new SimpleQuote(-0.03);
        YieldTermStructure qTS = Utilities.flatRate(today, qRate, (DayCounter)dc);
        SimpleQuote rRate = new SimpleQuote(0.05);
        YieldTermStructure rTS = Utilities.flatRate(today, rRate, (DayCounter)dc);
        SimpleQuote vol = new SimpleQuote(0.2);
        BlackVolTermStructure volTS = Utilities.flatVol(today, vol, (DayCounter)dc);
        BlackScholesMertonProcess stochProcess = new BlackScholesMertonProcess(new Handle<SimpleQuote>(spot), new Handle<YieldTermStructure>(qTS), new Handle<YieldTermStructure>(rTS), new Handle<BlackVolTermStructure>(volTS));
        AnalyticContinuousGeometricAveragePriceAsianEngine engine = new AnalyticContinuousGeometricAveragePriceAsianEngine(stochProcess);
        AverageType averageType = AverageType.Geometric;
        Option.Type type = Option.Type.Put;
        double strike = 85.0;
        Date exerciseDate = today.clone().addAssign(90);
        int pastFixings = Integer.MAX_VALUE;
        double runningAccumulator = Double.NaN;
        PlainVanillaPayoff payoff = new PlainVanillaPayoff(type, 85.0);
        EuropeanExercise exercise = new EuropeanExercise(exerciseDate);
        ContinuousAveragingAsianOption option = new ContinuousAveragingAsianOption(averageType, payoff, exercise);
        option.setPricingEngine(engine);
        double calculated = option.NPV();
        double expected = 4.6922;
        double tolerance = 1.0E-4;
        if (Math.abs(calculated - 4.6922) > tolerance) {
            this.reportFailure("value", averageType, runningAccumulator, pastFixings, new ArrayList<Date>(), payoff, exercise, spot.value(), qRate.value(), rRate.value(), today, vol.value(), 4.6922, calculated, tolerance);
        }
        runningAccumulator = 1.0;
        pastFixings = 0;
        ArrayList<Date> fixingDates = new ArrayList<Date>(91);
        for (int i = 0; i < 91; ++i) {
            fixingDates.add(today.clone().addAssign(i));
        }
        AnalyticDiscreteGeometricAveragePriceAsianEngine engine2 = new AnalyticDiscreteGeometricAveragePriceAsianEngine(stochProcess);
        DiscreteAveragingAsianOption option2 = new DiscreteAveragingAsianOption(averageType, runningAccumulator, pastFixings, fixingDates, payoff, exercise);
        option2.setPricingEngine(engine2);
        calculated = option2.NPV();
        tolerance = 0.003;
        if (Math.abs(calculated - 4.6922) > tolerance) {
            this.reportFailure("value", averageType, runningAccumulator, pastFixings, fixingDates, payoff, exercise, spot.value(), qRate.value(), rRate.value(), today, vol.value(), 4.6922, calculated, tolerance);
        }
    }

    @Test
    public void testAnalyticContinuousGeometricAveragePriceGreeks() {
        QL.info("Testing analytic continuous geometric average-price Asian greeks...");
        HashMap<String, Double> tolerance = new HashMap<String, Double>();
        tolerance.put("delta", 1.0E-5);
        tolerance.put("gamma", 1.0E-5);
        tolerance.put("theta", 1.0E-5);
        tolerance.put("rho", 1.0E-5);
        tolerance.put("divRho", 1.0E-5);
        tolerance.put("vega", 1.0E-5);
        Option.Type[] types = new Option.Type[]{Option.Type.Call, Option.Type.Put};
        double[] underlyings = new double[]{100.0};
        double[] strikes = new double[]{90.0, 100.0, 110.0};
        double[] qRates = new double[]{0.04, 0.05, 0.06};
        double[] rRates = new double[]{0.01, 0.05, 0.15};
        int[] lengths = new int[]{1, 2};
        double[] vols = new double[]{0.11, 0.5, 1.2};
        Actual360 dc = new Actual360();
        SimpleQuote spot = new SimpleQuote(0.0);
        SimpleQuote qRate = new SimpleQuote(0.0);
        YieldTermStructure qTS = Utilities.flatRate(qRate, (DayCounter)dc);
        SimpleQuote rRate = new SimpleQuote(0.0);
        YieldTermStructure rTS = Utilities.flatRate(rRate, (DayCounter)dc);
        SimpleQuote vol = new SimpleQuote(0.0);
        BlackVolTermStructure volTS = Utilities.flatVol(vol, (DayCounter)dc);
        BlackScholesMertonProcess stochProcess = new BlackScholesMertonProcess(new Handle<SimpleQuote>(spot), new Handle<YieldTermStructure>(qTS), new Handle<YieldTermStructure>(rTS), new Handle<BlackVolTermStructure>(volTS));
        AnalyticContinuousGeometricAveragePriceAsianEngine engine = new AnalyticContinuousGeometricAveragePriceAsianEngine(stochProcess);
        Date today = new Settings().evaluationDate();
        for (Option.Type type : types) {
            for (double strike : strikes) {
                for (int length : lengths) {
                    Date exerciseDate = new Date(today.dayOfMonth(), today.month(), today.year() + length);
                    EuropeanExercise maturity = new EuropeanExercise(exerciseDate);
                    PlainVanillaPayoff payoff = new PlainVanillaPayoff(type, strike);
                    ContinuousAveragingAsianOption option = new ContinuousAveragingAsianOption(AverageType.Geometric, payoff, maturity);
                    option.setPricingEngine(engine);
                    int pastFixings = Integer.MAX_VALUE;
                    double runningAverage = Double.NaN;
                    for (double u : underlyings) {
                        for (double q : qRates) {
                            for (double r : rRates) {
                                for (double v : vols) {
                                    spot.setValue(u);
                                    qRate.setValue(q);
                                    rRate.setValue(r);
                                    vol.setValue(v);
                                    double value = option.NPV();
                                    HashMap<String, Double> calculated = new HashMap<String, Double>();
                                    calculated.put("delta", option.delta());
                                    calculated.put("gamma", option.gamma());
                                    calculated.put("theta", option.theta());
                                    calculated.put("rho", option.rho());
                                    calculated.put("divRho", option.dividendRho());
                                    calculated.put("vega", option.vega());
                                    HashMap<String, Double> expected = new HashMap<String, Double>();
                                    if (!(value > spot.value() * 1.0E-5)) continue;
                                    double du = u * 1.0E-4;
                                    spot.setValue(u + du);
                                    double value_p = option.NPV();
                                    double delta_p = option.delta();
                                    spot.setValue(u - du);
                                    double value_m = option.NPV();
                                    double delta_m = option.delta();
                                    spot.setValue(u);
                                    expected.put("delta", (value_p - value_m) / (2.0 * du));
                                    expected.put("gamma", (delta_p - delta_m) / (2.0 * du));
                                    double dr = r * 1.0E-4;
                                    rRate.setValue(r + dr);
                                    value_p = option.NPV();
                                    rRate.setValue(r - dr);
                                    value_m = option.NPV();
                                    rRate.setValue(r);
                                    expected.put("rho", (value_p - value_m) / (2.0 * dr));
                                    double dq = q * 1.0E-4;
                                    qRate.setValue(q + dq);
                                    value_p = option.NPV();
                                    qRate.setValue(q - dq);
                                    value_m = option.NPV();
                                    qRate.setValue(q);
                                    expected.put("divRho", (value_p - value_m) / (2.0 * dq));
                                    double dv = v * 1.0E-4;
                                    vol.setValue(v + dv);
                                    value_p = option.NPV();
                                    vol.setValue(v - dv);
                                    value_m = option.NPV();
                                    vol.setValue(v);
                                    expected.put("vega", (value_p - value_m) / (2.0 * dv));
                                    Date yesterday = today.sub(1);
                                    Date tomorrow = today.add(1);
                                    double dT = dc.yearFraction(yesterday, tomorrow);
                                    new Settings().setEvaluationDate(yesterday);
                                    value_m = option.NPV();
                                    new Settings().setEvaluationDate(tomorrow);
                                    value_p = option.NPV();
                                    expected.put("theta", (value_p - value_m) / dT);
                                    new Settings().setEvaluationDate(today);
                                    for (Map.Entry greek : calculated.entrySet()) {
                                        double expct = (Double)expected.get(greek.getKey());
                                        double calcl = (Double)calculated.get(greek.getKey());
                                        double tol = (Double)tolerance.get(greek.getKey());
                                        double error = Utilities.relativeError(expct, calcl, u);
                                        if (!(error > tol)) continue;
                                        this.reportFailure((String)greek.getKey(), AverageType.Geometric, Double.NaN, Integer.MAX_VALUE, new ArrayList<Date>(), payoff, maturity, u, q, r, today, v, expct, calcl, tol);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    private void reportFailure(String greekName, AverageType averageType, double runningAccumulator, int pastFixings, List<Date> fixingDates, StrikedTypePayoff payoff, Exercise exercise, double s, double q, double r, Date today, double v, double expected, double calculated, double tolerance) {
        Assert.fail((String)(exercise + " Asian option with " + (Object)((Object)averageType) + " and " + payoff + " payoff:\n" + "    running variable: " + runningAccumulator + "\n" + "    past fixings:     " + pastFixings + "\n" + "    future fixings:   " + fixingDates.size() + "\n" + "    underlying value: " + s + "\n" + "    strike:           " + payoff.strike() + "\n" + "    dividend yield:   " + q + "\n" + "    risk-free rate:   " + r + "\n" + "    reference date:   " + today + "\n" + "    maturity:         " + exercise.lastDate() + "\n" + "    volatility:       " + v + "\n\n" + "    expected   " + greekName + ": " + expected + "\n" + "    calculated " + greekName + ": " + calculated + "\n" + "    error:            " + Math.abs(expected - calculated) + "\n" + "    tolerance:        " + tolerance));
    }
}

