/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.testsuite.currency;

import java.util.HashSet;
import org.jquantlib.QL;
import org.jquantlib.currencies.Currency;
import org.jquantlib.currencies.Europe;
import org.jquantlib.math.Rounding;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class CurrencyTest {
    public CurrencyTest() {
        QL.info("::::: " + this.getClass().getSimpleName() + " :::::");
    }

    @Test
    public void testCurrencies() {
        QL.info("testing currencies...");
        Europe.CHFCurrency chf = new Europe.CHFCurrency();
        QL.info("testing correct initialization...");
        Assert.assertTrue((boolean)chf.name().equalsIgnoreCase("Swiss franc"));
        Assert.assertTrue((boolean)chf.code().equalsIgnoreCase("CHF"));
        Assert.assertEquals((long)chf.numericCode(), (long)756L);
        Assert.assertTrue((boolean)chf.symbol().equalsIgnoreCase("SwF"));
        Assert.assertTrue((boolean)chf.fractionSymbol().equalsIgnoreCase(""));
        Assert.assertEquals((long)chf.fractionsPerUnit(), (long)100L);
        Assert.assertEquals((Object)((Object)chf.rounding().type()), (Object)((Object)Rounding.Type.None));
        Assert.assertTrue((chf.triangulationCurrency().getClass() == Currency.class ? 1 : 0) != 0);
        Assert.assertTrue((boolean)chf.triangulationCurrency().empty());
        QL.info("testing overloaded operators....(only class based)");
        Europe.EURCurrency euro = new Europe.EURCurrency();
        Europe.CHFCurrency chf2 = new Europe.CHFCurrency();
        Assert.assertFalse((boolean)euro.eq(chf));
        Assert.assertTrue((boolean)euro.ne(chf));
        Assert.assertFalse((boolean)chf2.ne(chf));
        Assert.assertTrue((boolean)chf2.eq(chf));
        Assert.assertFalse((boolean)euro.eq(null));
        Assert.assertTrue((boolean)chf.eq(chf2));
        Assert.assertTrue((boolean)chf.eq(chf));
        Assert.assertTrue((boolean)Currency.operatorEquals(chf, chf2));
        Assert.assertTrue((boolean)Currency.operatorNotEquals(chf, euro));
        HashSet<Europe.CHFCurrency> testSet = new HashSet<Europe.CHFCurrency>();
        testSet.add(chf);
        Assert.assertTrue((boolean)testSet.contains(chf));
        Assert.assertFalse((boolean)testSet.contains(euro));
    }

    @Ignore
    @Test(expected=NullPointerException.class)
    public void testLeakyCurrencyInitialization() {
        Europe.CHFCurrency chf = new Europe.CHFCurrency();
        chf.triangulationCurrency().code();
    }
}

