/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.testsuite.calendars;

import java.util.ArrayList;
import org.jquantlib.testsuite.calendars.CalendarUtil;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.Date;
import org.jquantlib.time.Month;
import org.jquantlib.time.calendars.UnitedKingdom;
import org.junit.Test;

public class UnitedKingdomCalendarTest {
    private final Calendar metals;
    private final Calendar settlement;
    private final Calendar exchange;

    public UnitedKingdomCalendarTest() {
        System.out.println("::::: " + this.getClass().getSimpleName() + " :::::");
        this.metals = new UnitedKingdom(UnitedKingdom.Market.Metals);
        this.settlement = new UnitedKingdom(UnitedKingdom.Market.Settlement);
        this.exchange = new UnitedKingdom(UnitedKingdom.Market.Exchange);
    }

    @Test
    public void testUnitedKingdomMetalsYear2004() {
        int year = 2004;
        System.out.println("Testing " + this.metals.name() + " holiday list for the year " + year + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(1, Month.January, year));
        expectedHol.add(new Date(9, Month.April, year));
        expectedHol.add(new Date(12, Month.April, year));
        expectedHol.add(new Date(3, Month.May, year));
        expectedHol.add(new Date(31, Month.May, year));
        expectedHol.add(new Date(30, Month.August, year));
        expectedHol.add(new Date(27, Month.December, year));
        expectedHol.add(new Date(28, Month.December, year));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.metals, year);
    }

    @Test
    public void testUnitedKingdomMetalsYear2005() {
        int year = 2005;
        System.out.println("Testing " + this.metals.name() + " holiday list for the year " + year + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(3, Month.January, year));
        expectedHol.add(new Date(25, Month.March, year));
        expectedHol.add(new Date(28, Month.March, year));
        expectedHol.add(new Date(2, Month.May, year));
        expectedHol.add(new Date(30, Month.May, year));
        expectedHol.add(new Date(29, Month.August, year));
        expectedHol.add(new Date(26, Month.December, year));
        expectedHol.add(new Date(27, Month.December, year));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.metals, year);
    }

    @Test
    public void testUnitedKingdomMetalsYear2006() {
        int year = 2006;
        System.out.println("Testing " + this.metals.name() + " holiday list for the year " + year + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(2, Month.January, year));
        expectedHol.add(new Date(14, Month.April, year));
        expectedHol.add(new Date(17, Month.April, year));
        expectedHol.add(new Date(1, Month.May, year));
        expectedHol.add(new Date(29, Month.May, year));
        expectedHol.add(new Date(28, Month.August, year));
        expectedHol.add(new Date(25, Month.December, year));
        expectedHol.add(new Date(26, Month.December, year));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.metals, year);
    }

    @Test
    public void testUnitedKingdomMetalsYear2007() {
        int year = 2007;
        System.out.println("Testing " + this.metals.name() + " holiday list for the year " + year + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(1, Month.January, year));
        expectedHol.add(new Date(6, Month.April, year));
        expectedHol.add(new Date(9, Month.April, year));
        expectedHol.add(new Date(7, Month.May, year));
        expectedHol.add(new Date(28, Month.May, year));
        expectedHol.add(new Date(27, Month.August, year));
        expectedHol.add(new Date(25, Month.December, year));
        expectedHol.add(new Date(26, Month.December, year));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.metals, year);
    }

    @Test
    public void testUnitedKingdomMetalsYear2008() {
        int year = 2008;
        System.out.println("Testing " + this.metals.name() + " holiday list for the year " + year + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(1, Month.January, year));
        expectedHol.add(new Date(21, Month.March, year));
        expectedHol.add(new Date(24, Month.March, year));
        expectedHol.add(new Date(5, Month.May, year));
        expectedHol.add(new Date(26, Month.May, year));
        expectedHol.add(new Date(25, Month.August, year));
        expectedHol.add(new Date(25, Month.December, year));
        expectedHol.add(new Date(26, Month.December, year));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.metals, year);
    }

    @Test
    public void testUnitedKingdomMetalsYear2009() {
        int year = 2009;
        System.out.println("Testing " + this.metals.name() + " holiday list for the year " + year + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(1, Month.January, year));
        expectedHol.add(new Date(10, Month.April, year));
        expectedHol.add(new Date(13, Month.April, year));
        expectedHol.add(new Date(4, Month.May, year));
        expectedHol.add(new Date(25, Month.May, year));
        expectedHol.add(new Date(31, Month.August, year));
        expectedHol.add(new Date(25, Month.December, year));
        expectedHol.add(new Date(28, Month.December, year));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.metals, year);
    }

    @Test
    public void testUnitedKingdomMetalsYear2010() {
        int year = 2010;
        System.out.println("Testing " + this.metals.name() + " holiday list for the year " + year + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(1, Month.January, year));
        expectedHol.add(new Date(2, Month.April, year));
        expectedHol.add(new Date(5, Month.April, year));
        expectedHol.add(new Date(3, Month.May, year));
        expectedHol.add(new Date(31, Month.May, year));
        expectedHol.add(new Date(30, Month.August, year));
        expectedHol.add(new Date(27, Month.December, year));
        expectedHol.add(new Date(28, Month.December, year));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.metals, year);
    }

    public void testUnitedKingdomSettlementYear2004() {
        int year = 2004;
        System.out.println("Testing " + this.settlement.name() + " holiday list for the year " + year + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(1, Month.January, year));
        expectedHol.add(new Date(2, Month.January, year));
        expectedHol.add(new Date(3, Month.January, year));
        expectedHol.add(new Date(14, Month.February, year));
        expectedHol.add(new Date(9, Month.April, year));
        expectedHol.add(new Date(12, Month.April, year));
        expectedHol.add(new Date(3, Month.May, year));
        expectedHol.add(new Date(31, Month.May, year));
        expectedHol.add(new Date(30, Month.August, year));
        expectedHol.add(new Date(25, Month.December, year));
        expectedHol.add(new Date(26, Month.December, year));
        expectedHol.add(new Date(27, Month.December, year));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.settlement, year);
    }

    @Test
    public void testUnitedKingdomSettlementYear2005() {
        int year = 2005;
        System.out.println("Testing " + this.settlement.name() + " holiday list for the year " + year + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(3, Month.January, year));
        expectedHol.add(new Date(25, Month.March, year));
        expectedHol.add(new Date(28, Month.March, year));
        expectedHol.add(new Date(2, Month.May, year));
        expectedHol.add(new Date(30, Month.May, year));
        expectedHol.add(new Date(29, Month.August, year));
        expectedHol.add(new Date(26, Month.December, year));
        expectedHol.add(new Date(27, Month.December, year));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.settlement, year);
    }

    @Test
    public void testUnitedKingdomSettlementYear2006() {
        int year = 2006;
        System.out.println("Testing " + this.settlement.name() + " holiday list for the year " + year + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(2, Month.January, year));
        expectedHol.add(new Date(14, Month.April, year));
        expectedHol.add(new Date(17, Month.April, year));
        expectedHol.add(new Date(1, Month.May, year));
        expectedHol.add(new Date(29, Month.May, year));
        expectedHol.add(new Date(28, Month.August, year));
        expectedHol.add(new Date(25, Month.December, year));
        expectedHol.add(new Date(26, Month.December, year));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.settlement, year);
    }

    @Test
    public void testUnitedKingdomSettlementYear2007() {
        int year = 2007;
        System.out.println("Testing " + this.settlement.name() + " holiday list for the year " + year + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(1, Month.January, year));
        expectedHol.add(new Date(6, Month.April, year));
        expectedHol.add(new Date(9, Month.April, year));
        expectedHol.add(new Date(7, Month.May, year));
        expectedHol.add(new Date(28, Month.May, year));
        expectedHol.add(new Date(27, Month.August, year));
        expectedHol.add(new Date(25, Month.December, year));
        expectedHol.add(new Date(26, Month.December, year));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.settlement, year);
    }

    @Test
    public void testUnitedKingdomSettlementYear2008() {
        int year = 2008;
        System.out.println("Testing " + this.settlement.name() + " holiday list for the year " + year + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(1, Month.January, year));
        expectedHol.add(new Date(21, Month.March, year));
        expectedHol.add(new Date(24, Month.March, year));
        expectedHol.add(new Date(5, Month.May, year));
        expectedHol.add(new Date(26, Month.May, year));
        expectedHol.add(new Date(25, Month.August, year));
        expectedHol.add(new Date(25, Month.December, year));
        expectedHol.add(new Date(26, Month.December, year));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.settlement, year);
    }

    @Test
    public void testUnitedKingdomSettlementYear2009() {
        int year = 2009;
        System.out.println("Testing " + this.settlement.name() + " holiday list for the year " + year + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(1, Month.January, year));
        expectedHol.add(new Date(10, Month.April, year));
        expectedHol.add(new Date(13, Month.April, year));
        expectedHol.add(new Date(4, Month.May, year));
        expectedHol.add(new Date(25, Month.May, year));
        expectedHol.add(new Date(31, Month.August, year));
        expectedHol.add(new Date(25, Month.December, year));
        expectedHol.add(new Date(28, Month.December, year));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.settlement, year);
    }

    @Test
    public void testUnitedKingdomSettlementYear2010() {
        int year = 2010;
        System.out.println("Testing " + this.settlement.name() + " holiday list for the year " + year + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(1, Month.January, year));
        expectedHol.add(new Date(2, Month.April, year));
        expectedHol.add(new Date(5, Month.April, year));
        expectedHol.add(new Date(3, Month.May, year));
        expectedHol.add(new Date(31, Month.May, year));
        expectedHol.add(new Date(30, Month.August, year));
        expectedHol.add(new Date(27, Month.December, year));
        expectedHol.add(new Date(28, Month.December, year));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.settlement, year);
    }

    public void testUnitedKingdomExchangeYear2004() {
        int year = 2004;
        System.out.println("Testing " + this.exchange.name() + " holiday list for the year " + year + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(1, Month.January, year));
        expectedHol.add(new Date(2, Month.January, year));
        expectedHol.add(new Date(3, Month.January, year));
        expectedHol.add(new Date(14, Month.February, year));
        expectedHol.add(new Date(9, Month.April, year));
        expectedHol.add(new Date(12, Month.April, year));
        expectedHol.add(new Date(3, Month.May, year));
        expectedHol.add(new Date(31, Month.May, year));
        expectedHol.add(new Date(30, Month.August, year));
        expectedHol.add(new Date(25, Month.December, year));
        expectedHol.add(new Date(26, Month.December, year));
        expectedHol.add(new Date(27, Month.December, year));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.exchange, year);
    }

    @Test
    public void testUnitedKingdomExchangeYear2005() {
        int year = 2005;
        System.out.println("Testing " + this.exchange.name() + " holiday list for the year " + year + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(3, Month.January, year));
        expectedHol.add(new Date(25, Month.March, year));
        expectedHol.add(new Date(28, Month.March, year));
        expectedHol.add(new Date(2, Month.May, year));
        expectedHol.add(new Date(30, Month.May, year));
        expectedHol.add(new Date(29, Month.August, year));
        expectedHol.add(new Date(26, Month.December, year));
        expectedHol.add(new Date(27, Month.December, year));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.exchange, year);
    }

    @Test
    public void testUnitedKingdomExchangeYear2006() {
        int year = 2006;
        System.out.println("Testing " + this.exchange.name() + " holiday list for the year " + year + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(2, Month.January, year));
        expectedHol.add(new Date(14, Month.April, year));
        expectedHol.add(new Date(17, Month.April, year));
        expectedHol.add(new Date(1, Month.May, year));
        expectedHol.add(new Date(29, Month.May, year));
        expectedHol.add(new Date(28, Month.August, year));
        expectedHol.add(new Date(25, Month.December, year));
        expectedHol.add(new Date(26, Month.December, year));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.exchange, year);
    }

    @Test
    public void testUnitedKingdomExchangeYear2007() {
        int year = 2007;
        System.out.println("Testing " + this.exchange.name() + " holiday list for the year " + year + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(1, Month.January, year));
        expectedHol.add(new Date(6, Month.April, year));
        expectedHol.add(new Date(9, Month.April, year));
        expectedHol.add(new Date(7, Month.May, year));
        expectedHol.add(new Date(28, Month.May, year));
        expectedHol.add(new Date(27, Month.August, year));
        expectedHol.add(new Date(25, Month.December, year));
        expectedHol.add(new Date(26, Month.December, year));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.exchange, year);
    }

    @Test
    public void testUnitedKingdomExchangeYear2008() {
        int year = 2008;
        System.out.println("Testing " + this.exchange.name() + " holiday list for the year " + year + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(1, Month.January, year));
        expectedHol.add(new Date(21, Month.March, year));
        expectedHol.add(new Date(24, Month.March, year));
        expectedHol.add(new Date(5, Month.May, year));
        expectedHol.add(new Date(26, Month.May, year));
        expectedHol.add(new Date(25, Month.August, year));
        expectedHol.add(new Date(25, Month.December, year));
        expectedHol.add(new Date(26, Month.December, year));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.exchange, year);
    }

    @Test
    public void testUnitedKingdomExchangeYear2009() {
        int year = 2009;
        System.out.println("Testing " + this.exchange.name() + " holiday list for the year " + year + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(1, Month.January, year));
        expectedHol.add(new Date(10, Month.April, year));
        expectedHol.add(new Date(13, Month.April, year));
        expectedHol.add(new Date(4, Month.May, year));
        expectedHol.add(new Date(25, Month.May, year));
        expectedHol.add(new Date(31, Month.August, year));
        expectedHol.add(new Date(25, Month.December, year));
        expectedHol.add(new Date(28, Month.December, year));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.exchange, year);
    }

    @Test
    public void testUnitedKingdomExchangeYear2010() {
        int year = 2010;
        System.out.println("Testing " + this.exchange.name() + " holiday list for the year " + year + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(1, Month.January, year));
        expectedHol.add(new Date(2, Month.April, year));
        expectedHol.add(new Date(5, Month.April, year));
        expectedHol.add(new Date(3, Month.May, year));
        expectedHol.add(new Date(31, Month.May, year));
        expectedHol.add(new Date(30, Month.August, year));
        expectedHol.add(new Date(27, Month.December, year));
        expectedHol.add(new Date(28, Month.December, year));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.exchange, year);
    }
}

