/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.testsuite.calendars;

import java.util.List;
import java.util.Vector;
import org.jquantlib.QL;
import org.jquantlib.testsuite.calendars.CalendarUtil;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.Date;
import org.jquantlib.time.Month;
import org.jquantlib.time.calendars.SouthKorea;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class SouthKoreaCalendarTest {
    private Calendar c = null;
    private List<Date> expectedHol = null;

    public SouthKoreaCalendarTest() {
        QL.info("::::: " + this.getClass().getSimpleName() + " :::::");
    }

    @Before
    public void setup() {
        this.c = new SouthKorea(SouthKorea.Market.KRX);
        this.expectedHol = new Vector<Date>();
    }

    @Test
    public void testSouthKoreaKRXHolidaysYear2004() {
        int year = 2004;
        QL.info("Testing " + (Object)((Object)SouthKorea.Market.KRX) + " holidays list for the year " + 2004 + "...");
        this.expectedHol.add(new Date(1, Month.January, 2004));
        this.expectedHol.add(new Date(21, Month.January, 2004));
        this.expectedHol.add(new Date(22, Month.January, 2004));
        this.expectedHol.add(new Date(23, Month.January, 2004));
        this.expectedHol.add(new Date(1, Month.March, 2004));
        this.expectedHol.add(new Date(5, Month.April, 2004));
        this.expectedHol.add(new Date(15, Month.April, 2004));
        this.expectedHol.add(new Date(5, Month.May, 2004));
        this.expectedHol.add(new Date(26, Month.May, 2004));
        this.expectedHol.add(new Date(27, Month.September, 2004));
        this.expectedHol.add(new Date(28, Month.September, 2004));
        this.expectedHol.add(new Date(29, Month.September, 2004));
        this.expectedHol.add(new Date(31, Month.December, 2004));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(this.expectedHol, this.c, 2004);
    }

    @Test
    public void testSouthKoreaKRXHolidaysYear2005() {
        int year = 2005;
        QL.info("Testing " + (Object)((Object)SouthKorea.Market.KRX) + " holidays list for the year " + 2005 + "...");
        this.expectedHol.add(new Date(8, Month.February, 2005));
        this.expectedHol.add(new Date(9, Month.February, 2005));
        this.expectedHol.add(new Date(10, Month.February, 2005));
        this.expectedHol.add(new Date(1, Month.March, 2005));
        this.expectedHol.add(new Date(5, Month.April, 2005));
        this.expectedHol.add(new Date(5, Month.May, 2005));
        this.expectedHol.add(new Date(6, Month.June, 2005));
        this.expectedHol.add(new Date(15, Month.August, 2005));
        this.expectedHol.add(new Date(19, Month.September, 2005));
        this.expectedHol.add(new Date(3, Month.October, 2005));
        this.expectedHol.add(new Date(30, Month.December, 2005));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(this.expectedHol, this.c, 2005);
    }

    @Test
    public void testSouthKoreaKRXHolidaysYear2006() {
        int year = 2006;
        QL.info("Testing " + (Object)((Object)SouthKorea.Market.KRX) + " holidays list for the year " + 2006 + "...");
        this.expectedHol.add(new Date(30, Month.January, 2006));
        this.expectedHol.add(new Date(1, Month.March, 2006));
        this.expectedHol.add(new Date(1, Month.May, 2006));
        this.expectedHol.add(new Date(5, Month.May, 2006));
        this.expectedHol.add(new Date(31, Month.May, 2006));
        this.expectedHol.add(new Date(6, Month.June, 2006));
        this.expectedHol.add(new Date(17, Month.July, 2006));
        this.expectedHol.add(new Date(15, Month.August, 2006));
        this.expectedHol.add(new Date(3, Month.October, 2006));
        this.expectedHol.add(new Date(5, Month.October, 2006));
        this.expectedHol.add(new Date(6, Month.October, 2006));
        this.expectedHol.add(new Date(25, Month.December, 2006));
        this.expectedHol.add(new Date(29, Month.December, 2006));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(this.expectedHol, this.c, 2006);
    }

    @Test
    public void testSouthKoreaKRXHolidaysYear2007() {
        int year = 2007;
        QL.info("Testing " + (Object)((Object)SouthKorea.Market.KRX) + " holidays list for the year " + 2007 + "...");
        this.expectedHol.add(new Date(1, Month.January, 2007));
        this.expectedHol.add(new Date(19, Month.February, 2007));
        this.expectedHol.add(new Date(1, Month.March, 2007));
        this.expectedHol.add(new Date(1, Month.May, 2007));
        this.expectedHol.add(new Date(24, Month.May, 2007));
        this.expectedHol.add(new Date(6, Month.June, 2007));
        this.expectedHol.add(new Date(17, Month.July, 2007));
        this.expectedHol.add(new Date(15, Month.August, 2007));
        this.expectedHol.add(new Date(24, Month.September, 2007));
        this.expectedHol.add(new Date(25, Month.September, 2007));
        this.expectedHol.add(new Date(26, Month.September, 2007));
        this.expectedHol.add(new Date(3, Month.October, 2007));
        this.expectedHol.add(new Date(19, Month.December, 2007));
        this.expectedHol.add(new Date(25, Month.December, 2007));
        this.expectedHol.add(new Date(31, Month.December, 2007));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(this.expectedHol, this.c, 2007);
    }

    @Test
    public void testSouthKoreaKRXHolidaysYear2008() {
        int year = 2008;
        QL.info("Testing " + (Object)((Object)SouthKorea.Market.KRX) + " holidays list for the year " + 2008 + "...");
        this.expectedHol.add(new Date(1, Month.January, 2008));
        this.expectedHol.add(new Date(6, Month.February, 2008));
        this.expectedHol.add(new Date(7, Month.February, 2008));
        this.expectedHol.add(new Date(8, Month.February, 2008));
        this.expectedHol.add(new Date(9, Month.April, 2008));
        this.expectedHol.add(new Date(1, Month.May, 2008));
        this.expectedHol.add(new Date(5, Month.May, 2008));
        this.expectedHol.add(new Date(12, Month.May, 2008));
        this.expectedHol.add(new Date(6, Month.June, 2008));
        this.expectedHol.add(new Date(15, Month.August, 2008));
        this.expectedHol.add(new Date(15, Month.September, 2008));
        this.expectedHol.add(new Date(3, Month.October, 2008));
        this.expectedHol.add(new Date(25, Month.December, 2008));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(this.expectedHol, this.c, 2008);
    }

    @Test
    public void testSouthKoreaKRXHolidaysYear2009() {
        int year = 2009;
        QL.info("Testing " + (Object)((Object)SouthKorea.Market.KRX) + " holidays list for the year " + 2009 + "...");
        this.expectedHol.add(new Date(1, Month.January, 2009));
        this.expectedHol.add(new Date(26, Month.January, 2009));
        this.expectedHol.add(new Date(27, Month.January, 2009));
        this.expectedHol.add(new Date(1, Month.May, 2009));
        this.expectedHol.add(new Date(5, Month.May, 2009));
        this.expectedHol.add(new Date(2, Month.October, 2009));
        this.expectedHol.add(new Date(25, Month.December, 2009));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(this.expectedHol, this.c, 2009);
    }

    @Test
    public void testSouthKoreaKRXHolidaysYear2010() {
        int year = 2010;
        QL.info("Testing " + (Object)((Object)SouthKorea.Market.KRX) + " holidays list for the year " + 2010 + "...");
        this.expectedHol.add(new Date(1, Month.January, 2010));
        this.expectedHol.add(new Date(15, Month.February, 2010));
        this.expectedHol.add(new Date(1, Month.March, 2010));
        this.expectedHol.add(new Date(5, Month.May, 2010));
        this.expectedHol.add(new Date(21, Month.May, 2010));
        this.expectedHol.add(new Date(21, Month.September, 2010));
        this.expectedHol.add(new Date(22, Month.September, 2010));
        this.expectedHol.add(new Date(23, Month.September, 2010));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(this.expectedHol, this.c, 2010);
    }

    @Test
    public void testSouthKoreaKRXHolidaysYear2011() {
        int year = 2011;
        QL.info("Testing " + (Object)((Object)SouthKorea.Market.KRX) + " holidays list for the year " + 2011 + "...");
        this.expectedHol.add(new Date(1, Month.March, 2011));
        this.expectedHol.add(new Date(5, Month.May, 2011));
        this.expectedHol.add(new Date(6, Month.June, 2011));
        this.expectedHol.add(new Date(15, Month.August, 2011));
        this.expectedHol.add(new Date(3, Month.October, 2011));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(this.expectedHol, this.c, 2011);
    }

    @Test
    public void testSouthKoreaKRXHolidaysYear2012() {
        int year = 2012;
        QL.info("Testing " + (Object)((Object)SouthKorea.Market.KRX) + " holidays list for the year " + 2012 + "...");
        this.expectedHol.add(new Date(1, Month.March, 2012));
        this.expectedHol.add(new Date(1, Month.May, 2012));
        this.expectedHol.add(new Date(6, Month.June, 2012));
        this.expectedHol.add(new Date(15, Month.August, 2012));
        this.expectedHol.add(new Date(3, Month.October, 2012));
        this.expectedHol.add(new Date(25, Month.December, 2012));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(this.expectedHol, this.c, 2012);
    }

    @After
    public void destroy() {
        this.c = null;
        this.expectedHol = null;
    }
}

