/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.testsuite.calendars;

import java.util.ArrayList;
import org.jquantlib.QL;
import org.jquantlib.testsuite.calendars.CalendarUtil;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.Date;
import org.jquantlib.time.Month;
import org.jquantlib.time.calendars.SaudiArabia;
import org.junit.Test;

public class SaudiArabiaCalendarTest {
    private final Calendar exchange;

    public SaudiArabiaCalendarTest() {
        QL.info("::::: " + this.getClass().getSimpleName() + " :::::");
        this.exchange = new SaudiArabia(SaudiArabia.Market.Tadawul);
    }

    @Test
    public void testSaudiArabiaYear2004() {
        int year = 2004;
        QL.info("Testing SaudiArabia's holiday list for the year 2004...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(1, Month.February, 2004));
        expectedHol.add(new Date(2, Month.February, 2004));
        expectedHol.add(new Date(3, Month.February, 2004));
        expectedHol.add(new Date(4, Month.February, 2004));
        expectedHol.add(new Date(27, Month.November, 2004));
        expectedHol.add(new Date(28, Month.November, 2004));
        expectedHol.add(new Date(29, Month.November, 2004));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.exchange, 2004);
    }

    @Test
    public void testSaudiArabiaYear2005() {
        int year = 2005;
        QL.info("Testing SaudiArabia's holiday list for the year 2005...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(22, Month.January, 2005));
        expectedHol.add(new Date(23, Month.January, 2005));
        expectedHol.add(new Date(24, Month.January, 2005));
        expectedHol.add(new Date(25, Month.January, 2005));
        expectedHol.add(new Date(14, Month.November, 2005));
        expectedHol.add(new Date(15, Month.November, 2005));
        expectedHol.add(new Date(16, Month.November, 2005));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.exchange, 2005);
    }

    @Test
    public void testSaudiArabiaYear2006() {
        int year = 2006;
        QL.info("Testing SaudiArabia's holiday list for the year 2006...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(23, Month.September, 2006));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.exchange, 2006);
    }

    @Test
    public void testSaudiArabiaYear2007() {
        int year = 2007;
        QL.info("Testing SaudiArabia's holiday list for the year 2007...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(23, Month.September, 2007));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.exchange, 2007);
    }

    @Test
    public void testSaudiArabiaYear2008() {
        int year = 2008;
        QL.info("Testing SaudiArabia's holiday list for the year 2008...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(23, Month.September, 2008));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.exchange, 2008);
    }

    @Test
    public void testSaudiArabiaYear2009() {
        int year = 2009;
        QL.info("Testing SaudiArabia's holiday list for the year 2009...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(23, Month.September, 2009));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.exchange, 2009);
    }

    @Test
    public void testSaudiArabiaYear2010() {
        int year = 2010;
        QL.info("Testing SaudiArabia's holiday list for the year 2010...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.exchange, 2010);
    }

    @Test
    public void testSaudiArabiaYear2011() {
        int year = 2011;
        QL.info("Testing SaudiArabia's holiday list for the year 2011...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.exchange, 2011);
    }

    @Test
    public void testSaudiArabiaYear2012() {
        int year = 2012;
        QL.info("Testing SaudiArabia's holiday list for the year 2012...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(23, Month.September, 2012));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.exchange, 2012);
    }
}

