/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.testsuite.calendars;

import java.util.List;
import java.util.Vector;
import org.jquantlib.QL;
import org.jquantlib.testsuite.calendars.CalendarUtil;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.Date;
import org.jquantlib.time.Month;
import org.jquantlib.time.calendars.Mexico;
import org.junit.Before;
import org.junit.Test;

public class MexicoCalendarTest {
    private Calendar bmvCalendar;
    private List<Date> expectedHol;

    @Before
    public void setUp() {
        this.bmvCalendar = new Mexico(Mexico.Market.BMV);
        this.expectedHol = new Vector<Date>();
    }

    @Test
    public void testMexicoBVMYear2004() {
        int year = 2004;
        QL.info("Testing Mexican BVM holiday list for the year 2004...");
        this.expectedHol.add(new Date(1, Month.January, 2004));
        this.expectedHol.add(new Date(5, Month.February, 2004));
        this.expectedHol.add(new Date(8, Month.April, 2004));
        this.expectedHol.add(new Date(9, Month.April, 2004));
        this.expectedHol.add(new Date(16, Month.September, 2004));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(this.expectedHol, this.bmvCalendar, 2004);
    }

    @Test
    public void testMexicoBVMYear2005() {
        int year = 2005;
        QL.info("Testing Mexican BVM holiday list for the year 2005...");
        this.expectedHol.add(new Date(21, Month.March, 2005));
        this.expectedHol.add(new Date(24, Month.March, 2005));
        this.expectedHol.add(new Date(25, Month.March, 2005));
        this.expectedHol.add(new Date(16, Month.September, 2005));
        this.expectedHol.add(new Date(12, Month.December, 2005));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(this.expectedHol, this.bmvCalendar, 2005);
    }

    @Test
    public void testMexicoBVMYear2006() {
        int year = 2006;
        QL.info("Testing Mexican BVM holiday list for the year 2006...");
        this.expectedHol.add(new Date(21, Month.March, 2006));
        this.expectedHol.add(new Date(13, Month.April, 2006));
        this.expectedHol.add(new Date(14, Month.April, 2006));
        this.expectedHol.add(new Date(1, Month.May, 2006));
        this.expectedHol.add(new Date(12, Month.December, 2006));
        this.expectedHol.add(new Date(25, Month.December, 2006));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(this.expectedHol, this.bmvCalendar, 2006);
    }

    @Test
    public void testMexicoBVMYear2007() {
        int year = 2007;
        QL.info("Testing Mexican BVM holiday list for the year 2007...");
        this.expectedHol.add(new Date(1, Month.January, 2007));
        this.expectedHol.add(new Date(5, Month.February, 2007));
        this.expectedHol.add(new Date(21, Month.March, 2007));
        this.expectedHol.add(new Date(5, Month.April, 2007));
        this.expectedHol.add(new Date(6, Month.April, 2007));
        this.expectedHol.add(new Date(1, Month.May, 2007));
        this.expectedHol.add(new Date(12, Month.December, 2007));
        this.expectedHol.add(new Date(25, Month.December, 2007));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(this.expectedHol, this.bmvCalendar, 2007);
    }

    @Test
    public void testMexicoBVMYear2008() {
        int year = 2008;
        QL.info("Testing Mexican BVM holiday list for the year 2008...");
        this.expectedHol.add(new Date(1, Month.January, 2008));
        this.expectedHol.add(new Date(5, Month.February, 2008));
        this.expectedHol.add(new Date(20, Month.March, 2008));
        this.expectedHol.add(new Date(21, Month.March, 2008));
        this.expectedHol.add(new Date(1, Month.May, 2008));
        this.expectedHol.add(new Date(16, Month.September, 2008));
        this.expectedHol.add(new Date(12, Month.December, 2008));
        this.expectedHol.add(new Date(25, Month.December, 2008));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(this.expectedHol, this.bmvCalendar, 2008);
    }

    @Test
    public void testMexicoBVMYear2009() {
        int year = 2009;
        QL.info("Testing Mexican BVM holiday list for the year 2009...");
        this.expectedHol.add(new Date(1, Month.January, 2009));
        this.expectedHol.add(new Date(5, Month.February, 2009));
        this.expectedHol.add(new Date(9, Month.April, 2009));
        this.expectedHol.add(new Date(10, Month.April, 2009));
        this.expectedHol.add(new Date(1, Month.May, 2009));
        this.expectedHol.add(new Date(16, Month.September, 2009));
        this.expectedHol.add(new Date(25, Month.December, 2009));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(this.expectedHol, this.bmvCalendar, 2009);
    }

    @Test
    public void testMexicoBVMYear2010() {
        int year = 2010;
        QL.info("Testing Mexican BVM holiday list for the year 2010...");
        this.expectedHol.add(new Date(1, Month.January, 2010));
        this.expectedHol.add(new Date(5, Month.February, 2010));
        this.expectedHol.add(new Date(1, Month.April, 2010));
        this.expectedHol.add(new Date(2, Month.April, 2010));
        this.expectedHol.add(new Date(16, Month.September, 2010));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(this.expectedHol, this.bmvCalendar, 2010);
    }

    @Test
    public void testMexicoBVMYear2011() {
        int year = 2011;
        QL.info("Testing Mexican BVM holiday list for the year 2011...");
        this.expectedHol.add(new Date(21, Month.March, 2011));
        this.expectedHol.add(new Date(21, Month.April, 2011));
        this.expectedHol.add(new Date(22, Month.April, 2011));
        this.expectedHol.add(new Date(16, Month.September, 2011));
        this.expectedHol.add(new Date(12, Month.December, 2011));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(this.expectedHol, this.bmvCalendar, 2011);
    }

    @Test
    public void testMexicoBVMYear2012() {
        int year = 2012;
        QL.info("Testing Mexican BVM holiday list for the year 2012...");
        this.expectedHol.add(new Date(21, Month.March, 2012));
        this.expectedHol.add(new Date(5, Month.April, 2012));
        this.expectedHol.add(new Date(6, Month.April, 2012));
        this.expectedHol.add(new Date(1, Month.May, 2012));
        this.expectedHol.add(new Date(12, Month.December, 2012));
        this.expectedHol.add(new Date(25, Month.December, 2012));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(this.expectedHol, this.bmvCalendar, 2012);
    }
}

