/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.testsuite.calendars;

import java.util.ArrayList;
import org.jquantlib.QL;
import org.jquantlib.testsuite.calendars.CalendarUtil;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.Date;
import org.jquantlib.time.Month;
import org.jquantlib.time.calendars.Iceland;
import org.junit.Test;

public class IcelandCalendarTest {
    private final Calendar exchange;

    public IcelandCalendarTest() {
        QL.info("::::: " + this.getClass().getSimpleName() + " :::::");
        this.exchange = new Iceland(Iceland.Market.ICEX);
    }

    @Test
    public void testIcelandYear2004() {
        int year = 2004;
        QL.info("Testing " + (Object)((Object)Iceland.Market.ICEX) + " holidays list for the year " + 2004 + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(1, Month.January, 2004));
        expectedHol.add(new Date(8, Month.April, 2004));
        expectedHol.add(new Date(9, Month.April, 2004));
        expectedHol.add(new Date(12, Month.April, 2004));
        expectedHol.add(new Date(22, Month.April, 2004));
        expectedHol.add(new Date(20, Month.May, 2004));
        expectedHol.add(new Date(31, Month.May, 2004));
        expectedHol.add(new Date(17, Month.June, 2004));
        expectedHol.add(new Date(2, Month.August, 2004));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.exchange, 2004);
    }

    @Test
    public void testIcelandYear2005() {
        int year = 2005;
        QL.info("Testing " + (Object)((Object)Iceland.Market.ICEX) + " holidays list for the year " + 2005 + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(3, Month.January, 2005));
        expectedHol.add(new Date(24, Month.March, 2005));
        expectedHol.add(new Date(25, Month.March, 2005));
        expectedHol.add(new Date(28, Month.March, 2005));
        expectedHol.add(new Date(21, Month.April, 2005));
        expectedHol.add(new Date(5, Month.May, 2005));
        expectedHol.add(new Date(16, Month.May, 2005));
        expectedHol.add(new Date(17, Month.June, 2005));
        expectedHol.add(new Date(1, Month.August, 2005));
        expectedHol.add(new Date(26, Month.December, 2005));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.exchange, 2005);
    }

    @Test
    public void testIcelandYear2006() {
        int year = 2006;
        QL.info("Testing " + (Object)((Object)Iceland.Market.ICEX) + " holidays list for the year " + 2006 + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(2, Month.January, 2006));
        expectedHol.add(new Date(13, Month.April, 2006));
        expectedHol.add(new Date(14, Month.April, 2006));
        expectedHol.add(new Date(17, Month.April, 2006));
        expectedHol.add(new Date(20, Month.April, 2006));
        expectedHol.add(new Date(1, Month.May, 2006));
        expectedHol.add(new Date(25, Month.May, 2006));
        expectedHol.add(new Date(5, Month.June, 2006));
        expectedHol.add(new Date(7, Month.August, 2006));
        expectedHol.add(new Date(25, Month.December, 2006));
        expectedHol.add(new Date(26, Month.December, 2006));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.exchange, 2006);
    }

    @Test
    public void testIcelandYear2007() {
        int year = 2007;
        QL.info("Testing " + (Object)((Object)Iceland.Market.ICEX) + " holidays list for the year " + 2007 + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(1, Month.January, 2007));
        expectedHol.add(new Date(5, Month.April, 2007));
        expectedHol.add(new Date(6, Month.April, 2007));
        expectedHol.add(new Date(9, Month.April, 2007));
        expectedHol.add(new Date(19, Month.April, 2007));
        expectedHol.add(new Date(1, Month.May, 2007));
        expectedHol.add(new Date(17, Month.May, 2007));
        expectedHol.add(new Date(28, Month.May, 2007));
        expectedHol.add(new Date(6, Month.August, 2007));
        expectedHol.add(new Date(25, Month.December, 2007));
        expectedHol.add(new Date(26, Month.December, 2007));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.exchange, 2007);
    }

    @Test
    public void testIcelandYear2008() {
        int year = 2008;
        QL.info("Testing " + (Object)((Object)Iceland.Market.ICEX) + " holidays list for the year " + 2008 + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(1, Month.January, 2008));
        expectedHol.add(new Date(20, Month.March, 2008));
        expectedHol.add(new Date(21, Month.March, 2008));
        expectedHol.add(new Date(24, Month.March, 2008));
        expectedHol.add(new Date(24, Month.April, 2008));
        expectedHol.add(new Date(1, Month.May, 2008));
        expectedHol.add(new Date(12, Month.May, 2008));
        expectedHol.add(new Date(17, Month.June, 2008));
        expectedHol.add(new Date(4, Month.August, 2008));
        expectedHol.add(new Date(25, Month.December, 2008));
        expectedHol.add(new Date(26, Month.December, 2008));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.exchange, 2008);
    }

    @Test
    public void testIcelandYear2009() {
        int year = 2009;
        QL.info("Testing " + (Object)((Object)Iceland.Market.ICEX) + " holidays list for the year " + 2009 + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(1, Month.January, 2009));
        expectedHol.add(new Date(9, Month.April, 2009));
        expectedHol.add(new Date(10, Month.April, 2009));
        expectedHol.add(new Date(13, Month.April, 2009));
        expectedHol.add(new Date(23, Month.April, 2009));
        expectedHol.add(new Date(1, Month.May, 2009));
        expectedHol.add(new Date(21, Month.May, 2009));
        expectedHol.add(new Date(1, Month.June, 2009));
        expectedHol.add(new Date(17, Month.June, 2009));
        expectedHol.add(new Date(3, Month.August, 2009));
        expectedHol.add(new Date(25, Month.December, 2009));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.exchange, 2009);
    }

    @Test
    public void testIcelandYear2010() {
        int year = 2010;
        QL.info("Testing " + (Object)((Object)Iceland.Market.ICEX) + " holidays list for the year " + 2010 + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(1, Month.January, 2010));
        expectedHol.add(new Date(1, Month.April, 2010));
        expectedHol.add(new Date(2, Month.April, 2010));
        expectedHol.add(new Date(5, Month.April, 2010));
        expectedHol.add(new Date(22, Month.April, 2010));
        expectedHol.add(new Date(13, Month.May, 2010));
        expectedHol.add(new Date(24, Month.May, 2010));
        expectedHol.add(new Date(17, Month.June, 2010));
        expectedHol.add(new Date(2, Month.August, 2010));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.exchange, 2010);
    }

    @Test
    public void testIcelandYear2011() {
        int year = 2011;
        QL.info("Testing " + (Object)((Object)Iceland.Market.ICEX) + " holidays list for the year " + 2011 + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(3, Month.January, 2011));
        expectedHol.add(new Date(21, Month.April, 2011));
        expectedHol.add(new Date(22, Month.April, 2011));
        expectedHol.add(new Date(25, Month.April, 2011));
        expectedHol.add(new Date(2, Month.June, 2011));
        expectedHol.add(new Date(13, Month.June, 2011));
        expectedHol.add(new Date(17, Month.June, 2011));
        expectedHol.add(new Date(1, Month.August, 2011));
        expectedHol.add(new Date(26, Month.December, 2011));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.exchange, 2011);
    }

    @Test
    public void testIcelandYear2012() {
        int year = 2012;
        QL.info("Testing " + (Object)((Object)Iceland.Market.ICEX) + " holidays list for the year " + 2012 + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(2, Month.January, 2012));
        expectedHol.add(new Date(5, Month.April, 2012));
        expectedHol.add(new Date(6, Month.April, 2012));
        expectedHol.add(new Date(9, Month.April, 2012));
        expectedHol.add(new Date(19, Month.April, 2012));
        expectedHol.add(new Date(1, Month.May, 2012));
        expectedHol.add(new Date(17, Month.May, 2012));
        expectedHol.add(new Date(28, Month.May, 2012));
        expectedHol.add(new Date(6, Month.August, 2012));
        expectedHol.add(new Date(25, Month.December, 2012));
        expectedHol.add(new Date(26, Month.December, 2012));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.exchange, 2012);
    }
}

