/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.testsuite.calendars;

import java.util.ArrayList;
import org.jquantlib.QL;
import org.jquantlib.testsuite.calendars.CalendarUtil;
import org.jquantlib.time.Date;
import org.jquantlib.time.Month;
import org.jquantlib.time.calendars.HongKong;
import org.junit.Test;

public class HongKongCalendarTest {
    public HongKongCalendarTest() {
        QL.info("::::: " + this.getClass().getSimpleName() + " :::::");
    }

    @Test
    public void testHongKongYear2009() {
        int year = 2009;
        QL.info("Testing Hong Kong's holiday list for the year 2009...");
        HongKong c = new HongKong(HongKong.Market.HKEx);
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(1, Month.January, 2009));
        expectedHol.add(new Date(10, Month.April, 2009));
        expectedHol.add(new Date(13, Month.April, 2009));
        expectedHol.add(new Date(1, Month.May, 2009));
        expectedHol.add(new Date(1, Month.July, 2009));
        expectedHol.add(new Date(1, Month.October, 2009));
        expectedHol.add(new Date(25, Month.December, 2009));
        expectedHol.add(new Date(28, Month.December, 2009));
        new CalendarUtil().checkHolidayList(expectedHol, c, 2009);
    }

    @Test
    public void testHongKongYear2008() {
        int year = 2008;
        QL.info("Testing Hong Kong's holiday list for the year 2008...");
        HongKong c = new HongKong(HongKong.Market.HKEx);
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(1, Month.January, 2008));
        expectedHol.add(new Date(7, Month.February, 2008));
        expectedHol.add(new Date(8, Month.February, 2008));
        expectedHol.add(new Date(21, Month.March, 2008));
        expectedHol.add(new Date(24, Month.March, 2008));
        expectedHol.add(new Date(4, Month.April, 2008));
        expectedHol.add(new Date(1, Month.May, 2008));
        expectedHol.add(new Date(12, Month.May, 2008));
        expectedHol.add(new Date(9, Month.June, 2008));
        expectedHol.add(new Date(1, Month.July, 2008));
        expectedHol.add(new Date(15, Month.September, 2008));
        expectedHol.add(new Date(1, Month.October, 2008));
        expectedHol.add(new Date(7, Month.October, 2008));
        expectedHol.add(new Date(25, Month.December, 2008));
        expectedHol.add(new Date(26, Month.December, 2008));
        new CalendarUtil().checkHolidayList(expectedHol, c, 2008);
    }

    @Test
    public void testHongKongYear2007() {
        int year = 2007;
        QL.info("Testing Hong Kong's holiday list for the year 2007...");
        HongKong c = new HongKong(HongKong.Market.HKEx);
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(1, Month.January, 2007));
        expectedHol.add(new Date(1, Month.May, 2007));
        expectedHol.add(new Date(1, Month.October, 2007));
        expectedHol.add(new Date(25, Month.December, 2007));
        expectedHol.add(new Date(26, Month.December, 2007));
        expectedHol.add(new Date(19, Month.February, 2007));
        expectedHol.add(new Date(20, Month.February, 2007));
        expectedHol.add(new Date(5, Month.April, 2007));
        expectedHol.add(new Date(6, Month.April, 2007));
        expectedHol.add(new Date(9, Month.April, 2007));
        expectedHol.add(new Date(24, Month.May, 2007));
        expectedHol.add(new Date(19, Month.June, 2007));
        expectedHol.add(new Date(2, Month.July, 2007));
        expectedHol.add(new Date(26, Month.September, 2007));
        expectedHol.add(new Date(19, Month.October, 2007));
        new CalendarUtil().checkHolidayList(expectedHol, c, 2007);
    }

    @Test
    public void testHongKongYear2006() {
        int year = 2006;
        QL.info("Testing Hong Kong's holiday list for the year 2006...");
        HongKong c = new HongKong(HongKong.Market.HKEx);
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(1, Month.January, 2006));
        expectedHol.add(new Date(1, Month.May, 2006));
        expectedHol.add(new Date(1, Month.October, 2006));
        expectedHol.add(new Date(25, Month.December, 2006));
        expectedHol.add(new Date(26, Month.December, 2006));
        expectedHol.remove(new Date(1, Month.January, 2006));
        expectedHol.remove(new Date(1, Month.October, 2006));
        expectedHol.add(new Date(2, Month.January, 2006));
        expectedHol.add(new Date(30, Month.January, 2006));
        expectedHol.add(new Date(31, Month.January, 2006));
        expectedHol.add(new Date(5, Month.April, 2006));
        expectedHol.add(new Date(14, Month.April, 2006));
        expectedHol.add(new Date(17, Month.April, 2006));
        expectedHol.add(new Date(5, Month.May, 2006));
        expectedHol.add(new Date(31, Month.May, 2006));
        expectedHol.add(new Date(3, Month.July, 2006));
        expectedHol.add(new Date(2, Month.October, 2006));
        expectedHol.add(new Date(30, Month.October, 2006));
        new CalendarUtil().checkHolidayList(expectedHol, c, 2006);
    }

    @Test
    public void testHongKongYear2005() {
        int year = 2005;
        QL.info("Testing Hong Kong's holiday list for the year 2005...");
        HongKong c = new HongKong(HongKong.Market.HKEx);
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(1, Month.January, 2005));
        expectedHol.add(new Date(1, Month.May, 2005));
        expectedHol.add(new Date(1, Month.October, 2005));
        expectedHol.add(new Date(25, Month.December, 2005));
        expectedHol.add(new Date(26, Month.December, 2005));
        expectedHol.remove(new Date(1, Month.January, 2005));
        expectedHol.remove(new Date(1, Month.May, 2005));
        expectedHol.remove(new Date(1, Month.October, 2005));
        expectedHol.remove(new Date(25, Month.December, 2005));
        expectedHol.add(new Date(3, Month.January, 2005));
        expectedHol.add(new Date(9, Month.February, 2005));
        expectedHol.add(new Date(10, Month.February, 2005));
        expectedHol.add(new Date(11, Month.February, 2005));
        expectedHol.add(new Date(25, Month.March, 2005));
        expectedHol.add(new Date(28, Month.March, 2005));
        expectedHol.add(new Date(5, Month.April, 2005));
        expectedHol.remove(new Date(2, Month.May, 2005));
        expectedHol.add(new Date(16, Month.May, 2005));
        expectedHol.add(new Date(1, Month.July, 2005));
        expectedHol.add(new Date(19, Month.September, 2005));
        expectedHol.add(new Date(3, Month.October, 2005));
        expectedHol.add(new Date(11, Month.October, 2005));
        expectedHol.remove(new Date(27, Month.December, 2005));
        new CalendarUtil().checkHolidayList(expectedHol, c, 2005);
    }

    @Test
    public void testHongKongYear2004() {
        int year = 2004;
        QL.info("Testing Hong Kong's holiday list for the year 2004...");
        HongKong c = new HongKong(HongKong.Market.HKEx);
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(1, Month.January, 2004));
        expectedHol.add(new Date(1, Month.May, 2004));
        expectedHol.add(new Date(1, Month.October, 2004));
        expectedHol.add(new Date(25, Month.December, 2004));
        expectedHol.add(new Date(26, Month.December, 2004));
        expectedHol.remove(new Date(1, Month.May, 2004));
        expectedHol.add(new Date(22, Month.January, 2004));
        expectedHol.add(new Date(23, Month.January, 2004));
        expectedHol.add(new Date(5, Month.April, 2004));
        expectedHol.add(new Date(9, Month.April, 2004));
        expectedHol.add(new Date(12, Month.April, 2004));
        expectedHol.add(new Date(26, Month.May, 2004));
        expectedHol.add(new Date(22, Month.June, 2004));
        expectedHol.add(new Date(1, Month.July, 2004));
        expectedHol.add(new Date(29, Month.September, 2004));
        expectedHol.remove(new Date(25, Month.December, 2004));
        expectedHol.remove(new Date(26, Month.December, 2004));
        expectedHol.add(new Date(27, Month.December, 2004));
        new CalendarUtil().checkHolidayList(expectedHol, c, 2004);
    }
}

