/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.testsuite.calendars;

import java.util.List;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.Date;
import org.jquantlib.time.Month;
import org.junit.Assert;

public class CalendarUtil {
    protected void checkHolidayList(List<Date> expected, Calendar calendar, int year) {
        List<Date> calculated = Calendar.holidayList(calendar, new Date(1, Month.January, year), new Date(31, Month.December, year), false);
        int error = 0;
        StringBuilder sb = new StringBuilder();
        sb.append("Holidays do not match\n");
        for (Date date : expected) {
            if (calculated.contains(date)) continue;
            sb.append("  >> Holiday expected but not calculated: ").append((Object)date.weekday()).append(", ").append(date).append('\n');
            ++error;
        }
        for (Date date : calculated) {
            if (expected.contains(date)) continue;
            sb.append("  >> Holiday calculated but not expected: ").append((Object)date.weekday()).append(", ").append(date).append('\n');
            ++error;
        }
        if (error > 0) {
            Assert.fail((String)sb.toString());
        }
    }
}

