/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.testsuite.calendars;

import java.util.ArrayList;
import org.jquantlib.QL;
import org.jquantlib.testsuite.calendars.CalendarUtil;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.Date;
import org.jquantlib.time.Month;
import org.jquantlib.time.calendars.Brazil;
import org.junit.Test;

public class BrazilCalendarTest {
    private final Calendar exchange;
    private final Calendar settlement;

    public BrazilCalendarTest() {
        QL.info("::::: " + this.getClass().getSimpleName() + " :::::");
        this.exchange = new Brazil(Brazil.Market.BOVESPA);
        this.settlement = new Brazil(Brazil.Market.SETTLEMENT);
    }

    @Test
    public void testBrazilBovespaYear2004() {
        int year = 2004;
        QL.info("Testing " + (Object)((Object)Brazil.Market.BOVESPA) + " holiday list for the year " + 2004 + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(1, Month.January, 2004));
        expectedHol.add(new Date(23, Month.February, 2004));
        expectedHol.add(new Date(24, Month.February, 2004));
        expectedHol.add(new Date(9, Month.April, 2004));
        expectedHol.add(new Date(21, Month.April, 2004));
        expectedHol.add(new Date(10, Month.June, 2004));
        expectedHol.add(new Date(9, Month.July, 2004));
        expectedHol.add(new Date(24, Month.December, 2004));
        expectedHol.add(new Date(31, Month.December, 2004));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.exchange, 2004);
    }

    @Test
    public void testBrazilBovespaYear2005() {
        int year = 2005;
        QL.info("Testing " + (Object)((Object)Brazil.Market.BOVESPA) + " holiday list for the year " + 2005 + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(25, Month.January, 2005));
        expectedHol.add(new Date(7, Month.February, 2005));
        expectedHol.add(new Date(8, Month.February, 2005));
        expectedHol.add(new Date(25, Month.March, 2005));
        expectedHol.add(new Date(21, Month.April, 2005));
        expectedHol.add(new Date(26, Month.May, 2005));
        expectedHol.add(new Date(30, Month.December, 2005));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.exchange, 2005);
    }

    @Test
    public void testBrazilBovespaYear2006() {
        int year = 2006;
        QL.info("Testing " + (Object)((Object)Brazil.Market.BOVESPA) + " holiday list for the year " + 2006 + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(25, Month.January, 2006));
        expectedHol.add(new Date(27, Month.February, 2006));
        expectedHol.add(new Date(28, Month.February, 2006));
        expectedHol.add(new Date(14, Month.April, 2006));
        expectedHol.add(new Date(21, Month.April, 2006));
        expectedHol.add(new Date(1, Month.May, 2006));
        expectedHol.add(new Date(15, Month.June, 2006));
        expectedHol.add(new Date(25, Month.December, 2006));
        expectedHol.add(new Date(29, Month.December, 2006));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.exchange, 2006);
    }

    @Test
    public void testBrazilBovespaYear2007() {
        int year = 2007;
        QL.info("Testing " + (Object)((Object)Brazil.Market.BOVESPA) + " holiday list for the year " + 2007 + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(1, Month.January, 2007));
        expectedHol.add(new Date(25, Month.January, 2007));
        expectedHol.add(new Date(19, Month.February, 2007));
        expectedHol.add(new Date(20, Month.February, 2007));
        expectedHol.add(new Date(6, Month.April, 2007));
        expectedHol.add(new Date(1, Month.May, 2007));
        expectedHol.add(new Date(7, Month.June, 2007));
        expectedHol.add(new Date(9, Month.July, 2007));
        expectedHol.add(new Date(20, Month.November, 2007));
        expectedHol.add(new Date(24, Month.December, 2007));
        expectedHol.add(new Date(25, Month.December, 2007));
        expectedHol.add(new Date(31, Month.December, 2007));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.exchange, 2007);
    }

    @Test
    public void testBrazilBovespaYear2008() {
        int year = 2008;
        QL.info("Testing " + (Object)((Object)Brazil.Market.BOVESPA) + " holiday list for the year " + 2008 + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(1, Month.January, 2008));
        expectedHol.add(new Date(25, Month.January, 2008));
        expectedHol.add(new Date(4, Month.February, 2008));
        expectedHol.add(new Date(5, Month.February, 2008));
        expectedHol.add(new Date(21, Month.March, 2008));
        expectedHol.add(new Date(21, Month.April, 2008));
        expectedHol.add(new Date(1, Month.May, 2008));
        expectedHol.add(new Date(22, Month.May, 2008));
        expectedHol.add(new Date(9, Month.July, 2008));
        expectedHol.add(new Date(20, Month.November, 2008));
        expectedHol.add(new Date(24, Month.December, 2008));
        expectedHol.add(new Date(25, Month.December, 2008));
        expectedHol.add(new Date(31, Month.December, 2008));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.exchange, 2008);
    }

    @Test
    public void testBrazilBovespaYear2009() {
        int year = 2009;
        QL.info("Testing " + (Object)((Object)Brazil.Market.BOVESPA) + " holiday list for the year " + 2009 + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(1, Month.January, 2009));
        expectedHol.add(new Date(23, Month.February, 2009));
        expectedHol.add(new Date(24, Month.February, 2009));
        expectedHol.add(new Date(10, Month.April, 2009));
        expectedHol.add(new Date(21, Month.April, 2009));
        expectedHol.add(new Date(1, Month.May, 2009));
        expectedHol.add(new Date(11, Month.June, 2009));
        expectedHol.add(new Date(9, Month.July, 2009));
        expectedHol.add(new Date(20, Month.November, 2009));
        expectedHol.add(new Date(24, Month.December, 2009));
        expectedHol.add(new Date(25, Month.December, 2009));
        expectedHol.add(new Date(31, Month.December, 2009));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.exchange, 2009);
    }

    @Test
    public void testBrazilBovespaYear2010() {
        int year = 2010;
        QL.info("Testing " + (Object)((Object)Brazil.Market.BOVESPA) + " holiday list for the year " + 2010 + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(1, Month.January, 2010));
        expectedHol.add(new Date(25, Month.January, 2010));
        expectedHol.add(new Date(15, Month.February, 2010));
        expectedHol.add(new Date(16, Month.February, 2010));
        expectedHol.add(new Date(2, Month.April, 2010));
        expectedHol.add(new Date(21, Month.April, 2010));
        expectedHol.add(new Date(3, Month.June, 2010));
        expectedHol.add(new Date(9, Month.July, 2010));
        expectedHol.add(new Date(24, Month.December, 2010));
        expectedHol.add(new Date(31, Month.December, 2010));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.exchange, 2010);
    }

    @Test
    public void testBrazilBovespaYear2011() {
        int year = 2011;
        QL.info("Testing " + (Object)((Object)Brazil.Market.BOVESPA) + " holiday list for the year " + 2011 + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(25, Month.January, 2011));
        expectedHol.add(new Date(7, Month.March, 2011));
        expectedHol.add(new Date(8, Month.March, 2011));
        expectedHol.add(new Date(21, Month.April, 2011));
        expectedHol.add(new Date(22, Month.April, 2011));
        expectedHol.add(new Date(23, Month.June, 2011));
        expectedHol.add(new Date(30, Month.December, 2011));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.exchange, 2011);
    }

    @Test
    public void testBrazilBovespaYear2012() {
        int year = 2012;
        QL.info("Testing " + (Object)((Object)Brazil.Market.BOVESPA) + " holiday list for the year " + 2012 + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(25, Month.January, 2012));
        expectedHol.add(new Date(20, Month.February, 2012));
        expectedHol.add(new Date(21, Month.February, 2012));
        expectedHol.add(new Date(6, Month.April, 2012));
        expectedHol.add(new Date(1, Month.May, 2012));
        expectedHol.add(new Date(7, Month.June, 2012));
        expectedHol.add(new Date(9, Month.July, 2012));
        expectedHol.add(new Date(20, Month.November, 2012));
        expectedHol.add(new Date(24, Month.December, 2012));
        expectedHol.add(new Date(25, Month.December, 2012));
        expectedHol.add(new Date(31, Month.December, 2012));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.exchange, 2012);
    }

    @Test
    public void testBrazilSettlementYear2004() {
        int year = 2004;
        QL.info("Testing " + (Object)((Object)Brazil.Market.SETTLEMENT) + " holiday list for the year " + 2004 + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(1, Month.January, 2004));
        expectedHol.add(new Date(23, Month.February, 2004));
        expectedHol.add(new Date(24, Month.February, 2004));
        expectedHol.add(new Date(9, Month.April, 2004));
        expectedHol.add(new Date(21, Month.April, 2004));
        expectedHol.add(new Date(10, Month.June, 2004));
        expectedHol.add(new Date(7, Month.September, 2004));
        expectedHol.add(new Date(12, Month.October, 2004));
        expectedHol.add(new Date(2, Month.November, 2004));
        expectedHol.add(new Date(15, Month.November, 2004));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.settlement, 2004);
    }

    @Test
    public void testBrazilSettlementYear2005() {
        int year = 2005;
        QL.info("Testing " + (Object)((Object)Brazil.Market.SETTLEMENT) + " holiday list for the year " + 2005 + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(7, Month.February, 2005));
        expectedHol.add(new Date(8, Month.February, 2005));
        expectedHol.add(new Date(25, Month.March, 2005));
        expectedHol.add(new Date(21, Month.April, 2005));
        expectedHol.add(new Date(26, Month.May, 2005));
        expectedHol.add(new Date(7, Month.September, 2005));
        expectedHol.add(new Date(12, Month.October, 2005));
        expectedHol.add(new Date(2, Month.November, 2005));
        expectedHol.add(new Date(15, Month.November, 2005));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.settlement, 2005);
    }

    @Test
    public void testBrazilSettlementYear2006() {
        int year = 2006;
        QL.info("Testing " + (Object)((Object)Brazil.Market.SETTLEMENT) + " holiday list for the year " + 2006 + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(27, Month.February, 2006));
        expectedHol.add(new Date(28, Month.February, 2006));
        expectedHol.add(new Date(14, Month.April, 2006));
        expectedHol.add(new Date(21, Month.April, 2006));
        expectedHol.add(new Date(1, Month.May, 2006));
        expectedHol.add(new Date(15, Month.June, 2006));
        expectedHol.add(new Date(7, Month.September, 2006));
        expectedHol.add(new Date(12, Month.October, 2006));
        expectedHol.add(new Date(2, Month.November, 2006));
        expectedHol.add(new Date(15, Month.November, 2006));
        expectedHol.add(new Date(25, Month.December, 2006));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.settlement, 2006);
    }

    @Test
    public void testBrazilSettlementYear2007() {
        int year = 2007;
        QL.info("Testing " + (Object)((Object)Brazil.Market.SETTLEMENT) + " holiday list for the year " + 2007 + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(1, Month.January, 2007));
        expectedHol.add(new Date(19, Month.February, 2007));
        expectedHol.add(new Date(20, Month.February, 2007));
        expectedHol.add(new Date(6, Month.April, 2007));
        expectedHol.add(new Date(1, Month.May, 2007));
        expectedHol.add(new Date(7, Month.June, 2007));
        expectedHol.add(new Date(7, Month.September, 2007));
        expectedHol.add(new Date(12, Month.October, 2007));
        expectedHol.add(new Date(2, Month.November, 2007));
        expectedHol.add(new Date(15, Month.November, 2007));
        expectedHol.add(new Date(25, Month.December, 2007));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.settlement, 2007);
    }

    @Test
    public void testBrazilSettlementYear2008() {
        int year = 2008;
        QL.info("Testing " + (Object)((Object)Brazil.Market.SETTLEMENT) + " holiday list for the year " + 2008 + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(1, Month.January, 2008));
        expectedHol.add(new Date(4, Month.February, 2008));
        expectedHol.add(new Date(5, Month.February, 2008));
        expectedHol.add(new Date(21, Month.March, 2008));
        expectedHol.add(new Date(21, Month.April, 2008));
        expectedHol.add(new Date(1, Month.May, 2008));
        expectedHol.add(new Date(22, Month.May, 2008));
        expectedHol.add(new Date(25, Month.December, 2008));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.settlement, 2008);
    }

    @Test
    public void testBrazilSettlementYear2009() {
        int year = 2009;
        QL.info("Testing " + (Object)((Object)Brazil.Market.SETTLEMENT) + " holiday list for the year " + 2009 + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(1, Month.January, 2009));
        expectedHol.add(new Date(23, Month.February, 2009));
        expectedHol.add(new Date(24, Month.February, 2009));
        expectedHol.add(new Date(10, Month.April, 2009));
        expectedHol.add(new Date(21, Month.April, 2009));
        expectedHol.add(new Date(1, Month.May, 2009));
        expectedHol.add(new Date(11, Month.June, 2009));
        expectedHol.add(new Date(7, Month.September, 2009));
        expectedHol.add(new Date(12, Month.October, 2009));
        expectedHol.add(new Date(2, Month.November, 2009));
        expectedHol.add(new Date(25, Month.December, 2009));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.settlement, 2009);
    }

    @Test
    public void testBrazilSettlementYear2010() {
        int year = 2010;
        QL.info("Testing " + (Object)((Object)Brazil.Market.SETTLEMENT) + " holiday list for the year " + 2010 + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(1, Month.January, 2010));
        expectedHol.add(new Date(15, Month.February, 2010));
        expectedHol.add(new Date(16, Month.February, 2010));
        expectedHol.add(new Date(2, Month.April, 2010));
        expectedHol.add(new Date(21, Month.April, 2010));
        expectedHol.add(new Date(3, Month.June, 2010));
        expectedHol.add(new Date(7, Month.September, 2010));
        expectedHol.add(new Date(12, Month.October, 2010));
        expectedHol.add(new Date(2, Month.November, 2010));
        expectedHol.add(new Date(15, Month.November, 2010));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.settlement, 2010);
    }

    @Test
    public void testBrazilSettlementYear2011() {
        int year = 2011;
        QL.info("Testing " + (Object)((Object)Brazil.Market.SETTLEMENT) + " holiday list for the year " + 2011 + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(7, Month.March, 2011));
        expectedHol.add(new Date(8, Month.March, 2011));
        expectedHol.add(new Date(21, Month.April, 2011));
        expectedHol.add(new Date(22, Month.April, 2011));
        expectedHol.add(new Date(23, Month.June, 2011));
        expectedHol.add(new Date(7, Month.September, 2011));
        expectedHol.add(new Date(12, Month.October, 2011));
        expectedHol.add(new Date(2, Month.November, 2011));
        expectedHol.add(new Date(15, Month.November, 2011));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.settlement, 2011);
    }

    @Test
    public void testBrazilSettlementYear2012() {
        int year = 2012;
        QL.info("Testing " + (Object)((Object)Brazil.Market.SETTLEMENT) + " holiday list for the year " + 2012 + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(20, Month.February, 2012));
        expectedHol.add(new Date(21, Month.February, 2012));
        expectedHol.add(new Date(6, Month.April, 2012));
        expectedHol.add(new Date(1, Month.May, 2012));
        expectedHol.add(new Date(7, Month.June, 2012));
        expectedHol.add(new Date(7, Month.September, 2012));
        expectedHol.add(new Date(12, Month.October, 2012));
        expectedHol.add(new Date(2, Month.November, 2012));
        expectedHol.add(new Date(15, Month.November, 2012));
        expectedHol.add(new Date(25, Month.December, 2012));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.settlement, 2012);
    }
}

