/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.termstructures.yieldcurves;

import org.jquantlib.QL;
import org.jquantlib.daycounters.Actual365Fixed;
import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.termstructures.AbstractYieldTermStructure;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.Date;
import org.jquantlib.time.calendars.Target;

public abstract class ZeroYieldStructure
extends AbstractYieldTermStructure {
    public ZeroYieldStructure() {
        this(new Actual365Fixed());
        QL.validateExperimentalMode();
    }

    public ZeroYieldStructure(DayCounter dc) {
        super(dc);
        QL.validateExperimentalMode();
    }

    public ZeroYieldStructure(Date refDate, Calendar cal) {
        this(refDate, cal, (DayCounter)new Actual365Fixed());
        QL.validateExperimentalMode();
    }

    public ZeroYieldStructure(Date refDate, DayCounter dc) {
        this(refDate, (Calendar)new Target(), dc);
        QL.validateExperimentalMode();
    }

    public ZeroYieldStructure(Date refDate) {
        this(refDate, (Calendar)new Target(), (DayCounter)new Actual365Fixed());
        QL.validateExperimentalMode();
    }

    public ZeroYieldStructure(Date refDate, Calendar cal, DayCounter dc) {
        super(refDate, cal, dc);
        QL.validateExperimentalMode();
    }

    public ZeroYieldStructure(int settlementDays, Calendar cal) {
        this(settlementDays, cal, (DayCounter)new Actual365Fixed());
        QL.validateExperimentalMode();
    }

    public ZeroYieldStructure(int settlementDays, Calendar cal, DayCounter dc) {
        super(settlementDays, cal, dc);
        QL.validateExperimentalMode();
    }

    @Override
    protected double discountImpl(double t) {
        double r = this.zeroYieldImpl(t);
        return Math.exp(-r * t);
    }

    protected abstract double zeroYieldImpl(double var1);
}

