/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.termstructures.yieldcurves;

import org.jquantlib.QL;
import org.jquantlib.Settings;
import org.jquantlib.math.Constants;
import org.jquantlib.termstructures.Compounding;
import org.jquantlib.termstructures.YieldTermStructure;
import org.jquantlib.termstructures.yieldcurves.Traits;
import org.jquantlib.time.Date;
import org.jquantlib.time.Frequency;

public class ZeroYield
implements Traits {
    private static final double avgRate = 0.05;

    public ZeroYield() {
        QL.validateExperimentalMode();
    }

    @Override
    public double initialValue(YieldTermStructure curve) {
        return 0.05;
    }

    @Override
    public double initialGuess() {
        return 0.05;
    }

    @Override
    public double guess(YieldTermStructure c, Date d) {
        return c.zeroRate(d, c.dayCounter(), Compounding.Continuous, Frequency.Annual, true).rate();
    }

    @Override
    public double minValueAfter(int i, double[] data) {
        if (new Settings().isNegativeRates()) {
            return -3.0;
        }
        return Constants.QL_EPSILON;
    }

    @Override
    public double maxValueAfter(int i, double[] data) {
        return 3.0;
    }

    @Override
    public void updateGuess(double[] data, double value, int i) {
        data[i] = value;
        if (i == 1) {
            data[0] = value;
        }
    }

    @Override
    public boolean dummyInitialValue() {
        return true;
    }

    @Override
    public Date initialDate(YieldTermStructure curve) {
        return curve.referenceDate();
    }

    @Override
    public int maxIterations() {
        return 30;
    }
}

