/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.termstructures.yieldcurves;

import org.jquantlib.QL;
import org.jquantlib.Settings;
import org.jquantlib.cashflow.FloatingRateCoupon;
import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.indexes.IborIndex;
import org.jquantlib.indexes.SwapIndex;
import org.jquantlib.instruments.MakeVanillaSwap;
import org.jquantlib.instruments.VanillaSwap;
import org.jquantlib.quotes.Handle;
import org.jquantlib.quotes.Quote;
import org.jquantlib.quotes.RelinkableHandle;
import org.jquantlib.termstructures.YieldTermStructure;
import org.jquantlib.termstructures.yieldcurves.RelativeDateRateHelper;
import org.jquantlib.time.BusinessDayConvention;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.Date;
import org.jquantlib.time.Frequency;
import org.jquantlib.time.Period;
import org.jquantlib.time.TimeUnit;
import org.jquantlib.util.PolymorphicVisitor;
import org.jquantlib.util.Visitor;

public class SwapRateHelper
extends RelativeDateRateHelper {
    private static final double basisPoint = 1.0E-4;
    protected final Period tenor;
    protected final Calendar calendar;
    protected final BusinessDayConvention fixedConvention;
    protected final Frequency fixedFrequency;
    protected final DayCounter fixedDayCount;
    protected final IborIndex iborIndex;
    protected VanillaSwap swap;
    protected RelinkableHandle<YieldTermStructure> termStructureHandle = new RelinkableHandle<Object>(null);
    protected final Handle<Quote> spread;
    protected final Period fwdStart;

    public SwapRateHelper(Handle<Quote> rate, SwapIndex swapIndex) {
        this(rate, swapIndex, new Handle<Quote>(), new Period(0, TimeUnit.Days));
    }

    public SwapRateHelper(Handle<Quote> rate, SwapIndex swapIndex, Handle<Quote> spread) {
        this(rate, swapIndex, spread, new Period(0, TimeUnit.Days));
    }

    public SwapRateHelper(Handle<Quote> rate, SwapIndex swapIndex, Handle<Quote> spread, Period fwdStart) {
        super(rate);
        QL.validateExperimentalMode();
        this.tenor = swapIndex.tenor();
        this.calendar = swapIndex.fixingCalendar();
        this.fixedConvention = swapIndex.fixedLegConvention();
        this.fixedFrequency = swapIndex.fixedLegTenor().frequency();
        this.fixedDayCount = swapIndex.dayCounter();
        this.iborIndex = swapIndex.iborIndex();
        this.spread = spread;
        this.fwdStart = fwdStart;
        this.iborIndex.addObserver(this);
        this.spread.addObserver(this);
        this.initializeDates();
    }

    public SwapRateHelper(Handle<Quote> rate, Period tenor, Calendar calendar, Frequency fixedFrequency, BusinessDayConvention fixedConvention, DayCounter fixedDayCount, IborIndex iborIndex) {
        this(rate, tenor, calendar, fixedFrequency, fixedConvention, fixedDayCount, iborIndex, new Handle<Quote>(), new Period(0, TimeUnit.Days));
    }

    public SwapRateHelper(Handle<Quote> rate, Period tenor, Calendar calendar, Frequency fixedFrequency, BusinessDayConvention fixedConvention, DayCounter fixedDayCount, IborIndex iborIndex, Handle<Quote> spread) {
        this(rate, tenor, calendar, fixedFrequency, fixedConvention, fixedDayCount, iborIndex, spread, new Period(0, TimeUnit.Days));
    }

    public SwapRateHelper(Handle<Quote> rate, Period tenor, Calendar calendar, Frequency fixedFrequency, BusinessDayConvention fixedConvention, DayCounter fixedDayCount, IborIndex iborIndex, Handle<Quote> spread, Period fwdStart) {
        super(rate);
        QL.validateExperimentalMode();
        this.tenor = tenor;
        this.calendar = calendar;
        this.fixedConvention = fixedConvention;
        this.fixedFrequency = fixedFrequency;
        this.fixedDayCount = fixedDayCount;
        this.iborIndex = iborIndex;
        this.spread = spread;
        this.fwdStart = fwdStart;
        this.iborIndex.addObserver(this);
        this.spread.addObserver(this);
        this.initializeDates();
    }

    public SwapRateHelper(double rate, Period tenor, Calendar calendar, Frequency fixedFrequency, BusinessDayConvention fixedConvention, DayCounter fixedDayCount, IborIndex iborIndex) {
        this(rate, tenor, calendar, fixedFrequency, fixedConvention, fixedDayCount, iborIndex, new Handle<Quote>(), new Period(0, TimeUnit.Days));
    }

    public SwapRateHelper(double rate, Period tenor, Calendar calendar, Frequency fixedFrequency, BusinessDayConvention fixedConvention, DayCounter fixedDayCount, IborIndex iborIndex, Handle<Quote> spread) {
        this(rate, tenor, calendar, fixedFrequency, fixedConvention, fixedDayCount, iborIndex, spread, new Period(0, TimeUnit.Days));
    }

    public SwapRateHelper(double rate, Period tenor, Calendar calendar, Frequency fixedFrequency, BusinessDayConvention fixedConvention, DayCounter fixedDayCount, IborIndex iborIndex, Handle<Quote> spread, Period fwdStart) {
        super(rate);
        QL.validateExperimentalMode();
        this.tenor = tenor;
        this.calendar = calendar;
        this.fixedConvention = fixedConvention;
        this.fixedFrequency = fixedFrequency;
        this.fixedDayCount = fixedDayCount;
        this.iborIndex = iborIndex;
        this.spread = spread;
        this.fwdStart = fwdStart;
        this.iborIndex.addObserver(this);
        this.spread.addObserver(this);
        this.initializeDates();
    }

    public SwapRateHelper(double rate, SwapIndex swapIndex) {
        this(rate, swapIndex, new Handle<Quote>(), new Period(0, TimeUnit.Days));
    }

    public SwapRateHelper(double rate, SwapIndex swapIndex, Handle<Quote> spread) {
        this(rate, swapIndex, spread, new Period(0, TimeUnit.Days));
    }

    public SwapRateHelper(double rate, SwapIndex swapIndex, Handle<Quote> spread, Period fwdStart) {
        super(rate);
        QL.validateExperimentalMode();
        this.tenor = swapIndex.tenor();
        this.calendar = swapIndex.fixingCalendar();
        this.fixedConvention = swapIndex.fixedLegConvention();
        this.fixedFrequency = swapIndex.fixedLegTenor().frequency();
        this.fixedDayCount = swapIndex.dayCounter();
        this.iborIndex = swapIndex.iborIndex();
        this.spread = spread;
        this.fwdStart = fwdStart;
        this.iborIndex.addObserver(this);
        this.spread.addObserver(this);
        this.initializeDates();
    }

    @Override
    protected void initializeDates() {
        IborIndex clonedIborIndex = this.iborIndex.clone(this.termStructureHandle).currentLink();
        this.swap = new MakeVanillaSwap(this.tenor, clonedIborIndex, 0.0, this.fwdStart).withFixedLegDayCount(this.fixedDayCount).withFixedLegTenor(new Period(this.fixedFrequency)).withFixedLegConvention(this.fixedConvention).withFixedLegTerminationDateConvention(this.fixedConvention).withFixedLegCalendar(this.calendar).withFloatingLegCalendar(this.calendar).value();
        this.earliestDate = this.swap.startDate();
        this.latestDate = this.swap.maturityDate();
        if (new Settings().isUseIndexedCoupon()) {
            FloatingRateCoupon lastFloating = (FloatingRateCoupon)this.swap.floatingLeg().last();
            Date fixingValueDate = this.iborIndex.valueDate(lastFloating.fixingDate());
            Date endValueDate = this.iborIndex.maturityDate(fixingValueDate);
            this.latestDate = Date.max(this.latestDate, endValueDate);
        }
    }

    @Override
    public void setTermStructure(YieldTermStructure t) {
        this.termStructureHandle.linkTo(t, false);
        super.setTermStructure(t);
    }

    @Override
    public double impliedQuote() {
        QL.require(this.termStructure != null, "term structure not set");
        this.swap.recalculate();
        double floatingLegNPV = this.swap.floatingLegNPV();
        double spread = this.spread.empty() ? 0.0 : this.spread.currentLink().value();
        double spreadNPV = this.swap.floatingLegBPS() / 1.0E-4 * spread;
        double totNPV = -(floatingLegNPV + spreadNPV);
        double result = totNPV / (this.swap.fixedLegBPS() / 1.0E-4);
        return result;
    }

    public double spread() {
        return this.spread.empty() ? 0.0 : this.spread.currentLink().value();
    }

    public VanillaSwap swap() {
        return this.swap;
    }

    public final Period forwardStart() {
        return this.fwdStart;
    }

    @Override
    public void accept(PolymorphicVisitor pv) {
        Visitor<?> v;
        Visitor<?> visitor = v = pv != null ? pv.visitor(this.getClass()) : null;
        if (v != null) {
            v.visit(this);
        } else {
            super.accept(pv);
        }
    }
}

