/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.termstructures.yieldcurves;

import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.quotes.Handle;
import org.jquantlib.termstructures.AbstractYieldTermStructure;
import org.jquantlib.termstructures.YieldTermStructure;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.Date;

public class ImpliedTermStructure<T extends YieldTermStructure>
extends AbstractYieldTermStructure {
    private final Handle<T> originalCurve;

    public ImpliedTermStructure(Handle<T> h, Date referenceDate) {
        super(referenceDate);
        this.originalCurve = h;
        this.originalCurve.addObserver(this);
    }

    @Override
    public DayCounter dayCounter() {
        return ((YieldTermStructure)this.originalCurve.currentLink()).dayCounter();
    }

    @Override
    public Calendar calendar() {
        return ((YieldTermStructure)this.originalCurve.currentLink()).calendar();
    }

    @Override
    public int settlementDays() {
        return ((YieldTermStructure)this.originalCurve.currentLink()).settlementDays();
    }

    @Override
    public Date maxDate() {
        return ((YieldTermStructure)this.originalCurve.currentLink()).maxDate();
    }

    @Override
    protected double discountImpl(double t) {
        Date ref = this.referenceDate();
        double originalTime = t + this.dayCounter().yearFraction(((YieldTermStructure)this.originalCurve.currentLink()).referenceDate(), ref);
        return ((YieldTermStructure)this.originalCurve.currentLink()).discount(originalTime, true) / ((YieldTermStructure)this.originalCurve.currentLink()).discount(ref, true);
    }
}

