/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.termstructures.yieldcurves;

import org.jquantlib.QL;
import org.jquantlib.Settings;
import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.instruments.bonds.FixedRateBond;
import org.jquantlib.pricingengines.bond.DiscountingBondEngine;
import org.jquantlib.quotes.Handle;
import org.jquantlib.quotes.Quote;
import org.jquantlib.quotes.RelinkableHandle;
import org.jquantlib.termstructures.RateHelper;
import org.jquantlib.termstructures.YieldTermStructure;
import org.jquantlib.time.BusinessDayConvention;
import org.jquantlib.time.Date;
import org.jquantlib.time.Schedule;
import org.jquantlib.util.PolymorphicVisitor;
import org.jquantlib.util.Visitor;

public class FixedRateBondHelper
extends RateHelper {
    private FixedRateBond bond;
    private final RelinkableHandle<YieldTermStructure> termStructureHandle = new RelinkableHandle<Object>(null);

    public FixedRateBondHelper(Handle<Quote> cleanPrice, int settlementDays, double faceAmount, Schedule schedule, double[] coupons, DayCounter dayCounter) {
        this(cleanPrice, settlementDays, faceAmount, schedule, coupons, dayCounter, BusinessDayConvention.Following, 100.0, new Date());
    }

    public FixedRateBondHelper(Handle<Quote> cleanPrice, int settlementDays, double faceAmount, Schedule schedule, double[] coupons, DayCounter dayCounter, BusinessDayConvention paymentConvention, double redemption, Date issueDate) {
        super(cleanPrice);
        QL.validateExperimentalMode();
        this.bond = new FixedRateBond(settlementDays, faceAmount, schedule, coupons, dayCounter, paymentConvention, redemption, issueDate);
        this.latestDate = this.bond.maturityDate();
        new Settings().evaluationDate().addObserver(this);
        DiscountingBondEngine bondEngine = new DiscountingBondEngine(this.termStructureHandle);
        this.bond.setPricingEngine(bondEngine);
    }

    public FixedRateBondHelper(Handle<Quote> cleanPrice, FixedRateBond bond) {
        super(cleanPrice);
        QL.validateExperimentalMode();
        this.latestDate = bond.maturityDate();
        new Settings().evaluationDate().addObserver(this);
        DiscountingBondEngine bondEngine = new DiscountingBondEngine(this.termStructureHandle);
        this.bond.setPricingEngine(bondEngine);
    }

    public FixedRateBond bond() {
        return this.bond;
    }

    @Override
    public void setTermStructure(YieldTermStructure t) {
        this.termStructureHandle.linkTo(t, false);
        super.setTermStructure(t);
    }

    @Override
    public double impliedQuote() {
        QL.require(this.termStructure != null, "term structure not set");
        this.bond.recalculate();
        return this.bond.cleanPrice();
    }

    @Override
    public void accept(PolymorphicVisitor pv) {
        Visitor<?> v;
        Visitor<?> visitor = v = pv != null ? pv.visitor(this.getClass()) : null;
        if (v != null) {
            v.visit(this);
        } else {
            super.accept(pv);
        }
    }
}

