/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.termstructures.yieldcurves;

import org.jquantlib.QL;
import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.indexes.BMAIndex;
import org.jquantlib.indexes.IborIndex;
import org.jquantlib.instruments.BMASwap;
import org.jquantlib.lang.annotation.Natural;
import org.jquantlib.pricingengines.swap.DiscountingSwapEngine;
import org.jquantlib.quotes.Handle;
import org.jquantlib.quotes.Quote;
import org.jquantlib.quotes.RelinkableHandle;
import org.jquantlib.termstructures.YieldTermStructure;
import org.jquantlib.termstructures.yieldcurves.RelativeDateRateHelper;
import org.jquantlib.time.BusinessDayConvention;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.Date;
import org.jquantlib.time.MakeSchedule;
import org.jquantlib.time.Period;
import org.jquantlib.time.Schedule;
import org.jquantlib.time.TimeUnit;
import org.jquantlib.time.Weekday;
import org.jquantlib.util.PolymorphicVisitor;
import org.jquantlib.util.Visitor;

public class BMASwapRateHelper
extends RelativeDateRateHelper {
    protected final Period tenor;
    protected int settlementDays;
    protected final Calendar calendar;
    protected final Period bmaPeriod;
    protected final BusinessDayConvention bmaConvention;
    protected final DayCounter bmaDayCount;
    protected final BMAIndex bmaIndex;
    protected final IborIndex iborIndex;
    protected BMASwap swap;
    protected RelinkableHandle<YieldTermStructure> termStructureHandle = new RelinkableHandle<Object>(null);

    public BMASwapRateHelper(Handle<Quote> liborFraction, Period tenor, @Natural int settlementDays, Calendar calendar, Period bmaPeriod, BusinessDayConvention bmaConvention, DayCounter bmaDayCount, BMAIndex bmaIndex, IborIndex iborIndex) {
        super(liborFraction);
        QL.validateExperimentalMode();
        this.tenor = tenor;
        this.settlementDays = settlementDays;
        this.calendar = calendar;
        this.bmaPeriod = bmaPeriod;
        this.bmaConvention = bmaConvention;
        this.bmaDayCount = bmaDayCount;
        this.bmaIndex = bmaIndex;
        this.iborIndex = iborIndex;
        this.iborIndex.addObserver(this);
        this.bmaIndex.addObserver(this);
        this.initializeDates();
    }

    @Override
    protected void initializeDates() {
        this.earliestDate = this.calendar.advance(this.evaluationDate, new Period(this.settlementDays, TimeUnit.Days), BusinessDayConvention.Following);
        Date maturity = this.earliestDate.add(this.tenor);
        BMAIndex clonedIndex = this.bmaIndex.clone(this.termStructureHandle);
        Schedule bmaSchedule = new MakeSchedule(this.earliestDate, maturity, this.bmaPeriod, this.bmaIndex.fixingCalendar(), this.bmaConvention).backwards().schedule();
        Schedule liborSchedule = new MakeSchedule(this.earliestDate, maturity, this.iborIndex.tenor(), this.iborIndex.fixingCalendar(), this.iborIndex.businessDayConvention()).endOfMonth(this.iborIndex.endOfMonth()).schedule();
        this.swap = new BMASwap(BMASwap.Type.Payer, 100.0, liborSchedule, 0.75, 0.0, this.iborIndex, this.iborIndex.dayCounter(), bmaSchedule, clonedIndex, this.bmaDayCount);
        this.swap.setPricingEngine(new DiscountingSwapEngine(this.iborIndex.termStructure()));
        Date d = this.calendar.adjust(this.swap.maturityDate(), BusinessDayConvention.Following);
        Weekday w = d.weekday();
        Date nextWednesday = w.value() >= 4 ? d.add(11 - w.value()) : d.add(4 - w.value());
        this.latestDate = clonedIndex.valueDate(clonedIndex.fixingCalendar().adjust(nextWednesday));
    }

    @Override
    public void setTermStructure(YieldTermStructure t) {
        this.termStructureHandle.linkTo(t, false);
        super.setTermStructure(t);
    }

    @Override
    public double impliedQuote() {
        QL.require(this.termStructure != null, "term structure not set");
        this.swap.recalculate();
        return this.swap.fairLiborFraction();
    }

    @Override
    public void accept(PolymorphicVisitor pv) {
        Visitor<?> v;
        Visitor<?> visitor = v = pv != null ? pv.visitor(this.getClass()) : null;
        if (v != null) {
            v.visit(this);
        } else {
            super.accept(pv);
        }
    }
}

